/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.config.verify;

import java.util.logging.Level;
import java.util.logging.Logger;
import tech.grasshopper.pdf.config.DetailedConfig;
import tech.grasshopper.pdf.config.verify.VerifyConfiguration;

public class VerifyHookConfiguration
extends VerifyConfiguration {
    private static final Logger logger = Logger.getLogger(VerifyHookConfiguration.class.getName());

    @Override
    public void verify() {
        DetailedConfig.DetailedStepHookConfig detailedStepHookConfig = this.reportConfig.getDetailedStepHookConfig();
        if (detailedStepHookConfig.isSkipScenarioHooks() && !detailedStepHookConfig.isSkipHooks()) {
            logger.log(Level.INFO, "'skipScenarioBeforeHooks' and 'skipScenarioAfterHooks' configuration values will be ignored as 'skipScenarioHooks' is set to true.");
            detailedStepHookConfig.setSkipScenarioBeforeHooks(true);
            detailedStepHookConfig.setSkipScenarioAfterHooks(true);
        }
        if (detailedStepHookConfig.isSkipStepHooks() && !detailedStepHookConfig.isSkipHooks()) {
            logger.log(Level.INFO, "'skipStepBeforeHooks' and 'skipStepAfterHooks' configuration values will be ignored as 'skipStepHooks' is set to true.");
            detailedStepHookConfig.setSkipStepBeforeHooks(true);
            detailedStepHookConfig.setSkipStepAfterHooks(true);
        }
        if (detailedStepHookConfig.isSkipHooks()) {
            logger.log(Level.INFO, "All other hook configuration values will be ignored as 'skipHooks' is set to true.");
            detailedStepHookConfig.setSkipScenarioHooks(true);
            detailedStepHookConfig.setSkipScenarioBeforeHooks(true);
            detailedStepHookConfig.setSkipScenarioAfterHooks(true);
            detailedStepHookConfig.setSkipStepHooks(true);
            detailedStepHookConfig.setSkipStepBeforeHooks(true);
            detailedStepHookConfig.setSkipStepAfterHooks(true);
        }
    }

    protected VerifyHookConfiguration(VerifyHookConfigurationBuilder<?, ?> b) {
        super(b);
    }

    public static VerifyHookConfigurationBuilder<?, ?> builder() {
        return new VerifyHookConfigurationBuilderImpl();
    }

    private static final class VerifyHookConfigurationBuilderImpl
    extends VerifyHookConfigurationBuilder<VerifyHookConfiguration, VerifyHookConfigurationBuilderImpl> {
        private VerifyHookConfigurationBuilderImpl() {
        }

        @Override
        protected VerifyHookConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public VerifyHookConfiguration build() {
            return new VerifyHookConfiguration(this);
        }
    }

    public static abstract class VerifyHookConfigurationBuilder<C extends VerifyHookConfiguration, B extends VerifyHookConfigurationBuilder<C, B>>
    extends VerifyConfiguration.VerifyConfigurationBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VerifyHookConfiguration.VerifyHookConfigurationBuilder(super=" + super.toString() + ")";
        }
    }
}

