/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.pojo.cucumber;

import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.section.details.executable.ExecutableDisplay;
import tech.grasshopper.pdf.section.details.executable.HookDisplay;

public class Hook
extends Executable {
    private HookType hookType;

    @Override
    public ExecutableDisplay getDisplay() {
        return ((HookDisplay.HookDisplayBuilder)HookDisplay.builder().executable(this)).build();
    }

    @Override
    public String getName() {
        return this.location;
    }

    @Override
    public void checkData() {
        if (this.location == null || this.location.isEmpty()) {
            throw new PdfReportException("Location is null or empty for hook - " + this.getName());
        }
        if (this.status == null) {
            throw new PdfReportException("No status present for hook - " + this.getName());
        }
        super.checkData();
    }

    protected Hook(HookBuilder<?, ?> b) {
        super((Executable.ExecutableBuilder<?, ?>)b);
        this.hookType = b.hookType;
    }

    public static HookBuilder<?, ?> builder() {
        return new HookBuilderImpl();
    }

    public HookType getHookType() {
        return this.hookType;
    }

    public void setHookType(HookType hookType) {
        this.hookType = hookType;
    }

    @Override
    public String toString() {
        return "Hook(hookType=" + this.getHookType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hook)) {
            return false;
        }
        Hook other = (Hook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HookType this$hookType = this.getHookType();
        HookType other$hookType = other.getHookType();
        return !(this$hookType == null ? other$hookType != null : !((Object)((Object)this$hookType)).equals((Object)other$hookType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Hook;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HookType $hookType = this.getHookType();
        result = result * 59 + ($hookType == null ? 43 : ((Object)((Object)$hookType)).hashCode());
        return result;
    }

    private static final class HookBuilderImpl
    extends HookBuilder<Hook, HookBuilderImpl> {
        private HookBuilderImpl() {
        }

        @Override
        protected HookBuilderImpl self() {
            return this;
        }

        @Override
        public Hook build() {
            return new Hook(this);
        }
    }

    public static abstract class HookBuilder<C extends Hook, B extends HookBuilder<C, B>>
    extends Executable.ExecutableBuilder<C, B> {
        private HookType hookType;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B hookType(HookType hookType) {
            this.hookType = hookType;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Hook.HookBuilder(super=" + super.toString() + ", hookType=" + this.hookType + ")";
        }
    }

    public static enum HookType {
        BEFORE,
        AFTER,
        BEFORE_STEP,
        AFTER_STEP;

    }
}

