/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.attributes;

import java.util.List;
import java.util.function.Consumer;
import tech.grasshopper.pdf.data.AttributeData;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.pojo.cucumber.Device;
import tech.grasshopper.pdf.section.attributes.AttributeSection;

public class DeviceSection
extends AttributeSection {
    @Override
    public DisplayData createDisplayData(int fromIndex, int toIndex) {
        List<Device> pageDevices = ((AttributeData.DeviceData)this.attributeData).getDevices().subList(fromIndex, toIndex);
        return AttributeData.DeviceData.builder().devices(pageDevices).build();
    }

    @Override
    public int maxDataCountPerPage() {
        return this.reportConfig.getDeviceConfig().dataCount();
    }

    @Override
    public String attributeType() {
        return "DEVICE";
    }

    @Override
    public Consumer<Destination> attributeDestinationConsumer() {
        return this.destinations::addDeviceDestination;
    }

    protected DeviceSection(DeviceSectionBuilder<?, ?> b) {
        super((AttributeSection.AttributeSectionBuilder<?, ?>)b);
    }

    public static DeviceSectionBuilder<?, ?> builder() {
        return new DeviceSectionBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceSection)) {
            return false;
        }
        DeviceSection other = (DeviceSection)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeviceSection;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class DeviceSectionBuilderImpl
    extends DeviceSectionBuilder<DeviceSection, DeviceSectionBuilderImpl> {
        private DeviceSectionBuilderImpl() {
        }

        @Override
        protected DeviceSectionBuilderImpl self() {
            return this;
        }

        @Override
        public DeviceSection build() {
            return new DeviceSection(this);
        }
    }

    public static abstract class DeviceSectionBuilder<C extends DeviceSection, B extends DeviceSectionBuilder<C, B>>
    extends AttributeSection.AttributeSectionBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DeviceSection.DeviceSectionBuilder(super=" + super.toString() + ")";
        }
    }
}

