/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import java.awt.Color;
import java.awt.Font;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.PieStyler;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.chart.ReportBarChart;
import tech.grasshopper.pdf.chart.ReportDonutChart;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.image.ImageCreator;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.util.DateUtil;

public class DetailedScenarioDisplay
extends Display
implements DestinationAware {
    private Scenario scenario;
    private Feature feature;
    private float finalY;
    private int destinationY;
    private static final PDFont FEATURE_FONT = ReportFont.ITALIC_FONT;
    private static final int FEATURE_FONT_SIZE = 10;
    private static final PDFont SCENARIO_FONT = ReportFont.BOLD_FONT;
    private static final int SCENARIO_FONT_SIZE = 13;
    private static final PDFont TAGS_FONT = ReportFont.REGULAR_FONT;
    private static final int TAGS_FONT_SIZE = 10;
    private static final float STATUS_COLUMN_WIDTH = 75.0f;
    private static final float DURATION_COLUMN_WIDTH = 185.0f;
    private static final float STEP_DURATION_BAR_COLUMN_WIDTH = 340.0f;
    private static final float STEP_COUNT_COLUMN_WIDTH = 60.0f;
    private static final float STEP_CHART_COLUMN_WIDTH = 100.0f;
    private static final float FEATURE_PADDING = 4.0f;
    private static final float SCENARIO_PADDING = 5.0f;
    private static final float SCENARIO_LEFT_PADDING = 25.0f;
    private static final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(FEATURE_FONT).fontsize(10).availableSpace(252.0f).maxLines(2).build();
    private static final TextLengthOptimizer tagsTextOptimizer = TextLengthOptimizer.builder().font(TAGS_FONT).fontsize(10).availableSpace(252.0f).maxLines(3).build();

    @Override
    public void display() {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        PDPage initialPage = this.document.getPage(this.document.getNumberOfPages() - 1);
        this.destinationY = (int)this.ylocation;
        String tags = this.scenario.getTags().stream().collect(Collectors.joining(" "));
        Table.TableBuilder nameTableBuilder = Table.builder().addColumnsOfWidth(new float[]{760.0f}).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP).addRow(Row.builder().font(SCENARIO_FONT).fontSize(Integer.valueOf(13)).borderWidth(0.0f).padding(5.0f).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().wordBreak(Boolean.valueOf(true))).paddingLeft(25.0f)).text(sanitizer.sanitizeText(this.scenario.getName())).textColor(this.reportConfig.getDetailedScenarioConfig().scenarioNameColor())).build()).build());
        Object nameTableCreator = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(nameTableBuilder)).document(this.document)).startX(40.0f)).startY(this.ylocation)).endY(40.0f)).splitRow(true)).repeatRows(0)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageWithHeaderAndNumberSupplier("DETAILED SECTION"))).build();
        ((TableCreator)nameTableCreator).displayTable();
        this.ylocation = ((TableCreator)nameTableCreator).getFinalY();
        this.page = ((TableCreator)nameTableCreator).getTableStartPage();
        if (!initialPage.equals((Object)this.page)) {
            this.destinationY = 550;
        }
        this.createDestination();
        Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{75.0f, 185.0f, 340.0f, 60.0f, 100.0f}).borderWidth(1.0f).borderColor(Color.GRAY).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP).font(ReportFont.REGULAR_FONT).addRow(Row.builder().fontSize(Integer.valueOf(10)).font(ReportFont.ITALIC_FONT).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(this.scenario.getStatus().toString()).backgroundColor(this.statusColor(this.scenario.getStatus()))).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("DURATION - " + DateUtil.durationValue(this.scenario.calculatedDuration())).textColor(this.reportConfig.getDetailedScenarioConfig().durationColor())).backgroundColor(this.reportConfig.getDetailedScenarioConfig().durationBackgroundColor())).build()).add((AbstractCell)((ImageCell.ImageCellBuilder)ImageCell.builder().rowSpan(4)).image(this.stepsChart()).build()).add((AbstractCell)((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().lineSpacing(1.5f).rowSpan(4)).paragraph(this.stepsData()).font(ReportFont.REGULAR_FONT).backgroundColor(this.reportConfig.getDetailedScenarioConfig().dataBackgroundColor())).build()).add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().rowSpan(4)).image(this.stepsDonut()).horizontalAlignment(HorizontalAlignment.CENTER)).verticalAlignment(VerticalAlignment.MIDDLE)).build()).build()).addRow(Row.builder().fontSize(Integer.valueOf(10)).font(ReportFont.ITALIC_FONT).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().colSpan(2)).text("/ " + DateUtil.formatTimeWithMillis(this.scenario.getStartTime()) + " // " + DateUtil.formatTimeWithMillis(this.scenario.getEndTime()) + " /").textColor(this.reportConfig.getDetailedScenarioConfig().startEndTimeColor())).build()).build()).addRow(Row.builder().fontSize(Integer.valueOf(10)).font(FEATURE_FONT).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().colSpan(2)).padding(4.0f)).wordBreak(Boolean.valueOf(true))).text(sanitizer.sanitizeText(featureNameTextOptimizer.optimizeTextLines(this.feature.getName()))).textColor(this.reportConfig.getDetailedScenarioConfig().featureNameColor())).build()).build()).addRow(Row.builder().fontSize(Integer.valueOf(10)).font(TAGS_FONT).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().colSpan(2)).wordBreak(Boolean.valueOf(true))).text(sanitizer.sanitizeText(tagsTextOptimizer.optimizeTextLines(tags))).textColor(this.reportConfig.getDetailedScenarioConfig().tagColor())).build()).build());
        Object tableCreator = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(tableBuilder)).document(this.document)).startX(40.0f)).startY(this.ylocation)).endY(40.0f)).repeatRows(4)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageWithHeaderAndNumberSupplier("DETAILED SECTION"))).build();
        ((TableCreator)tableCreator).displayTable();
        this.finalY = ((TableCreator)tableCreator).getFinalY();
    }

    @Override
    public void createDestination() {
        Destination destination = Destination.builder().yCoord(this.destinationY).page(this.page).build();
        this.scenario.setDestination(destination);
    }

    private ParagraphCell.Paragraph stepsData() {
        return this.createData("Steps", this.scenario.getTotalSteps(), this.scenario.getPassedSteps(), this.scenario.getFailedSteps(), this.scenario.getSkippedSteps());
    }

    private PDImageXObject stepsDonut() {
        ReportDonutChart chart = new ReportDonutChart(80, 80);
        this.updateChartStyler((PieStyler)chart.getStyler());
        HashMap<String, Number> data = new HashMap<String, Number>();
        data.put("Passed", this.scenario.getPassedSteps());
        data.put("Failed", this.scenario.getFailedSteps());
        data.put("Skipped", this.scenario.getSkippedSteps());
        chart.updateData(data);
        return ImageCreator.builder().chart((Chart<?, ?>)chart).document(this.document).build().generateChartImageXObject();
    }

    private void updateChartStyler(PieStyler styler) {
        styler.setSumFontSize(16.0f);
        styler.setDonutThickness(0.4);
        styler.setSeriesColors(new Color[]{this.reportConfig.passedColor(), this.reportConfig.failedColor(), this.reportConfig.skippedColor()});
    }

    private PDImageXObject stepsChart() {
        ReportBarChart chart = new ReportBarChart(340, 110);
        List<Double> data = this.scenario.getSteps().stream().map(s -> DateUtil.duration(s.getStartTime(), s.getEndTime())).collect(Collectors.toList());
        if (data.size() > this.reportConfig.getDetailedStepHookConfig().stepCount()) {
            data = data.subList(0, this.reportConfig.getDetailedStepHookConfig().stepCount());
        }
        this.updateBarChartStyler((CategoryStyler)chart.getStyler(), data);
        chart.updateData(data);
        return ImageCreator.builder().chart((Chart<?, ?>)chart).document(this.document).build().generateChartImageXObject();
    }

    private void updateBarChartStyler(CategoryStyler styler, List<Double> data) {
        double maxVal = (Double)data.stream().max(Comparator.naturalOrder()).get();
        if (maxVal <= 0.1) {
            styler.setYAxisMax(Double.valueOf(0.15));
        } else if (maxVal <= 0.25) {
            styler.setYAxisMax(Double.valueOf(0.35));
        } else if (maxVal <= 0.5) {
            styler.setYAxisMax(Double.valueOf(0.65));
        } else {
            styler.setYAxisMax(Double.valueOf(Math.floor(maxVal) + 1.0));
        }
        styler.setSeriesColors(new Color[]{this.reportConfig.getDetailedScenarioConfig().stepChartBarColor()});
        styler.setAvailableSpaceFill(0.4 * (double)data.size() / 10.0);
        Font axisFont = new Font("Dialog", 0, 8);
        styler.setAxisTickLabelsFont(axisFont);
    }

    private ParagraphCell.Paragraph createData(String header, int total, int pass, int fail, int skip) {
        return ParagraphCell.Paragraph.builder().append(StyledText.builder().fontSize(Float.valueOf(11.0f)).text(header).color(this.reportConfig.getDetailedScenarioConfig().dataHeaderColor()).build()).appendNewLine().append(this.createDataTitle("Total", this.reportConfig.getDetailedScenarioConfig().totalColor())).append(this.createDataValue(total, this.reportConfig.getDetailedScenarioConfig().totalColor())).appendNewLine().append(this.createDataTitle("Pass", this.reportConfig.passedColor())).append(this.createDataValue(pass, this.reportConfig.passedColor())).appendNewLine().append(this.createDataTitle("Fail", this.reportConfig.failedColor())).append(this.createDataValue(fail, this.reportConfig.failedColor())).appendNewLine().append(this.createDataTitle("Skip", this.reportConfig.skippedColor())).append(this.createDataValue(skip, this.reportConfig.skippedColor())).appendNewLine().build();
    }

    private StyledText createDataTitle(String text, Color color) {
        return StyledText.builder().fontSize(Float.valueOf(10.0f)).text(text + " - ").color(color).build();
    }

    private StyledText createDataValue(int value, Color color) {
        return StyledText.builder().fontSize(Float.valueOf(11.0f)).text(String.valueOf(value)).color(color).build();
    }

    protected DetailedScenarioDisplay(DetailedScenarioDisplayBuilder<?, ?> b) {
        super(b);
        this.scenario = b.scenario;
        this.feature = b.feature;
        this.finalY = b.finalY;
        this.destinationY = b.destinationY;
    }

    public static DetailedScenarioDisplayBuilder<?, ?> builder() {
        return new DetailedScenarioDisplayBuilderImpl();
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getDestinationY() {
        return this.destinationY;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setFinalY(float finalY) {
        this.finalY = finalY;
    }

    public void setDestinationY(int destinationY) {
        this.destinationY = destinationY;
    }

    @Override
    public String toString() {
        return "DetailedScenarioDisplay(scenario=" + this.getScenario() + ", feature=" + this.getFeature() + ", finalY=" + this.getFinalY() + ", destinationY=" + this.getDestinationY() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedScenarioDisplay)) {
            return false;
        }
        DetailedScenarioDisplay other = (DetailedScenarioDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getFinalY(), other.getFinalY()) != 0) {
            return false;
        }
        if (this.getDestinationY() != other.getDestinationY()) {
            return false;
        }
        Scenario this$scenario = this.getScenario();
        Scenario other$scenario = other.getScenario();
        if (this$scenario == null ? other$scenario != null : !((Object)this$scenario).equals(other$scenario)) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        return !(this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailedScenarioDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getFinalY());
        result = result * 59 + this.getDestinationY();
        Scenario $scenario = this.getScenario();
        result = result * 59 + ($scenario == null ? 43 : ((Object)$scenario).hashCode());
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        return result;
    }

    public float getFinalY() {
        return this.finalY;
    }

    private static final class DetailedScenarioDisplayBuilderImpl
    extends DetailedScenarioDisplayBuilder<DetailedScenarioDisplay, DetailedScenarioDisplayBuilderImpl> {
        private DetailedScenarioDisplayBuilderImpl() {
        }

        @Override
        protected DetailedScenarioDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DetailedScenarioDisplay build() {
            return new DetailedScenarioDisplay(this);
        }
    }

    public static abstract class DetailedScenarioDisplayBuilder<C extends DetailedScenarioDisplay, B extends DetailedScenarioDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Scenario scenario;
        private Feature feature;
        private float finalY;
        private int destinationY;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B scenario(Scenario scenario) {
            this.scenario = scenario;
            return (B)this.self();
        }

        public B feature(Feature feature) {
            this.feature = feature;
            return (B)this.self();
        }

        public B finalY(float finalY) {
            this.finalY = finalY;
            return (B)this.self();
        }

        public B destinationY(int destinationY) {
            this.destinationY = destinationY;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DetailedScenarioDisplay.DetailedScenarioDisplayBuilder(super=" + super.toString() + ", scenario=" + this.scenario + ", feature=" + this.feature + ", finalY=" + this.finalY + ", destinationY=" + this.destinationY + ")";
        }
    }
}

