/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable;

import java.awt.Color;
import java.util.List;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.section.details.executable.table.TableCellWithMessage;
import tech.grasshopper.pdf.section.details.executable.table.TableColumnOptimizer;

public class DataTableDisplay {
    private Step step;
    private Color textColor;
    private Color backgroundColor;
    private final int fontsize = 9;
    private boolean columnsCropped;
    private boolean cellTextCropped;
    private List<Float> maximumColumnTextWidths;

    public AbstractCell display() {
        List<Float> columnTextWidths = TableColumnOptimizer.builder().rows(this.step.getRows()).fontsize(9).build().organizeColumnStructure();
        return TableCellWithMessage.builder().rows(this.step.getRows()).columnTextWidths(columnTextWidths).backgroundColor(this.backgroundColor).fontsize(9).textColor(this.textColor).build().createTableCell();
    }

    DataTableDisplay(Step step, Color textColor, Color backgroundColor, boolean columnsCropped, boolean cellTextCropped, List<Float> maximumColumnTextWidths) {
        this.step = step;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.columnsCropped = columnsCropped;
        this.cellTextCropped = cellTextCropped;
        this.maximumColumnTextWidths = maximumColumnTextWidths;
    }

    public static DataTableDisplayBuilder builder() {
        return new DataTableDisplayBuilder();
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static class DataTableDisplayBuilder {
        private Step step;
        private Color textColor;
        private Color backgroundColor;
        private boolean columnsCropped;
        private boolean cellTextCropped;
        private List<Float> maximumColumnTextWidths;

        DataTableDisplayBuilder() {
        }

        public DataTableDisplayBuilder step(Step step) {
            this.step = step;
            return this;
        }

        public DataTableDisplayBuilder textColor(Color textColor) {
            this.textColor = textColor;
            return this;
        }

        public DataTableDisplayBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public DataTableDisplayBuilder columnsCropped(boolean columnsCropped) {
            this.columnsCropped = columnsCropped;
            return this;
        }

        public DataTableDisplayBuilder cellTextCropped(boolean cellTextCropped) {
            this.cellTextCropped = cellTextCropped;
            return this;
        }

        public DataTableDisplayBuilder maximumColumnTextWidths(List<Float> maximumColumnTextWidths) {
            this.maximumColumnTextWidths = maximumColumnTextWidths;
            return this;
        }

        public DataTableDisplay build() {
            return new DataTableDisplay(this.step, this.textColor, this.backgroundColor, this.columnsCropped, this.cellTextCropped, this.maximumColumnTextWidths);
        }

        public String toString() {
            return "DataTableDisplay.DataTableDisplayBuilder(step=" + this.step + ", textColor=" + this.textColor + ", backgroundColor=" + this.backgroundColor + ", columnsCropped=" + this.columnsCropped + ", cellTextCropped=" + this.cellTextCropped + ", maximumColumnTextWidths=" + this.maximumColumnTextWidths + ")";
        }
    }
}

