/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable;

import java.awt.Color;
import java.util.ArrayList;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Executable;

public class StackTraceDisplay {
    private Executable executable;
    private Color color;
    private final float fontsize = 9.0f;

    public AbstractCell display() {
        String message;
        ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder = ParagraphCell.Paragraph.builder();
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        ArrayList<String> displayLines = new ArrayList<String>();
        if (this.executable.getErrorMessage() != null && !this.executable.getErrorMessage().isEmpty()) {
            String[] lines = this.executable.getErrorMessage().split("\\r?\\n");
            String nonTraceLine = "";
            for (String line : lines) {
                if (line.startsWith("\tat")) {
                    if (!nonTraceLine.isEmpty()) {
                        displayLines.add(nonTraceLine);
                        nonTraceLine = "";
                    }
                    displayLines.add(line);
                    continue;
                }
                nonTraceLine = nonTraceLine.isEmpty() ? line : nonTraceLine + " " + line;
            }
            if (displayLines.isEmpty()) {
                displayLines.add(this.executable.getErrorMessage());
            }
        }
        if (!displayLines.isEmpty()) {
            for (String line : displayLines) {
                paragraphBuilder.append(StyledText.builder().font(ReportFont.REGULAR_FONT).fontSize(Float.valueOf(9.0f)).text(sanitizer.sanitizeText(line)).color(this.color).build()).appendNewLine();
            }
        }
        if (!(message = sanitizer.getStripMessage()).isEmpty()) {
            paragraphBuilder.append(StyledText.builder().font(ReportFont.REGULAR_FONT).fontSize(Float.valueOf(9.0f)).text(message).color(this.color).build());
        }
        return ((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().paragraph(paragraphBuilder.build()).lineSpacing(1.2f).borderColor(Color.GRAY)).borderWidth(1.0f)).build();
    }

    StackTraceDisplay(Executable executable, Color color) {
        this.executable = executable;
        this.color = color;
    }

    public static StackTraceDisplayBuilder builder() {
        return new StackTraceDisplayBuilder();
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public static class StackTraceDisplayBuilder {
        private Executable executable;
        private Color color;

        StackTraceDisplayBuilder() {
        }

        public StackTraceDisplayBuilder executable(Executable executable) {
            this.executable = executable;
            return this;
        }

        public StackTraceDisplayBuilder color(Color color) {
            this.color = color;
            return this;
        }

        public StackTraceDisplay build() {
            return new StackTraceDisplay(this.executable, this.color);
        }

        public String toString() {
            return "StackTraceDisplay.StackTraceDisplayBuilder(executable=" + this.executable + ", color=" + this.color + ")";
        }
    }
}

