/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.summary;

import java.util.List;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.section.summary.SummaryDisplay;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.structure.paginate.PaginationData;
import tech.grasshopper.pdf.structure.paginate.SummaryPaginator;

public class SummarySection
extends PaginatedSection {
    static final String SECTION_TITLE = "SUMMARY";
    private final int maxDataCountPerPage;
    private FeatureData featureData;

    @Override
    public void generateDisplay(int fromIndex, int toIndex) {
        ((SummaryDisplay)((SummaryDisplay.SummaryDisplayBuilder)((SummaryDisplay.SummaryDisplayBuilder)((SummaryDisplay.SummaryDisplayBuilder)((SummaryDisplay.SummaryDisplayBuilder)((SummaryDisplay.SummaryDisplayBuilder)SummaryDisplay.builder().displayData(this.createDisplayData(fromIndex, toIndex))).document(this.document)).reportConfig(this.reportConfig)).destinations(this.destinations)).paginationData(PaginationData.builder().itemsPerPage(this.maxDataCountPerPage).itemFromIndex(fromIndex).itemToIndex(toIndex).build())).build()).display();
    }

    @Override
    public DisplayData createDisplayData(int fromIndex, int toIndex) {
        List<Feature> pageFeatures = this.featureData.getFeatures().subList(fromIndex, toIndex);
        return FeatureData.builder().features(pageFeatures).build();
    }

    @Override
    public void createSection() {
        this.featureData = (FeatureData)this.displayData;
        if (this.featureData.getFeatures().isEmpty()) {
            return;
        }
        SummaryPaginator paginator = SummaryPaginator.builder().data(this.featureData).maxDataCountPerPage(this.maxDataCountPerPage).section(this).build();
        paginator.paginate();
    }

    protected SummarySection(SummarySectionBuilder<?, ?> b) {
        super((PaginatedSection.PaginatedSectionBuilder<?, ?>)b);
        this.maxDataCountPerPage = this.reportConfig.getSummaryConfig().dataCount();
        this.featureData = ((SummarySectionBuilder)b).featureData;
    }

    public static SummarySectionBuilder<?, ?> builder() {
        return new SummarySectionBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummarySection)) {
            return false;
        }
        SummarySection other = (SummarySection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxDataCountPerPage != other.maxDataCountPerPage) {
            return false;
        }
        FeatureData this$featureData = this.featureData;
        FeatureData other$featureData = other.featureData;
        return !(this$featureData == null ? other$featureData != null : !this$featureData.equals(other$featureData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummarySection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxDataCountPerPage;
        FeatureData $featureData = this.featureData;
        result = result * 59 + ($featureData == null ? 43 : $featureData.hashCode());
        return result;
    }

    private static final class SummarySectionBuilderImpl
    extends SummarySectionBuilder<SummarySection, SummarySectionBuilderImpl> {
        private SummarySectionBuilderImpl() {
        }

        @Override
        protected SummarySectionBuilderImpl self() {
            return this;
        }

        @Override
        public SummarySection build() {
            return new SummarySection(this);
        }
    }

    public static abstract class SummarySectionBuilder<C extends SummarySection, B extends SummarySectionBuilder<C, B>>
    extends PaginatedSection.PaginatedSectionBuilder<C, B> {
        private FeatureData featureData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B featureData(FeatureData featureData) {
            this.featureData = featureData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SummarySection.SummarySectionBuilder(super=" + super.toString() + ", featureData=" + this.featureData + ")";
        }
    }
}

