/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.cell;

import java.awt.Color;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import tech.grasshopper.extent.data.pojo.Status;

public class CellValueOptions {
    public static final CellValueOptions EMPTY_CELL_OPTIONS = CellValueOptions.builder().build();
    public static final CellValueOptions BOLD_CELL_OPTIONS = CellValueOptions.builder().bold(true).build();
    public static final CellValueOptions ITALIC_CELL_OPTIONS = CellValueOptions.builder().italic(true).build();
    public static final CellValueOptions BOLD_HORIZCENTER_CELL_OPTIONS = CellValueOptions.builder().bold(true).horizAlign(HorizontalAlignment.CENTER).build();
    public static final CellValueOptions POSITIVENUMBER_HORIZCENTER_CELL_OPTIONS = CellValueOptions.builder().positiveNumber(true).horizAlign(HorizontalAlignment.CENTER).build();
    public static final CellValueOptions POSITIVENUMBER_STATUSPASSEDTEXTCOLOR_HORIZCENTER_CELL_OPTIONS = CellValueOptions.builder().positiveNumber(true).horizAlign(HorizontalAlignment.CENTER).textColor(Status.getStatusColor(Status.PASSED)).build();
    public static final CellValueOptions POSITIVENUMBER_STATUSFAILEDTEXTCOLOR_HORIZCENTER_CELL_OPTIONS = CellValueOptions.builder().positiveNumber(true).horizAlign(HorizontalAlignment.CENTER).textColor(Status.getStatusColor(Status.FAILED)).build();
    public static final CellValueOptions POSITIVENUMBER_STATUSSKIPPEDTEXTCOLOR_HORIZCENTER_CELL_OPTIONS = CellValueOptions.builder().positiveNumber(true).horizAlign(HorizontalAlignment.CENTER).textColor(Status.getStatusColor(Status.SKIPPED)).build();
    public static final CellValueOptions STATUS_BOLD_CELL_OPTIONS = CellValueOptions.builder().status(true).bold(true).build();
    private boolean bold;
    private boolean italic;
    private Color textColor;
    private HorizontalAlignment horizAlign;
    private VerticalAlignment vertAlign;
    private boolean status;
    private boolean number;
    private boolean positiveNumber;

    public static CellValueOptions getStatusColorCellValueOption(Status status) {
        return CellValueOptions.builder().textColor(Status.getStatusColor(status)).build();
    }

    private static boolean $default$bold() {
        return false;
    }

    private static boolean $default$italic() {
        return false;
    }

    private static Color $default$textColor() {
        return Color.BLACK;
    }

    private static boolean $default$status() {
        return false;
    }

    private static boolean $default$number() {
        return false;
    }

    private static boolean $default$positiveNumber() {
        return false;
    }

    CellValueOptions(boolean bold, boolean italic, Color textColor, HorizontalAlignment horizAlign, VerticalAlignment vertAlign, boolean status, boolean number, boolean positiveNumber) {
        this.bold = bold;
        this.italic = italic;
        this.textColor = textColor;
        this.horizAlign = horizAlign;
        this.vertAlign = vertAlign;
        this.status = status;
        this.number = number;
        this.positiveNumber = positiveNumber;
    }

    public static CellValueOptionsBuilder builder() {
        return new CellValueOptionsBuilder();
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public HorizontalAlignment getHorizAlign() {
        return this.horizAlign;
    }

    public VerticalAlignment getVertAlign() {
        return this.vertAlign;
    }

    public boolean isStatus() {
        return this.status;
    }

    public boolean isNumber() {
        return this.number;
    }

    public boolean isPositiveNumber() {
        return this.positiveNumber;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setHorizAlign(HorizontalAlignment horizAlign) {
        this.horizAlign = horizAlign;
    }

    public void setVertAlign(VerticalAlignment vertAlign) {
        this.vertAlign = vertAlign;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public void setNumber(boolean number) {
        this.number = number;
    }

    public void setPositiveNumber(boolean positiveNumber) {
        this.positiveNumber = positiveNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellValueOptions)) {
            return false;
        }
        CellValueOptions other = (CellValueOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBold() != other.isBold()) {
            return false;
        }
        if (this.isItalic() != other.isItalic()) {
            return false;
        }
        if (this.isStatus() != other.isStatus()) {
            return false;
        }
        if (this.isNumber() != other.isNumber()) {
            return false;
        }
        if (this.isPositiveNumber() != other.isPositiveNumber()) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        HorizontalAlignment this$horizAlign = this.getHorizAlign();
        HorizontalAlignment other$horizAlign = other.getHorizAlign();
        if (this$horizAlign == null ? other$horizAlign != null : !this$horizAlign.equals(other$horizAlign)) {
            return false;
        }
        VerticalAlignment this$vertAlign = this.getVertAlign();
        VerticalAlignment other$vertAlign = other.getVertAlign();
        return !(this$vertAlign == null ? other$vertAlign != null : !this$vertAlign.equals(other$vertAlign));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CellValueOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBold() ? 79 : 97);
        result = result * 59 + (this.isItalic() ? 79 : 97);
        result = result * 59 + (this.isStatus() ? 79 : 97);
        result = result * 59 + (this.isNumber() ? 79 : 97);
        result = result * 59 + (this.isPositiveNumber() ? 79 : 97);
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        HorizontalAlignment $horizAlign = this.getHorizAlign();
        result = result * 59 + ($horizAlign == null ? 43 : $horizAlign.hashCode());
        VerticalAlignment $vertAlign = this.getVertAlign();
        result = result * 59 + ($vertAlign == null ? 43 : $vertAlign.hashCode());
        return result;
    }

    public String toString() {
        return "CellValueOptions(bold=" + this.isBold() + ", italic=" + this.isItalic() + ", textColor=" + this.getTextColor() + ", horizAlign=" + this.getHorizAlign() + ", vertAlign=" + this.getVertAlign() + ", status=" + this.isStatus() + ", number=" + this.isNumber() + ", positiveNumber=" + this.isPositiveNumber() + ")";
    }

    public static class CellValueOptionsBuilder {
        private boolean bold$set;
        private boolean bold$value;
        private boolean italic$set;
        private boolean italic$value;
        private boolean textColor$set;
        private Color textColor$value;
        private HorizontalAlignment horizAlign;
        private VerticalAlignment vertAlign;
        private boolean status$set;
        private boolean status$value;
        private boolean number$set;
        private boolean number$value;
        private boolean positiveNumber$set;
        private boolean positiveNumber$value;

        CellValueOptionsBuilder() {
        }

        public CellValueOptionsBuilder bold(boolean bold) {
            this.bold$value = bold;
            this.bold$set = true;
            return this;
        }

        public CellValueOptionsBuilder italic(boolean italic) {
            this.italic$value = italic;
            this.italic$set = true;
            return this;
        }

        public CellValueOptionsBuilder textColor(Color textColor) {
            this.textColor$value = textColor;
            this.textColor$set = true;
            return this;
        }

        public CellValueOptionsBuilder horizAlign(HorizontalAlignment horizAlign) {
            this.horizAlign = horizAlign;
            return this;
        }

        public CellValueOptionsBuilder vertAlign(VerticalAlignment vertAlign) {
            this.vertAlign = vertAlign;
            return this;
        }

        public CellValueOptionsBuilder status(boolean status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        public CellValueOptionsBuilder number(boolean number) {
            this.number$value = number;
            this.number$set = true;
            return this;
        }

        public CellValueOptionsBuilder positiveNumber(boolean positiveNumber) {
            this.positiveNumber$value = positiveNumber;
            this.positiveNumber$set = true;
            return this;
        }

        public CellValueOptions build() {
            boolean bold$value = this.bold$value;
            if (!this.bold$set) {
                bold$value = CellValueOptions.$default$bold();
            }
            boolean italic$value = this.italic$value;
            if (!this.italic$set) {
                italic$value = CellValueOptions.$default$italic();
            }
            Color textColor$value = this.textColor$value;
            if (!this.textColor$set) {
                textColor$value = CellValueOptions.$default$textColor();
            }
            boolean status$value = this.status$value;
            if (!this.status$set) {
                status$value = CellValueOptions.$default$status();
            }
            boolean number$value = this.number$value;
            if (!this.number$set) {
                number$value = CellValueOptions.$default$number();
            }
            boolean positiveNumber$value = this.positiveNumber$value;
            if (!this.positiveNumber$set) {
                positiveNumber$value = CellValueOptions.$default$positiveNumber();
            }
            return new CellValueOptions(bold$value, italic$value, textColor$value, this.horizAlign, this.vertAlign, status$value, number$value, positiveNumber$value);
        }

        public String toString() {
            return "CellValueOptions.CellValueOptionsBuilder(bold$value=" + this.bold$value + ", italic$value=" + this.italic$value + ", textColor$value=" + this.textColor$value + ", horizAlign=" + this.horizAlign + ", vertAlign=" + this.vertAlign + ", status$value=" + this.status$value + ", number$value=" + this.number$value + ", positiveNumber$value=" + this.positiveNumber$value + ")";
        }
    }
}

