/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.dashboard.components;

import java.time.LocalDateTime;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.excel.report.sheets.dashboard.components.DBComponent;
import tech.grasshopper.excel.report.util.DateUtil;
import tech.grasshopper.extent.data.SheetData;

public class BasicDBComponent
extends DBComponent {
    private CellOperations dbDataCellOperations;
    private int featurePieChartIndex;
    private int scenarioPieChartIndex;
    private int stepPieChartIndex;

    @Override
    public void createComponent() {
        this.dbDataCellOperations = CellOperations.builder().sheet(this.dbDataSheet).build();
        this.updateBasicValues();
        this.updateFeatureCounts();
        this.updateScenarioCounts();
        this.updateStepCounts();
    }

    private void updateBasicValues() {
        SheetData.TimingData timingData = this.reportData.getDashboardData().getTimingData();
        this.dbDataCellOperations.writePlainValue("B3", DateUtil.formatDateTime(LocalDateTime.now()));
        this.dbDataCellOperations.writePlainValue("B4", DateUtil.formatDateTime(timingData.getStartTime()));
        this.dbDataCellOperations.writePlainValue("B5", DateUtil.formatDateTime(timingData.getEndTime()));
        this.dbDataCellOperations.writePlainValue("B6", DateUtil.durationValue(timingData.getDuration()));
    }

    private void updateFeatureCounts() {
        SheetData.CountData featureCounts = this.reportData.getDashboardData().getFeatureCounts();
        this.dbDataCellOperations.writePlainPositiveNumberValue("D2", featureCounts.getPassed());
        this.dbDataCellOperations.writePlainPositiveNumberValue("D3", featureCounts.getFailed());
        this.dbDataCellOperations.writePlainPositiveNumberValue("D4", featureCounts.getSkipped());
        this.dbDataCellOperations.writePlainPositiveNumberValue("D5", featureCounts.getTotal());
        this.dbDataCellOperations.writePlainValue("D6", featureCounts.getPassPercent());
    }

    private void updateScenarioCounts() {
        SheetData.CountData scenarioCounts = this.reportData.getDashboardData().getScenarioCounts();
        this.dbDataCellOperations.writePlainPositiveNumberValue("F2", scenarioCounts.getPassed());
        this.dbDataCellOperations.writePlainPositiveNumberValue("F3", scenarioCounts.getFailed());
        this.dbDataCellOperations.writePlainPositiveNumberValue("F4", scenarioCounts.getSkipped());
        this.dbDataCellOperations.writePlainPositiveNumberValue("F5", scenarioCounts.getTotal());
        this.dbDataCellOperations.writePlainValue("F6", scenarioCounts.getPassPercent());
    }

    private void updateStepCounts() {
        SheetData.CountData stepCounts = this.reportData.getDashboardData().getStepCounts();
        this.dbDataCellOperations.writePlainPositiveNumberValue("H2", stepCounts.getPassed());
        this.dbDataCellOperations.writePlainPositiveNumberValue("H3", stepCounts.getFailed());
        this.dbDataCellOperations.writePlainPositiveNumberValue("H4", stepCounts.getSkipped());
        this.dbDataCellOperations.writePlainPositiveNumberValue("H5", stepCounts.getTotal());
        this.dbDataCellOperations.writePlainValue("H6", stepCounts.getPassPercent());
    }

    private static int $default$featurePieChartIndex() {
        return 0;
    }

    private static int $default$scenarioPieChartIndex() {
        return 1;
    }

    private static int $default$stepPieChartIndex() {
        return 2;
    }

    protected BasicDBComponent(BasicDBComponentBuilder<?, ?> b) {
        super(b);
        this.dbDataCellOperations = ((BasicDBComponentBuilder)b).dbDataCellOperations;
        this.featurePieChartIndex = ((BasicDBComponentBuilder)b).featurePieChartIndex$set ? ((BasicDBComponentBuilder)b).featurePieChartIndex$value : BasicDBComponent.$default$featurePieChartIndex();
        this.scenarioPieChartIndex = ((BasicDBComponentBuilder)b).scenarioPieChartIndex$set ? ((BasicDBComponentBuilder)b).scenarioPieChartIndex$value : BasicDBComponent.$default$scenarioPieChartIndex();
        this.stepPieChartIndex = ((BasicDBComponentBuilder)b).stepPieChartIndex$set ? ((BasicDBComponentBuilder)b).stepPieChartIndex$value : BasicDBComponent.$default$stepPieChartIndex();
    }

    public static BasicDBComponentBuilder<?, ?> builder() {
        return new BasicDBComponentBuilderImpl();
    }

    private static final class BasicDBComponentBuilderImpl
    extends BasicDBComponentBuilder<BasicDBComponent, BasicDBComponentBuilderImpl> {
        private BasicDBComponentBuilderImpl() {
        }

        @Override
        protected BasicDBComponentBuilderImpl self() {
            return this;
        }

        @Override
        public BasicDBComponent build() {
            return new BasicDBComponent(this);
        }
    }

    public static abstract class BasicDBComponentBuilder<C extends BasicDBComponent, B extends BasicDBComponentBuilder<C, B>>
    extends DBComponent.DBComponentBuilder<C, B> {
        private CellOperations dbDataCellOperations;
        private boolean featurePieChartIndex$set;
        private int featurePieChartIndex$value;
        private boolean scenarioPieChartIndex$set;
        private int scenarioPieChartIndex$value;
        private boolean stepPieChartIndex$set;
        private int stepPieChartIndex$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B dbDataCellOperations(CellOperations dbDataCellOperations) {
            this.dbDataCellOperations = dbDataCellOperations;
            return (B)this.self();
        }

        public B featurePieChartIndex(int featurePieChartIndex) {
            this.featurePieChartIndex$value = featurePieChartIndex;
            this.featurePieChartIndex$set = true;
            return (B)this.self();
        }

        public B scenarioPieChartIndex(int scenarioPieChartIndex) {
            this.scenarioPieChartIndex$value = scenarioPieChartIndex;
            this.scenarioPieChartIndex$set = true;
            return (B)this.self();
        }

        public B stepPieChartIndex(int stepPieChartIndex) {
            this.stepPieChartIndex$value = stepPieChartIndex;
            this.stepPieChartIndex$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BasicDBComponent.BasicDBComponentBuilder(super=" + super.toString() + ", dbDataCellOperations=" + this.dbDataCellOperations + ", featurePieChartIndex$value=" + this.featurePieChartIndex$value + ", scenarioPieChartIndex$value=" + this.scenarioPieChartIndex$value + ", stepPieChartIndex$value=" + this.stepPieChartIndex$value + ")";
        }
    }
}

