/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.table;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.excel.report.cell.CellValueOptions;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;

public class TagFeatureScenarioTable {
    private XSSFSheet sheet;
    private String startCell;
    private Map<String, List<Feature>> featureAndScenarioTagData;
    private int[] columnCellCount;
    private boolean groupRows;

    public void writeTableValues() {
        CellOperations cellOperations = CellOperations.builder().sheet(this.sheet).build();
        CellReference cellRef = new CellReference(this.startCell);
        int startRow = cellRef.getRow();
        int startCol = cellRef.getCol();
        int rowCount = (int)this.featureAndScenarioTagData.values().stream().flatMap(Collection::stream).mapToLong(f -> f.getTotalScenarios()).sum();
        cellOperations.createCellsWithStyleInRange(startRow, startRow + rowCount, startCol, startCol + Arrays.stream(this.columnCellCount).sum());
        int currentRow = startRow;
        for (Map.Entry<String, List<Feature>> entry : this.featureAndScenarioTagData.entrySet()) {
            int currentCol = startCol;
            String tag = entry.getKey();
            List<Feature> features = entry.getValue();
            long tagMergeRowCount = features.stream().mapToLong(f -> f.getTotalScenarios()).sum();
            cellOperations.mergeRows(currentRow, (int)tagMergeRowCount, currentCol, this.columnCellCount[0]);
            cellOperations.writeValue(new CellReference(currentRow, currentCol), tag, CellValueOptions.BOLD_CELL_OPTIONS);
            currentCol += this.columnCellCount[0];
            for (Feature feature : features) {
                cellOperations.mergeRows(currentRow, (int)feature.getTotalScenarios(), currentCol, this.columnCellCount[1]);
                cellOperations.writeValue(new CellReference(currentRow, currentCol), feature.getName(), CellValueOptions.getStatusColorCellValueOption(feature.getStatus()));
                currentCol += this.columnCellCount[1];
                for (Scenario scenario : feature.getScenarios()) {
                    cellOperations.mergeRows(currentRow, 1, currentCol, this.columnCellCount[2]);
                    cellOperations.writeValue(new CellReference(currentRow, currentCol), scenario.getName(), CellValueOptions.getStatusColorCellValueOption(scenario.getStatus()));
                    cellOperations.mergeRows(currentRow, 1, currentCol += this.columnCellCount[2], this.columnCellCount[3]);
                    cellOperations.writeValue(new CellReference(currentRow, currentCol), scenario.getStatus().toString(), CellValueOptions.STATUS_BOLD_CELL_OPTIONS);
                    currentCol -= this.columnCellCount[2];
                    ++currentRow;
                }
                currentCol -= this.columnCellCount[1];
            }
        }
        if (this.groupRows) {
            this.sheet.groupRow(startRow, startRow + rowCount - 1);
            this.sheet.setRowGroupCollapsed(startRow, true);
        }
    }

    private static boolean $default$groupRows() {
        return false;
    }

    TagFeatureScenarioTable(XSSFSheet sheet, String startCell, Map<String, List<Feature>> featureAndScenarioTagData, int[] columnCellCount, boolean groupRows) {
        this.sheet = sheet;
        this.startCell = startCell;
        this.featureAndScenarioTagData = featureAndScenarioTagData;
        this.columnCellCount = columnCellCount;
        this.groupRows = groupRows;
    }

    public static TagFeatureScenarioTableBuilder builder() {
        return new TagFeatureScenarioTableBuilder();
    }

    public static class TagFeatureScenarioTableBuilder {
        private XSSFSheet sheet;
        private String startCell;
        private Map<String, List<Feature>> featureAndScenarioTagData;
        private int[] columnCellCount;
        private boolean groupRows$set;
        private boolean groupRows$value;

        TagFeatureScenarioTableBuilder() {
        }

        public TagFeatureScenarioTableBuilder sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public TagFeatureScenarioTableBuilder startCell(String startCell) {
            this.startCell = startCell;
            return this;
        }

        public TagFeatureScenarioTableBuilder featureAndScenarioTagData(Map<String, List<Feature>> featureAndScenarioTagData) {
            this.featureAndScenarioTagData = featureAndScenarioTagData;
            return this;
        }

        public TagFeatureScenarioTableBuilder columnCellCount(int[] columnCellCount) {
            this.columnCellCount = columnCellCount;
            return this;
        }

        public TagFeatureScenarioTableBuilder groupRows(boolean groupRows) {
            this.groupRows$value = groupRows;
            this.groupRows$set = true;
            return this;
        }

        public TagFeatureScenarioTable build() {
            boolean groupRows$value = this.groupRows$value;
            if (!this.groupRows$set) {
                groupRows$value = TagFeatureScenarioTable.$default$groupRows();
            }
            return new TagFeatureScenarioTable(this.sheet, this.startCell, this.featureAndScenarioTagData, this.columnCellCount, groupRows$value);
        }

        public String toString() {
            return "TagFeatureScenarioTable.TagFeatureScenarioTableBuilder(sheet=" + this.sheet + ", startCell=" + this.startCell + ", featureAndScenarioTagData=" + this.featureAndScenarioTagData + ", columnCellCount=" + Arrays.toString(this.columnCellCount) + ", groupRows$value=" + this.groupRows$value + ")";
        }
    }
}

