/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.workbook;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import tech.grasshopper.excel.report.sheets.exceptions.ExceptionsSheet;
import tech.grasshopper.excel.report.sheets.features.FeaturesSheet;
import tech.grasshopper.excel.report.sheets.scenarios.ScenariosSheet;
import tech.grasshopper.excel.report.sheets.tags.TagsSheet;
import tech.grasshopper.excel.report.workbook.ExecutionAndFailSkipDataReport;
import tech.grasshopper.excel.report.workbook.ExecutionAndTagAndFailSkipDataReport;
import tech.grasshopper.excel.report.workbook.ExecutionDataReport;
import tech.grasshopper.extent.data.ReportData;

public abstract class ReportWorkbook {
    protected ReportData reportData;
    protected XSSFWorkbook xssfWorkbook;

    public static void createReport(ReportData reportData, String reportFile) throws IOException {
        ReportWorkbook reportWorkbook = ReportWorkbook.createReportType(reportData);
        Path reportPath = Paths.get(reportFile, new String[0]);
        InputStream templateInputStream = reportWorkbook.getClass().getResourceAsStream(reportWorkbook.templateReportLocation());
        Files.copy(templateInputStream, reportPath, StandardCopyOption.REPLACE_EXISTING);
        FileInputStream inputStream = new FileInputStream(reportPath.toFile());
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);
        reportWorkbook.setXssfWorkbook(workbook);
        reportWorkbook.updateSheets();
        workbook.lockStructure();
        inputStream.close();
        FileOutputStream os = new FileOutputStream(reportPath.toFile());
        workbook.write((OutputStream)os);
        workbook.close();
        os.close();
    }

    private static ReportWorkbook createReportType(ReportData reportData) {
        boolean tagFailSkipDataPresent;
        boolean failSkipDataPresent = !reportData.getFailSkipFeatureAndScenarioData().isEmpty();
        boolean bl = tagFailSkipDataPresent = !reportData.getFailSkipTagCountData().isEmpty();
        if (tagFailSkipDataPresent & failSkipDataPresent) {
            return ((ExecutionAndTagAndFailSkipDataReport.ExecutionAndTagAndFailSkipDataReportBuilder)ExecutionAndTagAndFailSkipDataReport.builder().reportData(reportData)).build();
        }
        if (failSkipDataPresent) {
            return ((ExecutionAndFailSkipDataReport.ExecutionAndFailSkipDataReportBuilder)ExecutionAndFailSkipDataReport.builder().reportData(reportData)).build();
        }
        return ((ExecutionDataReport.ExecutionDataReportBuilder)ExecutionDataReport.builder().reportData(reportData)).build();
    }

    protected abstract String templateReportLocation();

    protected void updateSheets() {
        ((ScenariosSheet)((ScenariosSheet.ScenariosSheetBuilder)((ScenariosSheet.ScenariosSheetBuilder)ScenariosSheet.builder().reportData(this.reportData)).workbook(this.xssfWorkbook)).build()).updateSheet();
        ((TagsSheet)((TagsSheet.TagsSheetBuilder)((TagsSheet.TagsSheetBuilder)TagsSheet.builder().reportData(this.reportData)).workbook(this.xssfWorkbook)).build()).updateSheet();
        ((FeaturesSheet)((FeaturesSheet.FeaturesSheetBuilder)((FeaturesSheet.FeaturesSheetBuilder)FeaturesSheet.builder().reportData(this.reportData)).workbook(this.xssfWorkbook)).build()).updateSheet();
        ((ExceptionsSheet)((ExceptionsSheet.ExceptionsSheetBuilder)((ExceptionsSheet.ExceptionsSheetBuilder)ExceptionsSheet.builder().reportData(this.reportData)).workbook(this.xssfWorkbook)).build()).updateSheet();
    }

    protected ReportWorkbook(ReportWorkbookBuilder<?, ?> b) {
        this.reportData = ((ReportWorkbookBuilder)b).reportData;
        this.xssfWorkbook = ((ReportWorkbookBuilder)b).xssfWorkbook;
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public XSSFWorkbook getXssfWorkbook() {
        return this.xssfWorkbook;
    }

    public void setReportData(ReportData reportData) {
        this.reportData = reportData;
    }

    public void setXssfWorkbook(XSSFWorkbook xssfWorkbook) {
        this.xssfWorkbook = xssfWorkbook;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportWorkbook)) {
            return false;
        }
        ReportWorkbook other = (ReportWorkbook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ReportData this$reportData = this.getReportData();
        ReportData other$reportData = other.getReportData();
        if (this$reportData == null ? other$reportData != null : !this$reportData.equals(other$reportData)) {
            return false;
        }
        XSSFWorkbook this$xssfWorkbook = this.getXssfWorkbook();
        XSSFWorkbook other$xssfWorkbook = other.getXssfWorkbook();
        return !(this$xssfWorkbook == null ? other$xssfWorkbook != null : !this$xssfWorkbook.equals(other$xssfWorkbook));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportWorkbook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReportData $reportData = this.getReportData();
        result = result * 59 + ($reportData == null ? 43 : $reportData.hashCode());
        XSSFWorkbook $xssfWorkbook = this.getXssfWorkbook();
        result = result * 59 + ($xssfWorkbook == null ? 43 : $xssfWorkbook.hashCode());
        return result;
    }

    public String toString() {
        return "ReportWorkbook(reportData=" + this.getReportData() + ", xssfWorkbook=" + this.getXssfWorkbook() + ")";
    }

    public static abstract class ReportWorkbookBuilder<C extends ReportWorkbook, B extends ReportWorkbookBuilder<C, B>> {
        private ReportData reportData;
        private XSSFWorkbook xssfWorkbook;

        protected abstract B self();

        public abstract C build();

        public B reportData(ReportData reportData) {
            this.reportData = reportData;
            return this.self();
        }

        public B xssfWorkbook(XSSFWorkbook xssfWorkbook) {
            this.xssfWorkbook = xssfWorkbook;
            return this.self();
        }

        public String toString() {
            return "ReportWorkbook.ReportWorkbookBuilder(reportData=" + this.reportData + ", xssfWorkbook=" + this.xssfWorkbook + ")";
        }
    }
}

