/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data;

import java.time.Duration;
import java.time.LocalDateTime;
import tech.grasshopper.extent.data.pojo.Status;

public class SheetData {

    public static class ScenarioData {
        private String name;
        private Status status;
        private String featureName;
        private Status featureStatus;
        private TimingData timingData;
        private CountData stepCounts;

        ScenarioData(String name, Status status, String featureName, Status featureStatus, TimingData timingData, CountData stepCounts) {
            this.name = name;
            this.status = status;
            this.featureName = featureName;
            this.featureStatus = featureStatus;
            this.timingData = timingData;
            this.stepCounts = stepCounts;
        }

        public static ScenarioDataBuilder builder() {
            return new ScenarioDataBuilder();
        }

        public String getName() {
            return this.name;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public Status getFeatureStatus() {
            return this.featureStatus;
        }

        public TimingData getTimingData() {
            return this.timingData;
        }

        public CountData getStepCounts() {
            return this.stepCounts;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        public void setFeatureStatus(Status featureStatus) {
            this.featureStatus = featureStatus;
        }

        public void setTimingData(TimingData timingData) {
            this.timingData = timingData;
        }

        public void setStepCounts(CountData stepCounts) {
            this.stepCounts = stepCounts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScenarioData)) {
                return false;
            }
            ScenarioData other = (ScenarioData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            String this$featureName = this.getFeatureName();
            String other$featureName = other.getFeatureName();
            if (this$featureName == null ? other$featureName != null : !this$featureName.equals(other$featureName)) {
                return false;
            }
            Status this$featureStatus = this.getFeatureStatus();
            Status other$featureStatus = other.getFeatureStatus();
            if (this$featureStatus == null ? other$featureStatus != null : !((Object)((Object)this$featureStatus)).equals((Object)other$featureStatus)) {
                return false;
            }
            TimingData this$timingData = this.getTimingData();
            TimingData other$timingData = other.getTimingData();
            if (this$timingData == null ? other$timingData != null : !((Object)this$timingData).equals(other$timingData)) {
                return false;
            }
            CountData this$stepCounts = this.getStepCounts();
            CountData other$stepCounts = other.getStepCounts();
            return !(this$stepCounts == null ? other$stepCounts != null : !((Object)this$stepCounts).equals(other$stepCounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScenarioData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            String $featureName = this.getFeatureName();
            result = result * 59 + ($featureName == null ? 43 : $featureName.hashCode());
            Status $featureStatus = this.getFeatureStatus();
            result = result * 59 + ($featureStatus == null ? 43 : ((Object)((Object)$featureStatus)).hashCode());
            TimingData $timingData = this.getTimingData();
            result = result * 59 + ($timingData == null ? 43 : ((Object)$timingData).hashCode());
            CountData $stepCounts = this.getStepCounts();
            result = result * 59 + ($stepCounts == null ? 43 : ((Object)$stepCounts).hashCode());
            return result;
        }

        public String toString() {
            return "SheetData.ScenarioData(name=" + this.getName() + ", status=" + (Object)((Object)this.getStatus()) + ", featureName=" + this.getFeatureName() + ", featureStatus=" + (Object)((Object)this.getFeatureStatus()) + ", timingData=" + this.getTimingData() + ", stepCounts=" + this.getStepCounts() + ")";
        }

        public static class ScenarioDataBuilder {
            private String name;
            private Status status;
            private String featureName;
            private Status featureStatus;
            private TimingData timingData;
            private CountData stepCounts;

            ScenarioDataBuilder() {
            }

            public ScenarioDataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ScenarioDataBuilder status(Status status) {
                this.status = status;
                return this;
            }

            public ScenarioDataBuilder featureName(String featureName) {
                this.featureName = featureName;
                return this;
            }

            public ScenarioDataBuilder featureStatus(Status featureStatus) {
                this.featureStatus = featureStatus;
                return this;
            }

            public ScenarioDataBuilder timingData(TimingData timingData) {
                this.timingData = timingData;
                return this;
            }

            public ScenarioDataBuilder stepCounts(CountData stepCounts) {
                this.stepCounts = stepCounts;
                return this;
            }

            public ScenarioData build() {
                return new ScenarioData(this.name, this.status, this.featureName, this.featureStatus, this.timingData, this.stepCounts);
            }

            public String toString() {
                return "SheetData.ScenarioData.ScenarioDataBuilder(name=" + this.name + ", status=" + (Object)((Object)this.status) + ", featureName=" + this.featureName + ", featureStatus=" + (Object)((Object)this.featureStatus) + ", timingData=" + this.timingData + ", stepCounts=" + this.stepCounts + ")";
            }
        }
    }

    public static class FeatureData {
        private String name;
        private Status status;
        private TimingData timingData;
        private CountData scenarioCounts;
        private CountData stepCounts;

        FeatureData(String name, Status status, TimingData timingData, CountData scenarioCounts, CountData stepCounts) {
            this.name = name;
            this.status = status;
            this.timingData = timingData;
            this.scenarioCounts = scenarioCounts;
            this.stepCounts = stepCounts;
        }

        public static FeatureDataBuilder builder() {
            return new FeatureDataBuilder();
        }

        public String getName() {
            return this.name;
        }

        public Status getStatus() {
            return this.status;
        }

        public TimingData getTimingData() {
            return this.timingData;
        }

        public CountData getScenarioCounts() {
            return this.scenarioCounts;
        }

        public CountData getStepCounts() {
            return this.stepCounts;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setTimingData(TimingData timingData) {
            this.timingData = timingData;
        }

        public void setScenarioCounts(CountData scenarioCounts) {
            this.scenarioCounts = scenarioCounts;
        }

        public void setStepCounts(CountData stepCounts) {
            this.stepCounts = stepCounts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeatureData)) {
                return false;
            }
            FeatureData other = (FeatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            TimingData this$timingData = this.getTimingData();
            TimingData other$timingData = other.getTimingData();
            if (this$timingData == null ? other$timingData != null : !((Object)this$timingData).equals(other$timingData)) {
                return false;
            }
            CountData this$scenarioCounts = this.getScenarioCounts();
            CountData other$scenarioCounts = other.getScenarioCounts();
            if (this$scenarioCounts == null ? other$scenarioCounts != null : !((Object)this$scenarioCounts).equals(other$scenarioCounts)) {
                return false;
            }
            CountData this$stepCounts = this.getStepCounts();
            CountData other$stepCounts = other.getStepCounts();
            return !(this$stepCounts == null ? other$stepCounts != null : !((Object)this$stepCounts).equals(other$stepCounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            TimingData $timingData = this.getTimingData();
            result = result * 59 + ($timingData == null ? 43 : ((Object)$timingData).hashCode());
            CountData $scenarioCounts = this.getScenarioCounts();
            result = result * 59 + ($scenarioCounts == null ? 43 : ((Object)$scenarioCounts).hashCode());
            CountData $stepCounts = this.getStepCounts();
            result = result * 59 + ($stepCounts == null ? 43 : ((Object)$stepCounts).hashCode());
            return result;
        }

        public String toString() {
            return "SheetData.FeatureData(name=" + this.getName() + ", status=" + (Object)((Object)this.getStatus()) + ", timingData=" + this.getTimingData() + ", scenarioCounts=" + this.getScenarioCounts() + ", stepCounts=" + this.getStepCounts() + ")";
        }

        public static class FeatureDataBuilder {
            private String name;
            private Status status;
            private TimingData timingData;
            private CountData scenarioCounts;
            private CountData stepCounts;

            FeatureDataBuilder() {
            }

            public FeatureDataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public FeatureDataBuilder status(Status status) {
                this.status = status;
                return this;
            }

            public FeatureDataBuilder timingData(TimingData timingData) {
                this.timingData = timingData;
                return this;
            }

            public FeatureDataBuilder scenarioCounts(CountData scenarioCounts) {
                this.scenarioCounts = scenarioCounts;
                return this;
            }

            public FeatureDataBuilder stepCounts(CountData stepCounts) {
                this.stepCounts = stepCounts;
                return this;
            }

            public FeatureData build() {
                return new FeatureData(this.name, this.status, this.timingData, this.scenarioCounts, this.stepCounts);
            }

            public String toString() {
                return "SheetData.FeatureData.FeatureDataBuilder(name=" + this.name + ", status=" + (Object)((Object)this.status) + ", timingData=" + this.timingData + ", scenarioCounts=" + this.scenarioCounts + ", stepCounts=" + this.stepCounts + ")";
            }
        }
    }

    public static class TagCountData {
        private String name;
        private CountData scenarioCounts;

        TagCountData(String name, CountData scenarioCounts) {
            this.name = name;
            this.scenarioCounts = scenarioCounts;
        }

        public static TagCountDataBuilder builder() {
            return new TagCountDataBuilder();
        }

        public String getName() {
            return this.name;
        }

        public CountData getScenarioCounts() {
            return this.scenarioCounts;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setScenarioCounts(CountData scenarioCounts) {
            this.scenarioCounts = scenarioCounts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagCountData)) {
                return false;
            }
            TagCountData other = (TagCountData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            CountData this$scenarioCounts = this.getScenarioCounts();
            CountData other$scenarioCounts = other.getScenarioCounts();
            return !(this$scenarioCounts == null ? other$scenarioCounts != null : !((Object)this$scenarioCounts).equals(other$scenarioCounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TagCountData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            CountData $scenarioCounts = this.getScenarioCounts();
            result = result * 59 + ($scenarioCounts == null ? 43 : ((Object)$scenarioCounts).hashCode());
            return result;
        }

        public String toString() {
            return "SheetData.TagCountData(name=" + this.getName() + ", scenarioCounts=" + this.getScenarioCounts() + ")";
        }

        public static class TagCountDataBuilder {
            private String name;
            private CountData scenarioCounts;

            TagCountDataBuilder() {
            }

            public TagCountDataBuilder name(String name) {
                this.name = name;
                return this;
            }

            public TagCountDataBuilder scenarioCounts(CountData scenarioCounts) {
                this.scenarioCounts = scenarioCounts;
                return this;
            }

            public TagCountData build() {
                return new TagCountData(this.name, this.scenarioCounts);
            }

            public String toString() {
                return "SheetData.TagCountData.TagCountDataBuilder(name=" + this.name + ", scenarioCounts=" + this.scenarioCounts + ")";
            }
        }
    }

    public static class FailSkipData {
        private String scenarioName;
        private Status scenarioStatus;
        private String featureName;
        private Status featureStatus;

        FailSkipData(String scenarioName, Status scenarioStatus, String featureName, Status featureStatus) {
            this.scenarioName = scenarioName;
            this.scenarioStatus = scenarioStatus;
            this.featureName = featureName;
            this.featureStatus = featureStatus;
        }

        public static FailSkipDataBuilder builder() {
            return new FailSkipDataBuilder();
        }

        public String getScenarioName() {
            return this.scenarioName;
        }

        public Status getScenarioStatus() {
            return this.scenarioStatus;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public Status getFeatureStatus() {
            return this.featureStatus;
        }

        public void setScenarioName(String scenarioName) {
            this.scenarioName = scenarioName;
        }

        public void setScenarioStatus(Status scenarioStatus) {
            this.scenarioStatus = scenarioStatus;
        }

        public void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        public void setFeatureStatus(Status featureStatus) {
            this.featureStatus = featureStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailSkipData)) {
                return false;
            }
            FailSkipData other = (FailSkipData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$scenarioName = this.getScenarioName();
            String other$scenarioName = other.getScenarioName();
            if (this$scenarioName == null ? other$scenarioName != null : !this$scenarioName.equals(other$scenarioName)) {
                return false;
            }
            Status this$scenarioStatus = this.getScenarioStatus();
            Status other$scenarioStatus = other.getScenarioStatus();
            if (this$scenarioStatus == null ? other$scenarioStatus != null : !((Object)((Object)this$scenarioStatus)).equals((Object)other$scenarioStatus)) {
                return false;
            }
            String this$featureName = this.getFeatureName();
            String other$featureName = other.getFeatureName();
            if (this$featureName == null ? other$featureName != null : !this$featureName.equals(other$featureName)) {
                return false;
            }
            Status this$featureStatus = this.getFeatureStatus();
            Status other$featureStatus = other.getFeatureStatus();
            return !(this$featureStatus == null ? other$featureStatus != null : !((Object)((Object)this$featureStatus)).equals((Object)other$featureStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FailSkipData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $scenarioName = this.getScenarioName();
            result = result * 59 + ($scenarioName == null ? 43 : $scenarioName.hashCode());
            Status $scenarioStatus = this.getScenarioStatus();
            result = result * 59 + ($scenarioStatus == null ? 43 : ((Object)((Object)$scenarioStatus)).hashCode());
            String $featureName = this.getFeatureName();
            result = result * 59 + ($featureName == null ? 43 : $featureName.hashCode());
            Status $featureStatus = this.getFeatureStatus();
            result = result * 59 + ($featureStatus == null ? 43 : ((Object)((Object)$featureStatus)).hashCode());
            return result;
        }

        public String toString() {
            return "SheetData.FailSkipData(scenarioName=" + this.getScenarioName() + ", scenarioStatus=" + (Object)((Object)this.getScenarioStatus()) + ", featureName=" + this.getFeatureName() + ", featureStatus=" + (Object)((Object)this.getFeatureStatus()) + ")";
        }

        public static class FailSkipDataBuilder {
            private String scenarioName;
            private Status scenarioStatus;
            private String featureName;
            private Status featureStatus;

            FailSkipDataBuilder() {
            }

            public FailSkipDataBuilder scenarioName(String scenarioName) {
                this.scenarioName = scenarioName;
                return this;
            }

            public FailSkipDataBuilder scenarioStatus(Status scenarioStatus) {
                this.scenarioStatus = scenarioStatus;
                return this;
            }

            public FailSkipDataBuilder featureName(String featureName) {
                this.featureName = featureName;
                return this;
            }

            public FailSkipDataBuilder featureStatus(Status featureStatus) {
                this.featureStatus = featureStatus;
                return this;
            }

            public FailSkipData build() {
                return new FailSkipData(this.scenarioName, this.scenarioStatus, this.featureName, this.featureStatus);
            }

            public String toString() {
                return "SheetData.FailSkipData.FailSkipDataBuilder(scenarioName=" + this.scenarioName + ", scenarioStatus=" + (Object)((Object)this.scenarioStatus) + ", featureName=" + this.featureName + ", featureStatus=" + (Object)((Object)this.featureStatus) + ")";
            }
        }
    }

    public static class CountData {
        private Long total;
        private Long passed;
        private Long failed;
        private Long skipped;

        public String getPassPercent() {
            if (this.total == 0L || this.passed == 0L) {
                return "0%";
            }
            return Math.round(100.0 * (double)this.passed.longValue() / (double)this.total.longValue()) + "%";
        }

        private static Long $default$total() {
            return 0L;
        }

        private static Long $default$passed() {
            return 0L;
        }

        private static Long $default$failed() {
            return 0L;
        }

        private static Long $default$skipped() {
            return 0L;
        }

        CountData(Long total, Long passed, Long failed, Long skipped) {
            this.total = total;
            this.passed = passed;
            this.failed = failed;
            this.skipped = skipped;
        }

        public static CountDataBuilder builder() {
            return new CountDataBuilder();
        }

        public Long getTotal() {
            return this.total;
        }

        public Long getPassed() {
            return this.passed;
        }

        public Long getFailed() {
            return this.failed;
        }

        public Long getSkipped() {
            return this.skipped;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public void setPassed(Long passed) {
            this.passed = passed;
        }

        public void setFailed(Long failed) {
            this.failed = failed;
        }

        public void setSkipped(Long skipped) {
            this.skipped = skipped;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CountData)) {
                return false;
            }
            CountData other = (CountData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$total = this.getTotal();
            Long other$total = other.getTotal();
            if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                return false;
            }
            Long this$passed = this.getPassed();
            Long other$passed = other.getPassed();
            if (this$passed == null ? other$passed != null : !((Object)this$passed).equals(other$passed)) {
                return false;
            }
            Long this$failed = this.getFailed();
            Long other$failed = other.getFailed();
            if (this$failed == null ? other$failed != null : !((Object)this$failed).equals(other$failed)) {
                return false;
            }
            Long this$skipped = this.getSkipped();
            Long other$skipped = other.getSkipped();
            return !(this$skipped == null ? other$skipped != null : !((Object)this$skipped).equals(other$skipped));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CountData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            Long $passed = this.getPassed();
            result = result * 59 + ($passed == null ? 43 : ((Object)$passed).hashCode());
            Long $failed = this.getFailed();
            result = result * 59 + ($failed == null ? 43 : ((Object)$failed).hashCode());
            Long $skipped = this.getSkipped();
            result = result * 59 + ($skipped == null ? 43 : ((Object)$skipped).hashCode());
            return result;
        }

        public String toString() {
            return "SheetData.CountData(total=" + this.getTotal() + ", passed=" + this.getPassed() + ", failed=" + this.getFailed() + ", skipped=" + this.getSkipped() + ")";
        }

        public static class CountDataBuilder {
            private boolean total$set;
            private Long total$value;
            private boolean passed$set;
            private Long passed$value;
            private boolean failed$set;
            private Long failed$value;
            private boolean skipped$set;
            private Long skipped$value;

            CountDataBuilder() {
            }

            public CountDataBuilder total(Long total) {
                this.total$value = total;
                this.total$set = true;
                return this;
            }

            public CountDataBuilder passed(Long passed) {
                this.passed$value = passed;
                this.passed$set = true;
                return this;
            }

            public CountDataBuilder failed(Long failed) {
                this.failed$value = failed;
                this.failed$set = true;
                return this;
            }

            public CountDataBuilder skipped(Long skipped) {
                this.skipped$value = skipped;
                this.skipped$set = true;
                return this;
            }

            public CountData build() {
                Long total$value = this.total$value;
                if (!this.total$set) {
                    total$value = CountData.$default$total();
                }
                Long passed$value = this.passed$value;
                if (!this.passed$set) {
                    passed$value = CountData.$default$passed();
                }
                Long failed$value = this.failed$value;
                if (!this.failed$set) {
                    failed$value = CountData.$default$failed();
                }
                Long skipped$value = this.skipped$value;
                if (!this.skipped$set) {
                    skipped$value = CountData.$default$skipped();
                }
                return new CountData(total$value, passed$value, failed$value, skipped$value);
            }

            public String toString() {
                return "SheetData.CountData.CountDataBuilder(total$value=" + this.total$value + ", passed$value=" + this.passed$value + ", failed$value=" + this.failed$value + ", skipped$value=" + this.skipped$value + ")";
            }
        }
    }

    public static class TimingData {
        private LocalDateTime startTime;
        private LocalDateTime endTime;
        private Duration duration;

        private static LocalDateTime $default$startTime() {
            return LocalDateTime.now();
        }

        private static LocalDateTime $default$endTime() {
            return LocalDateTime.now();
        }

        private static Duration $default$duration() {
            return Duration.ZERO;
        }

        TimingData(LocalDateTime startTime, LocalDateTime endTime, Duration duration) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.duration = duration;
        }

        public static TimingDataBuilder builder() {
            return new TimingDataBuilder();
        }

        public LocalDateTime getStartTime() {
            return this.startTime;
        }

        public LocalDateTime getEndTime() {
            return this.endTime;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public void setStartTime(LocalDateTime startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(LocalDateTime endTime) {
            this.endTime = endTime;
        }

        public void setDuration(Duration duration) {
            this.duration = duration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimingData)) {
                return false;
            }
            TimingData other = (TimingData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LocalDateTime this$startTime = this.getStartTime();
            LocalDateTime other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            LocalDateTime this$endTime = this.getEndTime();
            LocalDateTime other$endTime = other.getEndTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            Duration this$duration = this.getDuration();
            Duration other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TimingData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalDateTime $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            LocalDateTime $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            Duration $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
            return result;
        }

        public String toString() {
            return "SheetData.TimingData(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", duration=" + this.getDuration() + ")";
        }

        public static class TimingDataBuilder {
            private boolean startTime$set;
            private LocalDateTime startTime$value;
            private boolean endTime$set;
            private LocalDateTime endTime$value;
            private boolean duration$set;
            private Duration duration$value;

            TimingDataBuilder() {
            }

            public TimingDataBuilder startTime(LocalDateTime startTime) {
                this.startTime$value = startTime;
                this.startTime$set = true;
                return this;
            }

            public TimingDataBuilder endTime(LocalDateTime endTime) {
                this.endTime$value = endTime;
                this.endTime$set = true;
                return this;
            }

            public TimingDataBuilder duration(Duration duration) {
                this.duration$value = duration;
                this.duration$set = true;
                return this;
            }

            public TimingData build() {
                LocalDateTime startTime$value = this.startTime$value;
                if (!this.startTime$set) {
                    startTime$value = TimingData.$default$startTime();
                }
                LocalDateTime endTime$value = this.endTime$value;
                if (!this.endTime$set) {
                    endTime$value = TimingData.$default$endTime();
                }
                Duration duration$value = this.duration$value;
                if (!this.duration$set) {
                    duration$value = TimingData.$default$duration();
                }
                return new TimingData(startTime$value, endTime$value, duration$value);
            }

            public String toString() {
                return "SheetData.TimingData.TimingDataBuilder(startTime$value=" + this.startTime$value + ", endTime$value=" + this.endTime$value + ", duration$value=" + this.duration$value + ")";
            }
        }
    }

    public static class BasicDashboardData {
        private String title;
        private TimingData timingData;
        private CountData featureCounts;
        private CountData scenarioCounts;
        private CountData stepCounts;

        private static String $default$title() {
            return "";
        }

        BasicDashboardData(String title, TimingData timingData, CountData featureCounts, CountData scenarioCounts, CountData stepCounts) {
            this.title = title;
            this.timingData = timingData;
            this.featureCounts = featureCounts;
            this.scenarioCounts = scenarioCounts;
            this.stepCounts = stepCounts;
        }

        public static BasicDashboardDataBuilder builder() {
            return new BasicDashboardDataBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public TimingData getTimingData() {
            return this.timingData;
        }

        public CountData getFeatureCounts() {
            return this.featureCounts;
        }

        public CountData getScenarioCounts() {
            return this.scenarioCounts;
        }

        public CountData getStepCounts() {
            return this.stepCounts;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setTimingData(TimingData timingData) {
            this.timingData = timingData;
        }

        public void setFeatureCounts(CountData featureCounts) {
            this.featureCounts = featureCounts;
        }

        public void setScenarioCounts(CountData scenarioCounts) {
            this.scenarioCounts = scenarioCounts;
        }

        public void setStepCounts(CountData stepCounts) {
            this.stepCounts = stepCounts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BasicDashboardData)) {
                return false;
            }
            BasicDashboardData other = (BasicDashboardData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            TimingData this$timingData = this.getTimingData();
            TimingData other$timingData = other.getTimingData();
            if (this$timingData == null ? other$timingData != null : !((Object)this$timingData).equals(other$timingData)) {
                return false;
            }
            CountData this$featureCounts = this.getFeatureCounts();
            CountData other$featureCounts = other.getFeatureCounts();
            if (this$featureCounts == null ? other$featureCounts != null : !((Object)this$featureCounts).equals(other$featureCounts)) {
                return false;
            }
            CountData this$scenarioCounts = this.getScenarioCounts();
            CountData other$scenarioCounts = other.getScenarioCounts();
            if (this$scenarioCounts == null ? other$scenarioCounts != null : !((Object)this$scenarioCounts).equals(other$scenarioCounts)) {
                return false;
            }
            CountData this$stepCounts = this.getStepCounts();
            CountData other$stepCounts = other.getStepCounts();
            return !(this$stepCounts == null ? other$stepCounts != null : !((Object)this$stepCounts).equals(other$stepCounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BasicDashboardData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            TimingData $timingData = this.getTimingData();
            result = result * 59 + ($timingData == null ? 43 : ((Object)$timingData).hashCode());
            CountData $featureCounts = this.getFeatureCounts();
            result = result * 59 + ($featureCounts == null ? 43 : ((Object)$featureCounts).hashCode());
            CountData $scenarioCounts = this.getScenarioCounts();
            result = result * 59 + ($scenarioCounts == null ? 43 : ((Object)$scenarioCounts).hashCode());
            CountData $stepCounts = this.getStepCounts();
            result = result * 59 + ($stepCounts == null ? 43 : ((Object)$stepCounts).hashCode());
            return result;
        }

        public String toString() {
            return "SheetData.BasicDashboardData(title=" + this.getTitle() + ", timingData=" + this.getTimingData() + ", featureCounts=" + this.getFeatureCounts() + ", scenarioCounts=" + this.getScenarioCounts() + ", stepCounts=" + this.getStepCounts() + ")";
        }

        public static class BasicDashboardDataBuilder {
            private boolean title$set;
            private String title$value;
            private TimingData timingData;
            private CountData featureCounts;
            private CountData scenarioCounts;
            private CountData stepCounts;

            BasicDashboardDataBuilder() {
            }

            public BasicDashboardDataBuilder title(String title) {
                this.title$value = title;
                this.title$set = true;
                return this;
            }

            public BasicDashboardDataBuilder timingData(TimingData timingData) {
                this.timingData = timingData;
                return this;
            }

            public BasicDashboardDataBuilder featureCounts(CountData featureCounts) {
                this.featureCounts = featureCounts;
                return this;
            }

            public BasicDashboardDataBuilder scenarioCounts(CountData scenarioCounts) {
                this.scenarioCounts = scenarioCounts;
                return this;
            }

            public BasicDashboardDataBuilder stepCounts(CountData stepCounts) {
                this.stepCounts = stepCounts;
                return this;
            }

            public BasicDashboardData build() {
                String title$value = this.title$value;
                if (!this.title$set) {
                    title$value = BasicDashboardData.$default$title();
                }
                return new BasicDashboardData(title$value, this.timingData, this.featureCounts, this.scenarioCounts, this.stepCounts);
            }

            public String toString() {
                return "SheetData.BasicDashboardData.BasicDashboardDataBuilder(title$value=" + this.title$value + ", timingData=" + this.timingData + ", featureCounts=" + this.featureCounts + ", scenarioCounts=" + this.scenarioCounts + ", stepCounts=" + this.stepCounts + ")";
            }
        }
    }
}

