/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.generator;

import java.util.List;
import tech.grasshopper.excel.report.exception.ExcelReportException;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;
import tech.grasshopper.extent.data.pojo.Status;
import tech.grasshopper.extent.data.pojo.Step;

public class HeirarchyDataPopulator {
    private List<Feature> features;

    public void populateCountsAndParentDetails() {
        if (this.features == null || this.features.size() == 0) {
            throw new ExcelReportException("No features present in test execution.");
        }
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                for (Step step : scenario.getSteps()) {
                    if (step.getStatus() == Status.PASSED) {
                        scenario.setPassedSteps(scenario.getPassedSteps() + 1L);
                        feature.setPassedSteps(feature.getPassedSteps() + 1L);
                    } else if (step.getStatus() == Status.FAILED) {
                        scenario.setFailedSteps(scenario.getFailedSteps() + 1L);
                        feature.setFailedSteps(feature.getFailedSteps() + 1L);
                    } else {
                        scenario.setSkippedSteps(scenario.getSkippedSteps() + 1L);
                        feature.setSkippedSteps(feature.getSkippedSteps() + 1L);
                    }
                    scenario.setTotalSteps(scenario.getTotalSteps() + 1L);
                    feature.setTotalSteps(feature.getTotalSteps() + 1L);
                    step.setScenario(scenario);
                    step.setFeature(feature);
                }
                if (scenario.getStatus() == Status.PASSED) {
                    feature.setPassedScenarios(feature.getPassedScenarios() + 1L);
                } else if (scenario.getStatus() == Status.FAILED) {
                    feature.setFailedScenarios(feature.getFailedScenarios() + 1L);
                } else {
                    feature.setSkippedScenarios(feature.getSkippedScenarios() + 1L);
                }
                feature.setTotalScenarios(feature.getTotalScenarios() + 1L);
                scenario.setFeature(feature);
            }
        }
    }

    HeirarchyDataPopulator(List<Feature> features) {
        this.features = features;
    }

    public static HeirarchyDataPopulatorBuilder builder() {
        return new HeirarchyDataPopulatorBuilder();
    }

    public static class HeirarchyDataPopulatorBuilder {
        private List<Feature> features;

        HeirarchyDataPopulatorBuilder() {
        }

        public HeirarchyDataPopulatorBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public HeirarchyDataPopulator build() {
            return new HeirarchyDataPopulator(this.features);
        }

        public String toString() {
            return "HeirarchyDataPopulator.HeirarchyDataPopulatorBuilder(features=" + this.features + ")";
        }
    }
}

