/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.dashboard.components;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import tech.grasshopper.excel.report.cell.CellValueOptions;
import tech.grasshopper.excel.report.chart.ChartOperations;
import tech.grasshopper.excel.report.sheets.dashboard.components.DBComponent;
import tech.grasshopper.excel.report.table.AttributeFeatureScenarioTable;
import tech.grasshopper.excel.report.table.SimpleTableOperations;
import tech.grasshopper.extent.data.SheetData;

public class TagFailSkipDBComponent
extends DBComponent {
    private String failSkipTableStartCell;

    @Override
    public void createComponent() {
        this.updateTagTableData();
        this.refreshTagChartPlot();
        this.updateDBScenarioFeatureFailSkipTagTableData();
    }

    private void updateTagTableData() {
        SimpleTableOperations<SheetData.AttributeCountData> dbDataTableOperations = SimpleTableOperations.builder().sheet(this.dbDataSheet).build();
        Function<SheetData.AttributeCountData, List> rowValueTransformer = t -> {
            ArrayList<String> row = new ArrayList<String>();
            SheetData.CountData counts = t.getScenarioCounts();
            row.add(t.getName());
            row.add(String.valueOf(counts.getPassed()));
            row.add(String.valueOf(counts.getFailed()));
            row.add(String.valueOf(counts.getSkipped()));
            return row;
        };
        ArrayList<CellValueOptions> cellOptions = new ArrayList<CellValueOptions>();
        cellOptions.add(CellValueOptions.EMPTY_CELL_OPTIONS);
        cellOptions.add(CellValueOptions.POSITIVENUMBER_HORIZCENTER_CELL_OPTIONS);
        cellOptions.add(CellValueOptions.POSITIVENUMBER_HORIZCENTER_CELL_OPTIONS);
        cellOptions.add(CellValueOptions.POSITIVENUMBER_HORIZCENTER_CELL_OPTIONS);
        dbDataTableOperations.writeTableCellValues("A20", this.reportData.getFailSkipTagCountData(), rowValueTransformer, cellOptions);
    }

    private void refreshTagChartPlot() {
        ChartOperations dbChartOperations = ChartOperations.builder().dataSheet(this.dbDataSheet).chartSheet(this.dbSheet).build();
        int rows = this.reportData.getFailSkipTagCountData().size();
        ChartOperations.ChartDataSeriesRange categoryRange = ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("A20", rows);
        ArrayList<ChartOperations.ChartDataSeriesRange> valueRanges = new ArrayList<ChartOperations.ChartDataSeriesRange>();
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("B20", rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("D20", rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange("C20", rows));
        dbChartOperations.updateBarChartPlot("Tags with Failed & Skipped Scenarios", categoryRange, valueRanges);
    }

    private void updateDBScenarioFeatureFailSkipTagTableData() {
        AttributeFeatureScenarioTable.builder().featureAndScenarioAttributeData(this.reportData.getFailSkipFeatureAndScenarioTagData()).sheet(this.dbSheet).startCell(this.failSkipTableStartCell).columnCellCount(new int[]{1, 3, 1, 1}).build().writeTableValues();
    }

    protected TagFailSkipDBComponent(TagFailSkipDBComponentBuilder<?, ?> b) {
        super(b);
        this.failSkipTableStartCell = ((TagFailSkipDBComponentBuilder)b).failSkipTableStartCell;
    }

    public static TagFailSkipDBComponentBuilder<?, ?> builder() {
        return new TagFailSkipDBComponentBuilderImpl();
    }

    private static final class TagFailSkipDBComponentBuilderImpl
    extends TagFailSkipDBComponentBuilder<TagFailSkipDBComponent, TagFailSkipDBComponentBuilderImpl> {
        private TagFailSkipDBComponentBuilderImpl() {
        }

        @Override
        protected TagFailSkipDBComponentBuilderImpl self() {
            return this;
        }

        @Override
        public TagFailSkipDBComponent build() {
            return new TagFailSkipDBComponent(this);
        }
    }

    public static abstract class TagFailSkipDBComponentBuilder<C extends TagFailSkipDBComponent, B extends TagFailSkipDBComponentBuilder<C, B>>
    extends DBComponent.DBComponentBuilder<C, B> {
        private String failSkipTableStartCell;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B failSkipTableStartCell(String failSkipTableStartCell) {
            this.failSkipTableStartCell = failSkipTableStartCell;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TagFailSkipDBComponent.TagFailSkipDBComponentBuilder(super=" + super.toString() + ", failSkipTableStartCell=" + this.failSkipTableStartCell + ")";
        }
    }
}

