/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.exceptions;

import org.apache.poi.ss.util.CellReference;
import tech.grasshopper.excel.report.sheets.Sheet;
import tech.grasshopper.excel.report.table.ExceptionsTable;

public class ExceptionsSheet
extends Sheet {
    private static final String EXCEPTIONS_TABLE_FEATURE_NAME_CELL = "B3";
    private static final int FREEZE_PANE_ROW = 2;

    @Override
    public void updateSheet() {
        this.sheet = this.workbook.getSheet("Exceptions");
        if (this.reportData.getExceptionData().isEmpty()) {
            this.deleteSheet("Exceptions");
            return;
        }
        this.updateExceptionsTableData(new CellReference(EXCEPTIONS_TABLE_FEATURE_NAME_CELL));
        this.sheet.createFreezePane(0, 2);
        this.lockSheet();
    }

    private void updateExceptionsTableData(CellReference cellRef) {
        ExceptionsTable.builder().exceptionsData(this.reportData.getExceptionData()).sheet(this.sheet).startCell(cellRef.formatAsString()).build().writeTableValues();
    }

    protected ExceptionsSheet(ExceptionsSheetBuilder<?, ?> b) {
        super(b);
    }

    public static ExceptionsSheetBuilder<?, ?> builder() {
        return new ExceptionsSheetBuilderImpl();
    }

    private static final class ExceptionsSheetBuilderImpl
    extends ExceptionsSheetBuilder<ExceptionsSheet, ExceptionsSheetBuilderImpl> {
        private ExceptionsSheetBuilderImpl() {
        }

        @Override
        protected ExceptionsSheetBuilderImpl self() {
            return this;
        }

        @Override
        public ExceptionsSheet build() {
            return new ExceptionsSheet(this);
        }
    }

    public static abstract class ExceptionsSheetBuilder<C extends ExceptionsSheet, B extends ExceptionsSheetBuilder<C, B>>
    extends Sheet.SheetBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ExceptionsSheet.ExceptionsSheetBuilder(super=" + super.toString() + ")";
        }
    }
}

