/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.table;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.excel.report.cell.CellValueOptions;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;

public class AttributeFeatureScenarioTable {
    private XSSFSheet sheet;
    private String startCell;
    private Map<String, List<Feature>> featureAndScenarioAttributeData;
    private int[] columnCellCount;
    private boolean groupRows;

    public void writeTableValues() {
        CellOperations cellOperations = CellOperations.builder().sheet(this.sheet).build();
        CellReference cellRef = new CellReference(this.startCell);
        int startRow = cellRef.getRow();
        int startCol = cellRef.getCol();
        int rowCount = (int)this.featureAndScenarioAttributeData.values().stream().flatMap(Collection::stream).mapToLong(f -> f.getTotalScenarios()).sum();
        cellOperations.createCellsWithStyleInRange(startRow, startRow + rowCount, startCol, startCol + Arrays.stream(this.columnCellCount).sum());
        int currentRow = startRow;
        for (Map.Entry<String, List<Feature>> entry : this.featureAndScenarioAttributeData.entrySet()) {
            int currentCol = startCol;
            String tag = entry.getKey();
            List<Feature> features = entry.getValue();
            long tagMergeRowCount = features.stream().mapToLong(f -> f.getTotalScenarios()).sum();
            cellOperations.mergeRows(currentRow, (int)tagMergeRowCount, currentCol, this.columnCellCount[0]);
            cellOperations.writeValue(new CellReference(currentRow, currentCol), tag, CellValueOptions.BOLD_CELL_OPTIONS);
            currentCol += this.columnCellCount[0];
            for (Feature feature : features) {
                cellOperations.mergeRows(currentRow, (int)feature.getTotalScenarios(), currentCol, this.columnCellCount[1]);
                cellOperations.writeValue(new CellReference(currentRow, currentCol), feature.getName(), CellValueOptions.getStatusColorCellValueOption(feature.getStatus()));
                currentCol += this.columnCellCount[1];
                for (Scenario scenario : feature.getScenarios()) {
                    cellOperations.mergeRows(currentRow, 1, currentCol, this.columnCellCount[2]);
                    cellOperations.writeValue(new CellReference(currentRow, currentCol), scenario.getName(), CellValueOptions.getStatusColorCellValueOption(scenario.getStatus()));
                    cellOperations.mergeRows(currentRow, 1, currentCol += this.columnCellCount[2], this.columnCellCount[3]);
                    cellOperations.writeValue(new CellReference(currentRow, currentCol), scenario.getStatus().toString(), CellValueOptions.STATUS_BOLD_CELL_OPTIONS);
                    currentCol -= this.columnCellCount[2];
                    ++currentRow;
                }
                currentCol -= this.columnCellCount[1];
            }
        }
        if (this.groupRows) {
            this.sheet.groupRow(startRow, startRow + rowCount - 1);
            this.sheet.setRowGroupCollapsed(startRow, true);
        }
    }

    private static boolean $default$groupRows() {
        return false;
    }

    AttributeFeatureScenarioTable(XSSFSheet sheet, String startCell, Map<String, List<Feature>> featureAndScenarioAttributeData, int[] columnCellCount, boolean groupRows) {
        this.sheet = sheet;
        this.startCell = startCell;
        this.featureAndScenarioAttributeData = featureAndScenarioAttributeData;
        this.columnCellCount = columnCellCount;
        this.groupRows = groupRows;
    }

    public static AttributeFeatureScenarioTableBuilder builder() {
        return new AttributeFeatureScenarioTableBuilder();
    }

    public static class AttributeFeatureScenarioTableBuilder {
        private XSSFSheet sheet;
        private String startCell;
        private Map<String, List<Feature>> featureAndScenarioAttributeData;
        private int[] columnCellCount;
        private boolean groupRows$set;
        private boolean groupRows$value;

        AttributeFeatureScenarioTableBuilder() {
        }

        public AttributeFeatureScenarioTableBuilder sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public AttributeFeatureScenarioTableBuilder startCell(String startCell) {
            this.startCell = startCell;
            return this;
        }

        public AttributeFeatureScenarioTableBuilder featureAndScenarioAttributeData(Map<String, List<Feature>> featureAndScenarioAttributeData) {
            this.featureAndScenarioAttributeData = featureAndScenarioAttributeData;
            return this;
        }

        public AttributeFeatureScenarioTableBuilder columnCellCount(int[] columnCellCount) {
            this.columnCellCount = columnCellCount;
            return this;
        }

        public AttributeFeatureScenarioTableBuilder groupRows(boolean groupRows) {
            this.groupRows$value = groupRows;
            this.groupRows$set = true;
            return this;
        }

        public AttributeFeatureScenarioTable build() {
            boolean groupRows$value = this.groupRows$value;
            if (!this.groupRows$set) {
                groupRows$value = AttributeFeatureScenarioTable.$default$groupRows();
            }
            return new AttributeFeatureScenarioTable(this.sheet, this.startCell, this.featureAndScenarioAttributeData, this.columnCellCount, groupRows$value);
        }

        public String toString() {
            return "AttributeFeatureScenarioTable.AttributeFeatureScenarioTableBuilder(sheet=" + this.sheet + ", startCell=" + this.startCell + ", featureAndScenarioAttributeData=" + this.featureAndScenarioAttributeData + ", columnCellCount=" + Arrays.toString(this.columnCellCount) + ", groupRows$value=" + this.groupRows$value + ")";
        }
    }
}

