/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.descriptors.InstanceVariableAttributeAccessor;
import oracle.toplink.essentials.internal.descriptors.MethodAttributeAccessor;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.AttributeAccessor;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.ObjectCopyingPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseMapping
implements Cloneable,
Serializable {
    protected static Vector NO_FIELDS = NonSynchronizedVector.newInstance(0);
    protected static Integer NO_WEIGHT = new Integer(Integer.MAX_VALUE);
    protected static Integer WEIGHT_1 = new Integer(1);
    protected ClassDescriptor descriptor;
    protected AttributeAccessor attributeAccessor;
    protected boolean isReadOnly = false;
    protected boolean isOptional = true;
    protected Vector<DatabaseField> fields;
    protected boolean isRemotelyInitialized;
    protected Integer weight = NO_WEIGHT;
    protected Map properties;
    protected boolean primaryKeyMapping = false;

    public DatabaseMapping() {
        this.attributeAccessor = new InstanceVariableAttributeAccessor();
    }

    public abstract void buildBackupClone(Object var1, Object var2, UnitOfWorkImpl var3);

    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupCloneForPartObject");
    }

    public abstract void buildClone(Object var1, Object var2, UnitOfWorkImpl var3, JoinedAttributeManager var4);

    public abstract void buildCloneFromRow(AbstractRecord var1, JoinedAttributeManager var2, Object var3, ObjectBuildingQuery var4, UnitOfWorkImpl var5, AbstractSession var6);

    public void buildShallowOriginalFromRow(AbstractRecord databaseRow, Object original, ObjectBuildingQuery query, AbstractSession executionSession) {
    }

    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneForPartObject");
    }

    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
    }

    public Expression buildObjectJoinExpression(Expression base, Object value, AbstractSession session) {
        throw QueryException.unsupportedMappingForObjectComparison(this, base);
    }

    public Expression buildObjectJoinExpression(Expression base, Expression argument, AbstractSession session) {
        throw QueryException.unsupportedMappingForObjectComparison(this, base);
    }

    public abstract void cascadePerformRemoveIfRequired(Object var1, UnitOfWorkImpl var2, IdentityHashtable var3);

    public abstract void cascadeRegisterNewIfRequired(Object var1, UnitOfWorkImpl var2, IdentityHashtable var3);

    public void calculateDeferredChanges(ChangeRecord changeRecord, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "calculatedDeferredChanges");
    }

    public void cascadeMerge(Object sourceElement, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "cascadeMerge");
    }

    public Object clone() {
        DatabaseMapping mapping = null;
        try {
            mapping = (DatabaseMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        mapping.setAttributeAccessor((AttributeAccessor)this.attributeAccessor.clone());
        return mapping;
    }

    protected Vector cloneFields(Vector fields) {
        NonSynchronizedVector clonedFields = NonSynchronizedVector.newInstance();
        Enumeration fieldsEnum = fields.elements();
        while (fieldsEnum.hasMoreElements()) {
            ((Vector)clonedFields).addElement(((DatabaseField)fieldsEnum.nextElement()).clone());
        }
        return clonedFields;
    }

    protected Vector<DatabaseField> collectFields() {
        return NO_FIELDS;
    }

    public abstract ChangeRecord compareForChange(Object var1, Object var2, ObjectChangeSet var3, AbstractSession var4);

    public abstract boolean compareObjects(Object var1, Object var2, AbstractSession var3);

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractRecord row, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        throw DescriptorException.invalidMappingOperation(this, "createUnitOfWorkValueHolder");
    }

    protected Vector extractNestedExpressions(List expressions, ExpressionBuilder newRoot, boolean rootExpressionsAllowed) {
        NonSynchronizedVector nestedExpressions = NonSynchronizedVector.newInstance(expressions.size());
        for (Expression next : expressions) {
            QueryKeyExpression expression;
            if (!next.isQueryKeyExpression()) continue;
            QueryKeyExpression base = expression = (QueryKeyExpression)next;
            boolean afterBase = false;
            while (!base.getBaseExpression().isExpressionBuilder()) {
                afterBase = true;
                base = (QueryKeyExpression)base.getBaseExpression();
            }
            if (afterBase && base.getName().equals(this.getAttributeName())) {
                ((Vector)nestedExpressions).addElement(expression.rebuildOn(base, newRoot));
                continue;
            }
            if (!rootExpressionsAllowed || !expression.getBaseExpression().isExpressionBuilder() || !expression.getName().equals(this.getAttributeName())) continue;
            ((Vector)nestedExpressions).addElement(newRoot);
        }
        return nestedExpressions;
    }

    public AttributeAccessor getAttributeAccessor() {
        return this.attributeAccessor;
    }

    public Class getAttributeClassification() {
        return null;
    }

    public String getAttributeName() {
        return this.getAttributeAccessor().getAttributeName();
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        try {
            return this.getAttributeAccessor().getAttributeValueFromObject(object);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
    }

    public ContainerPolicy getContainerPolicy() {
        throw DescriptorException.invalidMappingOperation(this, "getContainerPolicy");
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DatabaseField getField() {
        return null;
    }

    public Class getFieldClassification(DatabaseField fieldToClassify) {
        return null;
    }

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public String getGetMethodName() {
        if (!(this.getAttributeAccessor() instanceof MethodAttributeAccessor)) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodName();
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(Object property) {
        if (this.properties == null) {
            return null;
        }
        return this.getProperties().get(property);
    }

    public Object getRealAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        return this.getAttributeValueFromObject(object);
    }

    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "getRealCollectionAttributeValueFromObject");
    }

    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    public ClassDescriptor getReferenceClassDescriptor() {
        ClassDescriptor desc = this.getReferenceDescriptor();
        if (desc instanceof ClassDescriptor) {
            return desc;
        }
        throw ValidationException.cannotCastToClass(desc, desc.getClass(), ClassDescriptor.class);
    }

    public DatabaseMapping getRelationshipPartner() {
        return null;
    }

    public String getSetMethodName() {
        if (!(this.getAttributeAccessor() instanceof MethodAttributeAccessor)) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodName();
    }

    public Integer getWeight() {
        return this.weight;
    }

    public boolean hasConstraintDependency() {
        return false;
    }

    public boolean isUsingMethodAccess() {
        return this.getAttributeAccessor() instanceof MethodAttributeAccessor;
    }

    public boolean hasDependency() {
        return this.isPrivateOwned();
    }

    public boolean hasInverseConstraintDependency() {
        return false;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
    }

    public boolean isAggregateCollectionMapping() {
        return false;
    }

    public boolean isAggregateMapping() {
        return false;
    }

    public boolean isAggregateObjectMapping() {
        return false;
    }

    public boolean isCollectionMapping() {
        return false;
    }

    public boolean isDatabaseMapping() {
        return true;
    }

    public boolean isDirectCollectionMapping() {
        return false;
    }

    public boolean isDirectMapMapping() {
        return false;
    }

    public boolean isDirectToFieldMapping() {
        return false;
    }

    public boolean isForeignReferenceMapping() {
        return false;
    }

    public boolean isManyToManyMapping() {
        return false;
    }

    public boolean isNestedTableMapping() {
        return false;
    }

    public boolean isObjectReferenceMapping() {
        return false;
    }

    public boolean isObjectTypeMapping() {
        return false;
    }

    public boolean isOneToManyMapping() {
        return false;
    }

    public boolean isOneToOneMapping() {
        return false;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isEISMapping() {
        return false;
    }

    public boolean isRelationalMapping() {
        return false;
    }

    public boolean isXMLMapping() {
        return false;
    }

    public boolean isAbstractDirectMapping() {
        return false;
    }

    public boolean isAbstractCompositeDirectCollectionMapping() {
        return false;
    }

    public boolean isAbstractCompositeObjectMapping() {
        return false;
    }

    public boolean isAbstractCompositeCollectionMapping() {
        return false;
    }

    public boolean isJoiningSupported() {
        return false;
    }

    public boolean isCloningRequired() {
        return true;
    }

    public boolean isPrimaryKeyMapping() {
        return this.primaryKeyMapping;
    }

    public boolean isCascadedLockingSupported() {
        return false;
    }

    public boolean isChangeTrackingSupported() {
        return false;
    }

    public boolean isPrivateOwned() {
        return false;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isReferenceMapping() {
        return false;
    }

    protected boolean isRemotelyInitialized() {
        return this.isRemotelyInitialized;
    }

    public boolean isSerializedObjectMapping() {
        return false;
    }

    public boolean isStructureMapping() {
        return false;
    }

    public boolean isTransformationMapping() {
        return false;
    }

    public boolean isTypeConversionMapping() {
        return false;
    }

    public boolean isVariableOneToOneMapping() {
        return false;
    }

    public boolean isDirectToXMLTypeMapping() {
        return false;
    }

    public boolean isWriteOnly() {
        return false;
    }

    public abstract void iterate(DescriptorIterator var1);

    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        throw DescriptorException.invalidMappingOperation(this, "iterateOnRealAttributeValue");
    }

    public abstract void mergeChangesIntoObject(Object var1, ChangeRecord var2, Object var3, MergeManager var4);

    public abstract void mergeIntoObject(Object var1, boolean var2, Object var3, MergeManager var4);

    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        throw DescriptorException.invalidDataModificationEvent(this);
    }

    public void postDelete(DeleteObjectQuery query) throws DatabaseException {
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException {
    }

    public void postUpdate(WriteObjectQuery query) throws DatabaseException {
    }

    public void preDelete(DeleteObjectQuery query) throws DatabaseException {
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        try {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            session.getIntegrityChecker().handleError(exception);
        }
    }

    public void preInsert(WriteObjectQuery query) throws DatabaseException {
    }

    public void prepareCascadeLockingPolicy() {
    }

    public void preUpdate(WriteObjectQuery query) throws DatabaseException {
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery) throws DatabaseException {
        return this.readFromRowIntoObject(databaseRow, joinManager, targetObject, sourceQuery, sourceQuery.getSession());
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, executionSession);
        this.setAttributeValueInObject(targetObject, attributeValue);
        return attributeValue;
    }

    public void readOnly() {
        this.setIsReadOnly(true);
    }

    public void readWrite() {
        this.setIsReadOnly(false);
    }

    public void rehashFieldDependancies(AbstractSession session) {
    }

    public void setAttributeAccessor(AttributeAccessor attributeAccessor) {
        String attributeName = this.getAttributeName();
        this.attributeAccessor = attributeAccessor;
        if (attributeAccessor.getAttributeName() == null) {
            attributeAccessor.setAttributeName(attributeName);
        }
    }

    public void setAttributeName(String attributeName) {
        this.getAttributeAccessor().setAttributeName(attributeName);
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        try {
            this.attributeAccessor.setAttributeValueInObject(object, value);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
    }

    public void setRealAttributeValueInObject(Object object, Object value) throws DescriptorException {
        try {
            this.setAttributeValueInObject(object, value);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void setFields(Vector<DatabaseField> fields) {
        this.fields = fields;
    }

    public void setGetMethodName(String methodName) {
        if (methodName == null) {
            return;
        }
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            String attributeName = this.attributeAccessor.getAttributeName();
            this.setAttributeAccessor(new MethodAttributeAccessor());
            this.getAttributeAccessor().setAttributeName(attributeName);
        }
        ((MethodAttributeAccessor)this.getAttributeAccessor()).setGetMethodName(methodName);
    }

    public void setIsOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public void setIsPrimaryKeyMapping(boolean pkMapping) {
        this.primaryKeyMapping = pkMapping;
    }

    public void setIsReadOnly(boolean aBoolean) {
        this.isReadOnly = aBoolean;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(Object property, Object value) {
        this.getProperties().put(property, value);
    }

    public void setSetMethodName(String methodName) {
        if (methodName == null) {
            return;
        }
        if (!(this.getAttributeAccessor() instanceof MethodAttributeAccessor)) {
            String attributeName = this.attributeAccessor.getAttributeName();
            this.setAttributeAccessor(new MethodAttributeAccessor());
            this.getAttributeAccessor().setAttributeName(attributeName);
        }
        ((MethodAttributeAccessor)this.getAttributeAccessor()).setSetMethodName(methodName);
    }

    public void setWeight(Integer newWeight) {
        this.weight = newWeight;
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "simpleAddToCollectionChangeRecord");
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "simpleRemoveFromCollectionChangeRecord");
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getAttributeName() + "]";
    }

    public void validateAfterInitialization(AbstractSession session) throws DescriptorException {
    }

    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
    }

    public Object valueFromObject(Object anObject, DatabaseField field, AbstractSession session) {
        return null;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query) throws DatabaseException {
        return this.valueFromRow(row, joinManager, query, query.getSession().getExecutionSession(query));
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession session) throws DatabaseException {
        return null;
    }

    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        return true;
    }

    public void writeFromAttributeIntoRow(Object attribute, AbstractRecord row, AbstractSession session) {
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord row, AbstractSession session) {
        this.writeFromObjectIntoRow(object, row, session);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
        this.writeFromObjectIntoRowWithChangeRecord(changeRecord, row, session);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord row) {
        this.writeFromObjectIntoRow(query.getObject(), row, query.getSession());
    }

    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery query, AbstractRecord row) {
        Object object = query.isDeleteObjectQuery() ? query.getObject() : query.getBackupClone();
        this.writeFromObjectIntoRow(object, row, query.getSession());
    }

    public void writeInsertFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
    }

    public void writeUpdateFieldsIntoRow(AbstractRecord databaseRow, AbstractSession session) {
        this.writeInsertFieldsIntoRow(databaseRow, session);
    }

    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "updateChangeRecord");
    }

    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "addToCollectionChangeRecord");
    }

    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "removeFromCollectionChangeRecord");
    }

    public ChangeRecord buildChangeRecord(Object newValue, ObjectChangeSet owner, AbstractSession session) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "buildChangeRecord");
    }
}

