/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sequencing;

import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.sequencing.SequencingConnectionHandler;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.sessions.Login;

class DatabaseSessionConnectionHandler
implements SequencingConnectionHandler {
    DatabaseSessionImpl ownerSession;
    Login login;
    Accessor accessor;
    boolean isBusy;

    DatabaseSessionConnectionHandler(DatabaseSessionImpl ownerSession, Login login) {
        this.ownerSession = ownerSession;
        this.login = login;
        this.accessor = login.buildAccessor();
    }

    public void onConnect() {
        if (!this.isConnected()) {
            this.accessor.connect(this.login, this.ownerSession);
        }
    }

    public boolean isConnected() {
        return this.accessor.isConnected();
    }

    public synchronized Accessor acquireAccessor() {
        if (this.isBusy) {
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                throw ConcurrencyException.waitFailureOnSequencingForDatabaseSession(exception);
            }
        }
        this.isBusy = true;
        return this.accessor;
    }

    public synchronized void releaseAccessor(Accessor accessor) {
        this.isBusy = false;
        this.notify();
    }

    public void onDisconnect() {
        if (this.isConnected()) {
            this.accessor.disconnect(this.ownerSession);
        }
    }

    protected void finalize() throws Throwable {
        this.onDisconnect();
    }
}

