/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.RelationalDescriptor;
import oracle.toplink.essentials.descriptors.TimestampLockingPolicy;
import oracle.toplink.essentials.descriptors.VersionLockingPolicy;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.ejb.cmp3.base.CMP3Policy;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.RelationshipAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.listeners.MetadataEntityListener;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataDescriptor {
    protected ClassAccessor m_accessor;
    protected ClassDescriptor m_descriptor;
    protected Class m_javaClass;
    protected boolean m_ignoreIDs;
    protected boolean m_ignoreTables;
    protected boolean m_isCascadePersist;
    protected boolean m_ignoreAnnotations;
    protected boolean m_ignoreInheritance;
    protected Boolean m_usesPropertyAccess;
    protected String m_xmlSchema;
    protected String m_xmlCatalog;
    protected String m_xmlAccess;
    protected String m_primaryTableName;
    protected String m_embeddedIdAttributeName;
    protected List<String> m_idAttributeNames;
    protected List<String> m_orderByAttributeNames;
    protected List<String> m_idOrderByAttributeNames;
    protected List<MetadataDescriptor> m_aggregateDescriptors;
    protected Map<String, Type> m_pkClassIDs;
    protected Map<String, MetadataAccessor> m_accessors;
    protected Map<String, String> m_pkJoinColumnAssociations;
    protected Map<String, MetadataColumn> m_attributeOverrides;
    protected Map<String, MetadataJoinColumns> m_associationOverrides;
    protected Map<String, RelationshipAccessor> m_relationshipAccessors;
    protected Map<String, Map<String, MetadataAccessor>> m_biDirectionalManyToManyAccessors;

    public MetadataDescriptor(Class javaClass) {
        this.init();
        this.m_descriptor = new RelationalDescriptor();
        this.m_descriptor.setExistenceChecking("Check database");
        this.m_descriptor.setAlias("");
        this.setJavaClass(javaClass);
    }

    public void addAccessor(MetadataAccessor accessor) {
        String mappedBy;
        this.m_accessors.put(accessor.getAttributeName(), accessor);
        if (accessor.isRelationship()) {
            this.m_relationshipAccessors.put(accessor.getAttributeName(), (RelationshipAccessor)accessor);
        }
        if (accessor.isManyToMany() && !(mappedBy = ((RelationshipAccessor)accessor).getMappedBy()).equals("")) {
            String referenceClassName = accessor.getReferenceClassName();
            if (!this.m_biDirectionalManyToManyAccessors.containsKey(referenceClassName)) {
                this.m_biDirectionalManyToManyAccessors.put(referenceClassName, new HashMap());
            }
            this.m_biDirectionalManyToManyAccessors.get(referenceClassName).put(mappedBy, accessor);
        }
    }

    public void addAggregateDescriptor(MetadataDescriptor aggregateDescriptor) {
        this.m_aggregateDescriptors.add(aggregateDescriptor);
    }

    public void addAssociationOverride(String attributeName, MetadataJoinColumns joinColumns) {
        this.m_associationOverrides.put(attributeName, joinColumns);
    }

    public void addAttributeOverride(MetadataColumn column) {
        this.m_attributeOverrides.put(column.getAttributeName(), column);
    }

    public void addClassIndicator(Class entityClass, String value) {
        if (this.m_accessor.isInheritanceSubclass()) {
            this.m_accessor.getInheritanceParentDescriptor().addClassIndicator(entityClass, value);
        } else {
            this.m_descriptor.getInheritancePolicy().addClassNameIndicator(entityClass.getName(), value);
        }
    }

    public void addDefaultEventListener(MetadataEntityListener listener) {
        this.m_descriptor.getEventManager().addDefaultEventListener(listener);
    }

    public void addEntityListenerEventListener(MetadataEntityListener listener) {
        this.m_descriptor.getEventManager().addEntityListenerEventListener(listener);
    }

    public void addIdAttributeName(String idAttributeName) {
        this.m_idAttributeNames.add(idAttributeName);
    }

    public void addMapping(DatabaseMapping mapping) {
        this.m_descriptor.addMapping(mapping);
    }

    public void addMultipleTableForeignKeyField(DatabaseField pkField, DatabaseField fkField) {
        this.m_descriptor.addMultipleTableForeignKeyField(pkField, fkField);
        this.m_pkJoinColumnAssociations.put(fkField.getName(), pkField.getName());
    }

    public void addMultipleTablePrimaryKeyField(DatabaseField pkField, DatabaseField fkField) {
        this.m_descriptor.addMultipleTablePrimaryKeyField(pkField, fkField);
    }

    public void addPKClassId(String attributeName, Type type) {
        this.m_pkClassIDs.put(attributeName, type);
    }

    public void addPrimaryKeyField(DatabaseField field) {
        this.m_descriptor.addPrimaryKeyField(field);
    }

    public void addTable(DatabaseTable table) {
        this.m_descriptor.addTable(table);
    }

    public boolean excludeSuperclassListeners() {
        return this.m_descriptor.getEventManager().excludeSuperclassListeners();
    }

    public MetadataAccessor getAccessorFor(String fieldOrPropertyName) {
        MetadataAccessor accessor = this.m_accessors.get(fieldOrPropertyName);
        if (accessor == null && (accessor = this.m_accessors.get(MetadataHelper.getAttributeNameFromMethodName(fieldOrPropertyName))) == null && this.m_accessor.isInheritanceSubclass()) {
            accessor = this.m_accessor.getInheritanceParentDescriptor().getAccessorFor(fieldOrPropertyName);
        }
        return accessor;
    }

    public String getAlias() {
        return this.m_descriptor.getAlias();
    }

    public MetadataJoinColumns getAssociationOverrideFor(String attributeName) {
        return this.m_associationOverrides.get(attributeName);
    }

    public MetadataColumn getAttributeOverrideFor(String attributeName) {
        return this.m_attributeOverrides.get(attributeName);
    }

    public DatabaseField getClassIndicatorField() {
        if (this.m_accessor.getInheritanceParentDescriptor() != null) {
            return this.m_accessor.getInheritanceParentDescriptor().getClassDescriptor().getInheritancePolicy().getClassIndicatorField();
        }
        if (this.getClassDescriptor().hasInheritance()) {
            return this.getClassDescriptor().getInheritancePolicy().getClassIndicatorField();
        }
        return null;
    }

    public String getDefaultTableName() {
        String defaultTableName = this.getAlias().toUpperCase();
        if (this.m_accessor.isInheritanceSubclass() && this.m_accessor.getInheritanceParentDescriptor().usesSingleTableInheritanceStrategy()) {
            defaultTableName = this.m_accessor.getInheritanceParentDescriptor().getPrimaryTableName();
        }
        return defaultTableName;
    }

    public String getCatalog() {
        return this.m_xmlCatalog;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_accessor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_descriptor;
    }

    public String getEmbeddedIdAttributeName() {
        return this.m_embeddedIdAttributeName;
    }

    public String getIdAttributeName() {
        if (this.getIdAttributeNames().isEmpty()) {
            if (this.m_accessor.isInheritanceSubclass()) {
                return this.m_accessor.getInheritanceParentDescriptor().getIdAttributeName();
            }
            return "";
        }
        return this.getIdAttributeNames().get(0);
    }

    public List<String> getIdAttributeNames() {
        return this.m_idAttributeNames;
    }

    public List<String> getIdOrderByAttributeNames() {
        if (this.m_idOrderByAttributeNames.isEmpty()) {
            this.m_idOrderByAttributeNames = this.m_idAttributeNames.isEmpty() ? (this.m_accessor.isInheritanceSubclass() ? this.m_accessor.getInheritanceParentDescriptor().getIdAttributeNames() : this.getAccessorFor(this.getEmbeddedIdAttributeName()).getReferenceDescriptor().getOrderByAttributeNames()) : this.m_idAttributeNames;
        }
        return this.m_idOrderByAttributeNames;
    }

    public MetadataAccessor getBiDirectionalManyToManyAccessor(String className, String attributeName) {
        return this.m_biDirectionalManyToManyAccessors.get(className).get(attributeName);
    }

    public List<String> getOrderByAttributeNames() {
        if (this.m_orderByAttributeNames.isEmpty()) {
            for (DatabaseMapping mapping : this.getMappings()) {
                if (!mapping.isDirectToFieldMapping()) continue;
                this.m_orderByAttributeNames.add(mapping.getAttributeName());
            }
        }
        return this.m_orderByAttributeNames;
    }

    public Class getJavaClass() {
        return this.m_javaClass;
    }

    public String getJavaClassName() {
        return this.m_descriptor.getJavaClassName();
    }

    public MetadataLogger getLogger() {
        return this.getClassAccessor().getLogger();
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName) {
        return this.getMappingForAttributeName(attributeName, null);
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName, MetadataAccessor referencingAccessor) {
        MetadataAccessor accessor = this.getAccessorFor(attributeName);
        if (accessor != null) {
            if (accessor.isRelationship()) {
                RelationshipAccessor relationshipAccessor = (RelationshipAccessor)accessor;
                if (referencingAccessor != null && !relationshipAccessor.isManyToOne() && relationshipAccessor.getMappedBy().equals(referencingAccessor.getAttributeName())) {
                    this.getValidator().throwCircularMappedByReferences(referencingAccessor.getJavaClass(), referencingAccessor.getAttributeName(), this.getJavaClass(), attributeName);
                }
                relationshipAccessor.processRelationship();
            }
            return this.m_descriptor.getMappingForAttributeName(attributeName);
        }
        for (MetadataDescriptor aggregateDmd : this.m_aggregateDescriptors) {
            DatabaseMapping mapping = aggregateDmd.getMappingForAttributeName(attributeName, referencingAccessor);
            if (mapping == null) continue;
            return mapping;
        }
        if (this.m_accessor.isInheritanceSubclass()) {
            return this.m_accessor.getInheritanceParentDescriptor().getMappingForAttributeName(attributeName, referencingAccessor);
        }
        return null;
    }

    public List<DatabaseMapping> getMappings() {
        return this.m_descriptor.getMappings();
    }

    public String getPKClassName() {
        String pkClassName = null;
        if (this.m_descriptor.hasCMPPolicy()) {
            pkClassName = ((CMP3Policy)this.m_descriptor.getCMPPolicy()).getPKClassName();
        }
        return pkClassName;
    }

    public String getPrimaryKeyFieldName() {
        return this.getPrimaryKeyFields().iterator().next().getName();
    }

    public List<String> getPrimaryKeyFieldNames() {
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        ArrayList<String> primaryKeyFieldNames = new ArrayList<String>(primaryKeyFields.size());
        for (DatabaseField primaryKeyField : primaryKeyFields) {
            primaryKeyFieldNames.add(primaryKeyField.getName());
        }
        return primaryKeyFieldNames;
    }

    public List<DatabaseField> getPrimaryKeyFields() {
        List<DatabaseField> primaryKeyFields = this.m_descriptor.getPrimaryKeyFields();
        if (primaryKeyFields.isEmpty() && this.m_accessor.isInheritanceSubclass()) {
            primaryKeyFields = this.m_accessor.getInheritanceParentDescriptor().getPrimaryKeyFields();
        }
        return primaryKeyFields;
    }

    public String getPrimaryKeyJoinColumnAssociation(String foreignKeyName) {
        String primaryKeyName = this.m_pkJoinColumnAssociations.get(foreignKeyName);
        if (primaryKeyName == null || !this.m_accessor.isInheritanceSubclass()) {
            return foreignKeyName;
        }
        return this.m_accessor.getInheritanceParentDescriptor().getPrimaryKeyJoinColumnAssociation(primaryKeyName);
    }

    public String getPrimaryKeyTableName() {
        return this.getPrimaryKeyFields().iterator().next().getTable().getQualifiedName();
    }

    public String getPrimaryTableName() {
        if (this.m_primaryTableName == null && this.m_accessor.isInheritanceSubclass()) {
            return this.m_accessor.getInheritanceParentDescriptor().getPrimaryTableName();
        }
        if (this.m_descriptor.isAggregateDescriptor()) {
            return "";
        }
        return this.m_primaryTableName;
    }

    public MetadataProject getProject() {
        return this.getClassAccessor().getProject();
    }

    public Collection<RelationshipAccessor> getRelationshipAccessors() {
        return this.m_relationshipAccessors.values();
    }

    public String getSchema() {
        return this.m_xmlSchema;
    }

    public DatabaseField getSequenceNumberField() {
        return this.m_descriptor.getSequenceNumberField();
    }

    public MetadataValidator getValidator() {
        return this.getClassAccessor().getValidator();
    }

    public boolean hasAssociationOverrideFor(String attributeName) {
        return this.m_associationOverrides.containsKey(attributeName);
    }

    public boolean hasAttributeOverrideFor(String attributeName) {
        return this.m_attributeOverrides.containsKey(attributeName);
    }

    public boolean hasCompositePrimaryKey() {
        return this.getPrimaryKeyFields().size() > 1 || this.getPKClassName() != null;
    }

    public boolean hasEmbeddedIdAttribute() {
        return this.m_embeddedIdAttributeName != null;
    }

    public boolean hasInheritance() {
        return this.m_descriptor.hasInheritance();
    }

    public boolean hasBiDirectionalManyToManyAccessorFor(String className, String attributeName) {
        if (this.m_biDirectionalManyToManyAccessors.containsKey(className)) {
            return this.m_biDirectionalManyToManyAccessors.get(className).containsKey(attributeName);
        }
        return false;
    }

    public boolean hasMappingForAttributeName(String attributeName) {
        return this.m_descriptor.getMappingForAttributeName(attributeName) != null;
    }

    public boolean hasPrimaryKeyFields() {
        return this.m_descriptor.getPrimaryKeyFields().size() > 0;
    }

    public boolean ignoreIDs() {
        return this.m_ignoreIDs;
    }

    public boolean ignoreInheritance() {
        return this.m_ignoreInheritance;
    }

    public boolean ignoreTables() {
        return this.m_ignoreTables;
    }

    private void init() {
        this.m_xmlAccess = "";
        this.m_xmlSchema = "";
        this.m_xmlCatalog = "";
        this.m_ignoreIDs = false;
        this.m_ignoreTables = false;
        this.m_isCascadePersist = false;
        this.m_ignoreInheritance = false;
        this.m_ignoreAnnotations = false;
        this.m_idAttributeNames = new ArrayList<String>();
        this.m_orderByAttributeNames = new ArrayList<String>();
        this.m_idOrderByAttributeNames = new ArrayList<String>();
        this.m_aggregateDescriptors = new ArrayList<MetadataDescriptor>();
        this.m_pkClassIDs = new HashMap<String, Type>();
        this.m_accessors = new HashMap<String, MetadataAccessor>();
        this.m_pkJoinColumnAssociations = new HashMap<String, String>();
        this.m_attributeOverrides = new HashMap<String, MetadataColumn>();
        this.m_associationOverrides = new HashMap<String, MetadataJoinColumns>();
        this.m_relationshipAccessors = new HashMap<String, RelationshipAccessor>();
        this.m_biDirectionalManyToManyAccessors = new HashMap<String, Map<String, MetadataAccessor>>();
    }

    public boolean isCascadePersist() {
        return this.m_isCascadePersist;
    }

    public boolean isEmbeddable() {
        return this.m_descriptor.isAggregateDescriptor();
    }

    public boolean isEmbeddableCollection() {
        return this.m_descriptor.isAggregateCollectionDescriptor();
    }

    public boolean isXmlFieldAccess() {
        return this.m_xmlAccess.equals("FIELD");
    }

    public boolean isXmlPropertyAccess() {
        return this.m_xmlAccess.equals("PROPERTY");
    }

    public boolean pkClassWasNotValidated() {
        return !this.m_pkClassIDs.isEmpty();
    }

    public void setAccess(String access) {
        this.m_xmlAccess = access;
    }

    public void setAlias(String alias) {
        this.m_descriptor.setAlias(alias);
    }

    public void setCatalog(String xmlCatalog) {
        this.m_xmlCatalog = xmlCatalog;
    }

    public void setClassAccessor(ClassAccessor accessor) {
        this.m_accessor = accessor;
    }

    public void setClassIndicatorField(DatabaseField field) {
        this.m_descriptor.getInheritancePolicy().setClassIndicatorField(field);
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setEmbeddedIdAttributeName(String embeddedIdAttributeName) {
        this.m_embeddedIdAttributeName = embeddedIdAttributeName;
    }

    public void setEntityEventListener(MetadataEntityListener listener) {
        this.m_descriptor.getEventManager().setEntityEventListener(listener);
    }

    public void setExcludeDefaultListeners(boolean excludeDefaultListeners) {
        this.m_descriptor.getEventManager().setExcludeDefaultListeners(excludeDefaultListeners);
    }

    public void setExcludeSuperclassListeners(boolean excludeSuperclassListeners) {
        this.m_descriptor.getEventManager().setExcludeSuperclassListeners(excludeSuperclassListeners);
    }

    public void setIgnoreFlags() {
        this.m_ignoreInheritance = this.m_descriptor.hasInheritance();
        this.m_ignoreTables = this.m_descriptor.getTableNames().size() > 0;
        this.m_ignoreIDs = this.m_descriptor.getPrimaryKeyFieldNames().size() > 0;
    }

    public void setInheritanceStrategy(String inheritanceStrategy) {
        if (inheritanceStrategy.equals("TABLE_PER_CLASS")) {
            this.getValidator().throwTablePerClassInheritanceNotSupported(this.getJavaClass());
        } else if (inheritanceStrategy.equals("SINGLE_TABLE")) {
            this.m_descriptor.getInheritancePolicy().setSingleTableStrategy();
        } else {
            this.m_descriptor.getInheritancePolicy().setJoinedStrategy();
        }
    }

    public void setIsCascadePersist(boolean isCascadePersist) {
        this.m_isCascadePersist = isCascadePersist;
    }

    public void setIsEmbeddable() {
        this.m_descriptor.descriptorIsAggregate();
    }

    public void setIsIsolated(boolean isIsolated) {
        this.m_descriptor.setIsIsolated(isIsolated);
    }

    public void setJavaClass(Class javaClass) {
        this.m_javaClass = javaClass;
        this.m_descriptor.setJavaClassName(javaClass.getName());
    }

    protected void setOptimisticLockingPolicy(OptimisticLockingPolicy policy) {
        this.m_descriptor.setOptimisticLockingPolicy(policy);
    }

    public void setParentClass(Class parent) {
        this.m_descriptor.getInheritancePolicy().setParentClassName(parent.getName());
    }

    public void setPKClass(Class pkClass) {
        this.setPKClass(pkClass.getName());
    }

    public void setPKClass(String pkClassName) {
        CMP3Policy policy = new CMP3Policy();
        policy.setPrimaryKeyClassName(pkClassName);
        this.m_descriptor.setCMPPolicy(policy);
    }

    public void setPrimaryTable(DatabaseTable primaryTable) {
        this.addTable(primaryTable);
        this.m_primaryTableName = primaryTable.getQualifiedName();
    }

    public void setSchema(String xmlSchema) {
        this.m_xmlSchema = xmlSchema;
    }

    public void setSequenceNumberField(DatabaseField field) {
        this.m_descriptor.setSequenceNumberField(field);
    }

    public void setSequenceNumberName(String name) {
        this.m_descriptor.setSequenceNumberName(name);
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.m_ignoreAnnotations = ignoreAnnotations;
    }

    public void setSingleTableInheritanceStrategy() {
        this.m_descriptor.getInheritancePolicy().setSingleTableStrategy();
    }

    public boolean ignoreAnnotations() {
        return this.m_ignoreAnnotations;
    }

    public void setUsesPropertyAccess(Boolean usesPropertyAccess) {
        this.m_usesPropertyAccess = usesPropertyAccess;
    }

    public boolean usesJoinedInheritanceStrategy() {
        return this.m_descriptor.getInheritancePolicy().isJoinedStrategy();
    }

    public boolean usesOptimisticLocking() {
        return this.m_descriptor.usesOptimisticLocking();
    }

    public boolean usesPropertyAccess() {
        if (this.m_accessor.isInheritanceSubclass()) {
            return this.m_accessor.getInheritanceParentDescriptor().usesPropertyAccess();
        }
        if (this.m_usesPropertyAccess == null) {
            if (MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getFields(this.getJavaClass())) || this.isXmlFieldAccess()) {
                if (this.isXmlPropertyAccess()) {
                    // empty if block
                }
                this.m_usesPropertyAccess = new Boolean(false);
            } else if (MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getDeclaredMethods(this.getJavaClass())) || this.isXmlPropertyAccess()) {
                if (this.isXmlFieldAccess()) {
                    // empty if block
                }
                this.m_usesPropertyAccess = new Boolean(true);
            } else {
                for (ClassAccessor mappedSuperclass : this.getClassAccessor().getMappedSuperclasses()) {
                    if (MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getFields(mappedSuperclass.getJavaClass()))) {
                        this.m_usesPropertyAccess = new Boolean(false);
                        break;
                    }
                    if (!MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getDeclaredMethods(mappedSuperclass.getJavaClass()))) continue;
                    this.m_usesPropertyAccess = new Boolean(true);
                    break;
                }
                if (this.m_usesPropertyAccess == null) {
                    this.m_usesPropertyAccess = new Boolean(true);
                }
            }
        }
        return this.m_usesPropertyAccess;
    }

    public boolean usesSingleTableInheritanceStrategy() {
        return !this.usesJoinedInheritanceStrategy();
    }

    public void useTimestampLockingPolicy(DatabaseField field) {
        this.useVersionLockingPolicy(new TimestampLockingPolicy(field));
    }

    public void useVersionLockingPolicy(DatabaseField field) {
        this.useVersionLockingPolicy(new VersionLockingPolicy(field));
    }

    protected void useVersionLockingPolicy(VersionLockingPolicy policy) {
        policy.storeInObject();
        this.setOptimisticLockingPolicy(policy);
    }

    public void validatePKClassId(String attributeName, Type type) {
        if (this.m_pkClassIDs.containsKey(attributeName)) {
            Type expectedType = this.m_pkClassIDs.get(attributeName);
            if (type == expectedType) {
                this.m_pkClassIDs.remove(attributeName);
            } else {
                this.getValidator().throwInvalidCompositePKAttribute(this.getJavaClass(), this.getPKClassName(), attributeName, expectedType, type);
            }
        }
    }
}

