/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.indirection;

import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.ObjectReferenceMapping;

public class UnitOfWorkQueryValueHolder
extends UnitOfWorkValueHolder {
    protected UnitOfWorkQueryValueHolder(ValueHolderInterface attributeValue, Object clone, DatabaseMapping mapping, UnitOfWorkImpl unitOfWork) {
        super(attributeValue, clone, mapping, unitOfWork);
    }

    public UnitOfWorkQueryValueHolder(ValueHolderInterface attributeValue, Object clone, ForeignReferenceMapping mapping, AbstractRecord row, UnitOfWorkImpl unitOfWork) {
        this(attributeValue, clone, mapping, unitOfWork);
        this.row = row;
    }

    protected Object buildBackupCloneFor(Object cloneAttributeValue) {
        return this.getMapping().buildBackupCloneForPartObject(cloneAttributeValue, null, null, this.getUnitOfWork());
    }

    public Object buildCloneFor(Object originalAttributeValue) {
        return this.getMapping().buildCloneForPartObject(originalAttributeValue, null, this.relationshipSourceObject, this.getUnitOfWork(), true);
    }

    public void setValue(Object theValue) {
        if (!this.isInstantiated()) {
            this.instantiate();
        }
        Object oldValue = this.getValue();
        super.setValue(theValue);
        this.updateForeignReferenceSet(theValue, oldValue);
    }

    public void updateForeignReferenceRemove(Object value) {
        DatabaseMapping sourceMapping = this.getMapping();
        if (sourceMapping == null) {
            return;
        }
        if (sourceMapping.isPrivateOwned()) {
            return;
        }
        ForeignReferenceMapping partner = this.getRelationshipPartnerFor(value);
        if (partner != null && value != null) {
            Object unwrappedValue = partner.getDescriptor().getObjectBuilder().unwrapObject(value, this.getSession());
            Object oldParent = partner.getRealAttributeValueFromObject(unwrappedValue, this.getSession());
            Object sourceObject = this.getRelationshipSourceObject();
            if (oldParent == null || partner.isCollectionMapping() && !partner.getContainerPolicy().contains(sourceObject, oldParent, this.getSession())) {
                return;
            }
            if (partner.isObjectReferenceMapping()) {
                partner.setRealAttributeValueInObject(unwrappedValue, null);
            } else if (partner.isCollectionMapping()) {
                partner.getContainerPolicy().removeFrom(sourceObject, oldParent, this.getSession());
            }
        }
    }

    public void updateForeignReferenceSet(Object value, Object oldValue) {
        if (value != null && ClassConstants.Collection_Class.isAssignableFrom(value.getClass())) {
            return;
        }
        if (this.getMapping() == null) {
            return;
        }
        ForeignReferenceMapping partner = this.getRelationshipPartnerFor(value);
        if (partner != null) {
            if (value != null) {
                Object unwrappedValue = partner.getDescriptor().getObjectBuilder().unwrapObject(value, this.getSession());
                Object oldParent = partner.getRealAttributeValueFromObject(unwrappedValue, this.getSession());
                Object sourceObject = this.getRelationshipSourceObject();
                Object wrappedSource = this.getMapping().getDescriptor().getObjectBuilder().wrapObject(sourceObject, this.getSession());
                if (oldParent == sourceObject || partner.isCollectionMapping() && partner.getContainerPolicy().contains(sourceObject, oldParent, this.getSession())) {
                    return;
                }
                if (oldParent != null) {
                    if (this.getMapping().isObjectReferenceMapping()) {
                        if (!partner.isCollectionMapping()) {
                            ((ObjectReferenceMapping)this.getMapping()).setRealAttributeValueInObject(oldParent, null);
                        }
                    } else if (this.getMapping().isCollectionMapping() && !partner.isManyToManyMapping()) {
                        this.getMapping().getContainerPolicy().removeFrom(unwrappedValue, this.getMapping().getRealAttributeValueFromObject(oldParent, this.getSession()), this.getSession());
                    }
                }
                if (oldValue != null) {
                    Object unwrappedOldValue = partner.getDescriptor().getObjectBuilder().unwrapObject(oldValue, this.getSession());
                    if (partner.isObjectReferenceMapping()) {
                        partner.setRealAttributeValueInObject(unwrappedOldValue, null);
                    } else if (partner.isCollectionMapping()) {
                        partner.getContainerPolicy().removeFrom(sourceObject, partner.getRealAttributeValueFromObject(unwrappedOldValue, this.getSession()), this.getSession());
                    }
                }
                if (partner.isObjectReferenceMapping()) {
                    partner.setRealAttributeValueInObject(unwrappedValue, wrappedSource);
                } else if (partner.isCollectionMapping()) {
                    partner.getContainerPolicy().addInto(wrappedSource, oldParent, this.getSession());
                }
            } else {
                this.updateForeignReferenceRemove(oldValue);
            }
        }
    }

    private ForeignReferenceMapping getRelationshipPartnerFor(Object partnerObject) {
        ForeignReferenceMapping partner = (ForeignReferenceMapping)this.getMapping().getRelationshipPartner();
        if (partner == null || partnerObject == null) {
            return partner;
        }
        if (partner.getDescriptor().hasInheritance()) {
            ClassDescriptor partnerObjectDescriptor = this.getSession().getDescriptor(partnerObject);
            if (!partner.getDescriptor().getJavaClass().isAssignableFrom(partnerObjectDescriptor.getJavaClass())) {
                return (ForeignReferenceMapping)partnerObjectDescriptor.getMappingForAttributeName(partner.getAttributeName());
            }
        }
        return partner;
    }
}

