/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.helper;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.internal.helper.ConcurrencyManager;
import oracle.toplink.essentials.internal.helper.TopLinkIdentityHashMap;
import oracle.toplink.essentials.internal.helper.linkedlist.ExposedNodeLinkedList;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;

public class WriteLockManager {
    protected ExposedNodeLinkedList prevailingQueue = new ExposedNodeLinkedList();
    public static int MAXTRIES = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map acquireLocksForClone(Object objectForClone, ClassDescriptor descriptor, Vector primaryKeys, AbstractSession session) {
        boolean successful = false;
        TopLinkIdentityHashMap lockedObjects = new TopLinkIdentityHashMap();
        try {
            CacheKey toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, primaryKeys, descriptor, session);
            int tries = 0;
            while (toWaitOn != null) {
                Iterator lockedList = lockedObjects.values().iterator();
                while (lockedList.hasNext()) {
                    ((CacheKey)lockedList.next()).releaseReadLock();
                    lockedList.remove();
                }
                ConcurrencyManager concurrencyManager = toWaitOn.getMutex();
                synchronized (concurrencyManager) {
                    try {
                        if (toWaitOn.isAcquired()) {
                            toWaitOn.getMutex().wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, primaryKeys, descriptor, session);
                if (toWaitOn == null || ++tries <= MAXTRIES) continue;
                throw ConcurrencyException.maxTriesLockOnCloneExceded(objectForClone);
            }
            successful = true;
        }
        finally {
            if (!successful) {
                Iterator lockedList = lockedObjects.values().iterator();
                while (lockedList.hasNext()) {
                    ((CacheKey)lockedList.next()).releaseReadLock();
                    lockedList.remove();
                }
            }
        }
        return lockedObjects;
    }

    public CacheKey acquireLockAndRelatedLocks(Object objectForClone, Map lockedObjects, Vector primaryKeys, ClassDescriptor descriptor, AbstractSession session) {
        CacheKey lockedCacheKey = session.getIdentityMapAccessorInstance().acquireReadLockOnCacheKeyNoWait(primaryKeys, descriptor.getJavaClass(), descriptor);
        if (lockedCacheKey != null) {
            if (lockedCacheKey.getObject() == null) {
                lockedObjects.put(objectForClone, lockedCacheKey);
            } else {
                objectForClone = lockedCacheKey.getObject();
                if (lockedObjects.containsKey(objectForClone)) {
                    lockedCacheKey.releaseReadLock();
                    return null;
                }
                lockedObjects.put(objectForClone, lockedCacheKey);
            }
            return this.traverseRelatedLocks(objectForClone, lockedObjects, descriptor, session);
        }
        return session.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKeys, descriptor.getJavaClass(), descriptor);
    }

    public CacheKey traverseRelatedLocks(Object objectForClone, Map lockedObjects, ClassDescriptor descriptor, AbstractSession session) {
        if (descriptor.shouldAcquireCascadedLocks()) {
            for (DatabaseMapping mapping : descriptor.getLockableMappings()) {
                CacheKey toWaitOn;
                Object objectToLock = mapping.getAttributeValueFromObject(objectForClone);
                if (mapping.isCollectionMapping()) {
                    ContainerPolicy cp = mapping.getContainerPolicy();
                    Object iterator = cp.iteratorFor(objectToLock);
                    while (cp.hasNext(iterator)) {
                        CacheKey toWaitOn2;
                        Object object = cp.next(iterator, session);
                        if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                            object = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object, session);
                        }
                        if ((toWaitOn2 = this.checkAndLockObject(object, lockedObjects, mapping, session)) == null) continue;
                        return toWaitOn2;
                    }
                    continue;
                }
                if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                    objectToLock = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(objectToLock, session);
                }
                if ((toWaitOn = this.checkAndLockObject(objectToLock, lockedObjects, mapping, session)) == null) continue;
                return toWaitOn;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRequiredLocks(MergeManager mergeManager, UnitOfWorkChangeSet changeSet) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        boolean locksToAcquire = true;
        boolean isForDistributedMerge = false;
        try {
            AbstractSession session = mergeManager.getSession();
            if (session.isUnitOfWork()) {
                session = ((UnitOfWorkImpl)session).getParent();
            } else {
                isForDistributedMerge = true;
            }
            block10: while (locksToAcquire) {
                locksToAcquire = false;
                for (String objectClassName : changeSet.getObjectChanges().keySet()) {
                    Hashtable changeSetTable = (Hashtable)changeSet.getObjectChanges().get(objectClassName);
                    Iterator changeSetIterator = changeSetTable.keySet().iterator();
                    Class objectClass = null;
                    while (changeSetIterator.hasNext()) {
                        ObjectChangeSet objectChangeSet = (ObjectChangeSet)changeSetIterator.next();
                        if (objectChangeSet.getCacheKey() == null) continue;
                        if (objectClass == null) {
                            objectClass = objectChangeSet.getClassType(session);
                        }
                        ClassDescriptor descriptor = session.getDescriptor(objectClass);
                        CacheKey activeCacheKey = this.attemptToAcquireLock(objectClass, objectChangeSet.getCacheKey(), session);
                        if (activeCacheKey == null) {
                            if (this.prevailingQueue.getFirst() == mergeManager) {
                                activeCacheKey = this.waitOnObjectLock(objectClass, objectChangeSet.getCacheKey(), session);
                                mergeManager.getAcquiredLocks().add(activeCacheKey);
                                continue;
                            }
                            this.releaseAllAcquiredLocks(mergeManager);
                            activeCacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(objectChangeSet.getCacheKey().getKey(), objectClass, descriptor);
                            Object[] params = new Object[]{activeCacheKey.getObject(), Thread.currentThread().getName()};
                            session.log(2, "cache", "dead_lock_encountered_on_write", params, null, true);
                            if (mergeManager.getWriteLockQueued() == null) {
                                mergeManager.setQueueNode(this.prevailingQueue.addLast(mergeManager));
                            }
                            mergeManager.setWriteLockQueued(objectChangeSet.getCacheKey());
                            try {
                                ConcurrencyManager concurrencyManager = activeCacheKey.getMutex();
                                synchronized (concurrencyManager) {
                                    if (activeCacheKey.getMutex().isAcquired() && activeCacheKey.getMutex().getActiveThread() != Thread.currentThread()) {
                                        activeCacheKey.getMutex().wait();
                                    }
                                }
                            }
                            catch (InterruptedException exception) {
                                throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                            }
                            locksToAcquire = true;
                            break;
                        }
                        mergeManager.getAcquiredLocks().add(activeCacheKey);
                    }
                    if (!locksToAcquire) continue;
                    continue block10;
                }
            }
        }
        catch (RuntimeException exception) {
            this.releaseAllAcquiredLocks(mergeManager);
            throw exception;
        }
        finally {
            if (mergeManager.getWriteLockQueued() != null) {
                this.prevailingQueue.remove(mergeManager.getQueueNode());
                mergeManager.setWriteLockQueued(null);
            }
        }
    }

    public Object appendLock(Vector primaryKeys, Object objectToLock, ClassDescriptor descriptor, MergeManager mergeManager, AbstractSession session) {
        for (int tries = 0; tries < 1000; ++tries) {
            CacheKey lockedCacheKey = session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKeys, descriptor.getJavaClass(), true, descriptor);
            if (lockedCacheKey == null) {
                lockedCacheKey = session.getIdentityMapAccessorInstance().acquireReadLockOnCacheKey(primaryKeys, descriptor.getJavaClass(), descriptor);
                Object cachedObject = lockedCacheKey.getObject();
                lockedCacheKey.releaseReadLock();
                if (cachedObject != null) {
                    return cachedObject;
                }
            } else {
                if (lockedCacheKey.getObject() == null) {
                    lockedCacheKey.setObject(objectToLock);
                }
                mergeManager.getAcquiredLocks().add(lockedCacheKey);
                return objectToLock;
            }
            session.getSessionLog().log(1, "cache", "Found null object in identity map on appendLock, retrying");
        }
        throw ConcurrencyException.maxTriesLockOnMergeExceded(objectToLock);
    }

    protected CacheKey attemptToAcquireLock(Class objectClass, CacheKey cacheKey, AbstractSession session) {
        return session.getIdentityMapAccessorInstance().acquireLockNoWait(cacheKey.getKey(), objectClass, true, session.getDescriptor(objectClass));
    }

    protected CacheKey checkAndLockObject(Object objectToLock, Map lockedObjects, DatabaseMapping mapping, AbstractSession session) {
        if (objectToLock != null && !lockedObjects.containsKey(objectToLock)) {
            Vector primaryKeysToLock = null;
            ClassDescriptor referenceDescriptor = null;
            referenceDescriptor = mapping.getReferenceDescriptor().hasInheritance() ? session.getDescriptor(objectToLock) : mapping.getReferenceDescriptor();
            if (referenceDescriptor.isAggregateDescriptor() || referenceDescriptor.isAggregateCollectionDescriptor()) {
                this.traverseRelatedLocks(objectToLock, lockedObjects, referenceDescriptor, session);
            } else {
                primaryKeysToLock = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToLock, session);
                CacheKey toWaitOn = this.acquireLockAndRelatedLocks(objectToLock, lockedObjects, primaryKeysToLock, referenceDescriptor, session);
                if (toWaitOn != null) {
                    return toWaitOn;
                }
            }
        }
        return null;
    }

    public void releaseAllAcquiredLocks(MergeManager mergeManager) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        Iterator locks = mergeManager.getAcquiredLocks().iterator();
        while (locks.hasNext()) {
            CacheKey cacheKeyToRemove = (CacheKey)locks.next();
            if (cacheKeyToRemove.getObject() == null && cacheKeyToRemove.getOwningMap() != null) {
                cacheKeyToRemove.getOwningMap().remove(cacheKeyToRemove);
            }
            cacheKeyToRemove.release();
            locks.remove();
        }
    }

    protected CacheKey waitOnObjectLock(Class objectClass, CacheKey cacheKey, AbstractSession session) {
        return session.getIdentityMapAccessorInstance().acquireLock(cacheKey.getKey(), objectClass, true, session.getDescriptor(objectClass));
    }
}

