/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.helper;

import java.io.Serializable;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.helper.DatabaseTable;

public class DatabaseField
implements Cloneable,
Serializable {
    protected int scale;
    protected int length;
    protected int precision;
    protected boolean isUnique;
    protected boolean isNullable;
    protected boolean isUpdatable;
    protected boolean isInsertable;
    protected String columnDefinition;
    protected String name;
    protected DatabaseTable table;
    public transient Class type;
    public int sqlType = -1;
    protected int index = -1;

    public DatabaseField() {
        this("", new DatabaseTable());
    }

    public DatabaseField(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        if (index == -1) {
            this.name = qualifiedName;
            this.table = new DatabaseTable();
        } else {
            this.name = qualifiedName.substring(index + 1, qualifiedName.length());
            this.table = new DatabaseTable(qualifiedName.substring(0, index));
        }
        this.initDDLFields();
    }

    public DatabaseField(String fieldName, String tableName) {
        this(fieldName, new DatabaseTable(tableName));
    }

    public DatabaseField(String fieldName, DatabaseTable databaseTable) {
        this.name = fieldName;
        this.table = databaseTable;
        this.initDDLFields();
    }

    public void initDDLFields() {
        this.scale = 0;
        this.length = 255;
        this.precision = 0;
        this.isUnique = false;
        this.isNullable = true;
        this.isUpdatable = true;
        this.isInsertable = true;
        this.columnDefinition = "";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(DatabaseField field) {
        if (this == field) {
            return true;
        }
        if (field != null) {
            if (DatabasePlatform.shouldIgnoreCaseOnFieldComparisons()) {
                if (this.getName().equalsIgnoreCase(field.getName())) {
                    if (this.getTableName().length() == 0 || field.getTableName().length() == 0) {
                        return true;
                    }
                    return this.getTable().equals(field.getTable());
                }
            } else if (this.getName().equals(field.getName())) {
                if (this.getTableName().length() == 0 || field.getTableName().length() == 0) {
                    return true;
                }
                return this.getTable().equals(field.getTable());
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatabaseField)) {
            return false;
        }
        return this.equals((DatabaseField)object);
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getQualifiedName() {
        if (this.hasTableName()) {
            return this.getTable().getQualifiedName() + "." + this.getName();
        }
        return this.getName();
    }

    public int getScale() {
        return this.scale;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public Class getType() {
        return this.type;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean hasTableName() {
        if (this.getTable() == null) {
            return false;
        }
        if (this.getTable().getName() == null) {
            return false;
        }
        return !this.getTable().getName().equals("");
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isReadOnly() {
        return !this.isUpdatable && !this.isInsertable;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public void resetQualifiedName(String qualifiedName) {
        this.setIndex(-1);
        int index = qualifiedName.lastIndexOf(46);
        if (index == -1) {
            this.setName(qualifiedName);
            this.getTable().setName("");
            this.getTable().setTableQualifier("");
        } else {
            this.setName(qualifiedName.substring(index + 1, qualifiedName.length()));
            this.getTable().setPossiblyQualifiedName(qualifiedName.substring(0, index));
        }
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setInsertable(boolean isInsertable) {
        this.isInsertable = isInsertable;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
    }

    public void setTableName(String tableName) {
        this.setTable(new DatabaseTable(tableName));
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public void setUpdatable(boolean isUpdatable) {
        this.isUpdatable = isUpdatable;
    }

    public String toString() {
        return this.getQualifiedName();
    }
}

