/*
 * Decompiled with CFR 0.152.
 */
package persistence.antlr.debug;

import persistence.antlr.CharScanner;
import persistence.antlr.CharStreamException;
import persistence.antlr.InputBuffer;
import persistence.antlr.LexerSharedInputState;
import persistence.antlr.MismatchedCharException;
import persistence.antlr.Token;
import persistence.antlr.collections.impl.BitSet;
import persistence.antlr.debug.DebuggingParser;
import persistence.antlr.debug.MessageListener;
import persistence.antlr.debug.NewLineListener;
import persistence.antlr.debug.ParserEventSupport;
import persistence.antlr.debug.ParserListener;
import persistence.antlr.debug.ParserMatchListener;
import persistence.antlr.debug.ParserTokenListener;
import persistence.antlr.debug.SemanticPredicateListener;
import persistence.antlr.debug.SyntacticPredicateListener;
import persistence.antlr.debug.TraceListener;

public abstract class DebuggingCharScanner
extends CharScanner
implements DebuggingParser {
    private ParserEventSupport parserEventSupport = new ParserEventSupport(this);
    private boolean _notDebugMode = false;
    protected String[] ruleNames;
    protected String[] semPredNames;

    public DebuggingCharScanner(InputBuffer cb) {
        super(cb);
    }

    public DebuggingCharScanner(LexerSharedInputState state) {
        super(state);
    }

    public void addMessageListener(MessageListener l) {
        this.parserEventSupport.addMessageListener(l);
    }

    public void addNewLineListener(NewLineListener l) {
        this.parserEventSupport.addNewLineListener(l);
    }

    public void addParserListener(ParserListener l) {
        this.parserEventSupport.addParserListener(l);
    }

    public void addParserMatchListener(ParserMatchListener l) {
        this.parserEventSupport.addParserMatchListener(l);
    }

    public void addParserTokenListener(ParserTokenListener l) {
        this.parserEventSupport.addParserTokenListener(l);
    }

    public void addSemanticPredicateListener(SemanticPredicateListener l) {
        this.parserEventSupport.addSemanticPredicateListener(l);
    }

    public void addSyntacticPredicateListener(SyntacticPredicateListener l) {
        this.parserEventSupport.addSyntacticPredicateListener(l);
    }

    public void addTraceListener(TraceListener l) {
        this.parserEventSupport.addTraceListener(l);
    }

    public void consume() throws CharStreamException {
        int la_1 = -99;
        try {
            la_1 = this.LA(1);
        }
        catch (CharStreamException charStreamException) {
            // empty catch block
        }
        super.consume();
        this.parserEventSupport.fireConsume(la_1);
    }

    protected void fireEnterRule(int num, int data) {
        if (this.isDebugMode()) {
            this.parserEventSupport.fireEnterRule(num, this.inputState.guessing, data);
        }
    }

    protected void fireExitRule(int num, int ttype) {
        if (this.isDebugMode()) {
            this.parserEventSupport.fireExitRule(num, this.inputState.guessing, ttype);
        }
    }

    protected boolean fireSemanticPredicateEvaluated(int type, int num, boolean condition) {
        if (this.isDebugMode()) {
            return this.parserEventSupport.fireSemanticPredicateEvaluated(type, num, condition, this.inputState.guessing);
        }
        return condition;
    }

    protected void fireSyntacticPredicateFailed() {
        if (this.isDebugMode()) {
            this.parserEventSupport.fireSyntacticPredicateFailed(this.inputState.guessing);
        }
    }

    protected void fireSyntacticPredicateStarted() {
        if (this.isDebugMode()) {
            this.parserEventSupport.fireSyntacticPredicateStarted(this.inputState.guessing);
        }
    }

    protected void fireSyntacticPredicateSucceeded() {
        if (this.isDebugMode()) {
            this.parserEventSupport.fireSyntacticPredicateSucceeded(this.inputState.guessing);
        }
    }

    public String getRuleName(int num) {
        return this.ruleNames[num];
    }

    public String getSemPredName(int num) {
        return this.semPredNames[num];
    }

    public synchronized void goToSleep() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isDebugMode() {
        return !this._notDebugMode;
    }

    public char LA(int i) throws CharStreamException {
        char la = super.LA(i);
        this.parserEventSupport.fireLA(i, la);
        return la;
    }

    protected Token makeToken(int t) {
        return super.makeToken(t);
    }

    public void match(char c) throws MismatchedCharException, CharStreamException {
        char la_1 = this.LA(1);
        try {
            super.match(c);
            this.parserEventSupport.fireMatch(c, this.inputState.guessing);
        }
        catch (MismatchedCharException e) {
            if (this.inputState.guessing == 0) {
                this.parserEventSupport.fireMismatch(la_1, c, this.inputState.guessing);
            }
            throw e;
        }
    }

    public void match(BitSet b) throws MismatchedCharException, CharStreamException {
        String text = this.text.toString();
        char la_1 = this.LA(1);
        try {
            super.match(b);
            this.parserEventSupport.fireMatch(la_1, b, text, this.inputState.guessing);
        }
        catch (MismatchedCharException e) {
            if (this.inputState.guessing == 0) {
                this.parserEventSupport.fireMismatch((int)la_1, b, text, this.inputState.guessing);
            }
            throw e;
        }
    }

    public void match(String s) throws MismatchedCharException, CharStreamException {
        StringBuffer la_s = new StringBuffer("");
        int len = s.length();
        try {
            for (int i = 1; i <= len; ++i) {
                la_s.append(super.LA(i));
            }
        }
        catch (Exception ignoreMe) {
            // empty catch block
        }
        try {
            super.match(s);
            this.parserEventSupport.fireMatch(s, this.inputState.guessing);
        }
        catch (MismatchedCharException e) {
            if (this.inputState.guessing == 0) {
                this.parserEventSupport.fireMismatch(la_s.toString(), s, this.inputState.guessing);
            }
            throw e;
        }
    }

    public void matchNot(char c) throws MismatchedCharException, CharStreamException {
        char la_1 = this.LA(1);
        try {
            super.matchNot(c);
            this.parserEventSupport.fireMatchNot(la_1, c, this.inputState.guessing);
        }
        catch (MismatchedCharException e) {
            if (this.inputState.guessing == 0) {
                this.parserEventSupport.fireMismatchNot(la_1, c, this.inputState.guessing);
            }
            throw e;
        }
    }

    public void matchRange(char c1, char c2) throws MismatchedCharException, CharStreamException {
        char la_1 = this.LA(1);
        try {
            super.matchRange(c1, c2);
            this.parserEventSupport.fireMatch(la_1, "" + c1 + c2, this.inputState.guessing);
        }
        catch (MismatchedCharException e) {
            if (this.inputState.guessing == 0) {
                this.parserEventSupport.fireMismatch(la_1, "" + c1 + c2, this.inputState.guessing);
            }
            throw e;
        }
    }

    public void newline() {
        super.newline();
        this.parserEventSupport.fireNewLine(this.getLine());
    }

    public void removeMessageListener(MessageListener l) {
        this.parserEventSupport.removeMessageListener(l);
    }

    public void removeNewLineListener(NewLineListener l) {
        this.parserEventSupport.removeNewLineListener(l);
    }

    public void removeParserListener(ParserListener l) {
        this.parserEventSupport.removeParserListener(l);
    }

    public void removeParserMatchListener(ParserMatchListener l) {
        this.parserEventSupport.removeParserMatchListener(l);
    }

    public void removeParserTokenListener(ParserTokenListener l) {
        this.parserEventSupport.removeParserTokenListener(l);
    }

    public void removeSemanticPredicateListener(SemanticPredicateListener l) {
        this.parserEventSupport.removeSemanticPredicateListener(l);
    }

    public void removeSyntacticPredicateListener(SyntacticPredicateListener l) {
        this.parserEventSupport.removeSyntacticPredicateListener(l);
    }

    public void removeTraceListener(TraceListener l) {
        this.parserEventSupport.removeTraceListener(l);
    }

    public void reportError(MismatchedCharException e) {
        this.parserEventSupport.fireReportError(e);
        super.reportError(e);
    }

    public void reportError(String s) {
        this.parserEventSupport.fireReportError(s);
        super.reportError(s);
    }

    public void reportWarning(String s) {
        this.parserEventSupport.fireReportWarning(s);
        super.reportWarning(s);
    }

    public void setDebugMode(boolean value) {
        this._notDebugMode = !value;
    }

    public void setupDebugging() {
    }

    public synchronized void wakeUp() {
        this.notify();
    }
}

