/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.sql.Blob;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Version;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.DirectAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataGeneratedValue;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.converters.Converter;

public class BasicAccessor
extends DirectAccessor {
    private Basic m_basic = (Basic)this.getAnnotation(Basic.class);

    public BasicAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    protected MetadataColumn getColumn(String loggingCtx) {
        Column column = (Column)this.getAnnotation(Column.class);
        return new MetadataColumn(column, this);
    }

    public String getFetchType() {
        return this.m_basic == null ? "EAGER" : this.m_basic.fetch().name();
    }

    public boolean isBasic() {
        return true;
    }

    public boolean isId() {
        return this.isAnnotationPresent(Id.class);
    }

    public boolean isOptional() {
        return this.m_basic == null ? true : this.m_basic.optional();
    }

    public boolean isVersion() {
        return this.isAnnotationPresent(Version.class);
    }

    public void process() {
        DatabaseField field = this.getDatabaseField("metadata_default_column");
        if (field.getTableName().equals("")) {
            field.setTableName(this.m_descriptor.getPrimaryTableName());
        }
        if (this.isVersion()) {
            if (this.m_descriptor.usesOptimisticLocking()) {
                this.m_logger.logWarningMessage("metadata_warning_ignore_version_locking", this);
            } else {
                this.processVersion(field);
            }
        } else if (this.isId()) {
            this.processId(field);
        }
        if (this.m_descriptor.hasMappingForAttributeName(this.getAttributeName())) {
            this.m_logger.logWarningMessage("metadata_warning_ignore_mapping", this);
        } else {
            this.processDirectToFieldMapping(field);
        }
    }

    protected void processDirectToFieldMapping(DatabaseField field) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setField(field);
        mapping.setIsReadOnly(field.isReadOnly());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        if (this.usesIndirection()) {
            this.m_logger.logWarningMessage("metadata_warning_ignore_basic_fetch_lazy", this);
        }
        this.setAccessorMethods(mapping);
        this.processMappingConverter(mapping);
        this.m_descriptor.addMapping(mapping);
    }

    protected void processEnumerated(DatabaseMapping mapping) {
        if (MetadataHelper.isCollectionClass(this.getReferenceClass()) || MetadataHelper.isMapClass(this.getReferenceClass())) {
            this.processSerialized(mapping);
        } else {
            super.processEnumerated(mapping);
        }
    }

    protected void processGeneratedValue(DatabaseField field) {
        GeneratedValue generatedValue = (GeneratedValue)this.getAnnotation(GeneratedValue.class);
        if (generatedValue != null) {
            this.processGeneratedValue(new MetadataGeneratedValue(generatedValue), field);
        }
    }

    protected void processGeneratedValue(MetadataGeneratedValue generatedValue, DatabaseField sequenceNumberField) {
        DatabaseField existingSequenceNumberField = this.m_descriptor.getSequenceNumberField();
        if (existingSequenceNumberField == null) {
            this.m_descriptor.setSequenceNumberField(sequenceNumberField);
            this.getProject().addGeneratedValue(generatedValue, this.getJavaClass());
        } else {
            this.m_validator.throwOnlyOneGeneratedValueIsAllowed(this.getJavaClass(), existingSequenceNumberField.getQualifiedName(), sequenceNumberField.getQualifiedName());
        }
    }

    protected void processId(DatabaseField field) {
        if (this.m_descriptor.ignoreIDs()) {
            this.m_logger.logWarningMessage("metadata_warning_ignore_primary_key", this);
        } else {
            String attributeName = this.getAttributeName();
            if (this.m_descriptor.hasEmbeddedIdAttribute()) {
                this.m_validator.throwEmbeddedIdAndIdFound(this.getJavaClass(), this.m_descriptor.getEmbeddedIdAttributeName(), attributeName);
            }
            this.m_descriptor.validatePKClassId(attributeName, this.getReferenceClass());
            this.m_descriptor.addIdAttributeName(attributeName);
            this.m_descriptor.addPrimaryKeyField(field);
            this.processGeneratedValue(field);
            this.processTableGenerator();
            this.processSequenceGenerator();
        }
    }

    protected void processLob(DatabaseMapping mapping) {
        if (MetadataHelper.isCollectionClass(this.getReferenceClass()) || MetadataHelper.isMapClass(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Blob.class);
            this.processSerialized(mapping);
        } else {
            super.processLob(mapping);
        }
    }

    protected void processVersion(DatabaseField field) {
        Class lockType = this.getRawClass();
        field.setType(lockType);
        if (MetadataHelper.isValidVersionLockingType(lockType)) {
            this.m_descriptor.useVersionLockingPolicy(field);
        } else if (MetadataHelper.isValidTimstampVersionLockingType(lockType)) {
            this.m_descriptor.useTimestampLockingPolicy(field);
        } else {
            this.m_validator.throwInvalidTypeForVersionAttribute(this.getJavaClass(), this.getAttributeName(), lockType);
        }
    }

    public void setConverter(DatabaseMapping mapping, Converter converter) {
        ((DirectToFieldMapping)mapping).setConverter(converter);
    }

    public void setFieldClassification(DatabaseMapping mapping, Class classification) {
        ((DirectToFieldMapping)mapping).setFieldClassification(classification);
    }
}

