/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.exceptions;

import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.i18n.ExceptionMessageGenerator;

public class ConcurrencyException
extends TopLinkException {
    public static final int WAIT_WAS_INTERRUPTED = 2001;
    public static final int WAIT_FAILURE_SERVER = 2002;
    public static final int WAIT_FAILURE_CLIENT = 2003;
    public static final int SIGNAL_ATTEMPTED_BEFORE_WAIT = 2004;
    public static final int WAIT_FAILURE_SEQ_DATABASE_SESSION = 2005;
    public static final int SEQUENCING_MULTITHREAD_THRU_CONNECTION = 2006;
    public static final int MAX_TRIES_EXCEDED_FOR_LOCK_ON_CLONE = 2007;
    public static final int MAX_TRIES_EXCEDED_FOR_LOCK_ON_MERGE = 2008;
    public static final int MAX_TRIES_EXCEDED_FOR_LOCK_ON_BUILD_OBJECT = 2009;

    protected ConcurrencyException(String theMessage) {
        super(theMessage);
    }

    protected ConcurrencyException(String theMessage, Exception exception) {
        super(theMessage, exception);
    }

    public static ConcurrencyException maxTriesLockOnCloneExceded(Object objectToClone) {
        Object[] args = new Object[]{objectToClone, CR};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2007, args));
        concurrencyException.setErrorCode(2007);
        return concurrencyException;
    }

    public static ConcurrencyException maxTriesLockOnMergeExceded(Object objectToClone) {
        Object[] args = new Object[]{objectToClone, CR};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2008, args));
        concurrencyException.setErrorCode(2008);
        return concurrencyException;
    }

    public static ConcurrencyException maxTriesLockOnBuildObjectExceded(Thread cacheKeyThread, Thread currentThread) {
        Object[] args = new Object[]{cacheKeyThread, currentThread, CR};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2008, args));
        concurrencyException.setErrorCode(2009);
        return concurrencyException;
    }

    public static ConcurrencyException signalAttemptedBeforeWait() {
        Object[] args = new Object[]{CR};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2004, args));
        concurrencyException.setErrorCode(2004);
        return concurrencyException;
    }

    public static ConcurrencyException waitFailureOnClientSession(InterruptedException exception) {
        Object[] args = new Object[]{};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2003, args), exception);
        concurrencyException.setErrorCode(2003);
        return concurrencyException;
    }

    public static ConcurrencyException waitFailureOnServerSession(InterruptedException exception) {
        Object[] args = new Object[]{};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2002, args), exception);
        concurrencyException.setErrorCode(2002);
        return concurrencyException;
    }

    public static ConcurrencyException waitWasInterrupted(String message) {
        Object[] args = new Object[]{CR, message};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2001, args));
        concurrencyException.setErrorCode(2001);
        return concurrencyException;
    }

    public static ConcurrencyException waitFailureOnSequencingForDatabaseSession(InterruptedException exception) {
        Object[] args = new Object[]{};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2005, args), exception);
        concurrencyException.setErrorCode(2005);
        return concurrencyException;
    }

    public static ConcurrencyException sequencingMultithreadThruConnection(String accessor) {
        Object[] args = new Object[]{accessor};
        ConcurrencyException concurrencyException = new ConcurrencyException(ExceptionMessageGenerator.buildMessage(ConcurrencyException.class, 2006, args));
        concurrencyException.setErrorCode(2006);
        return concurrencyException;
    }
}

