/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.databaseaccess.Platform;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.expressions.SQLDeleteStatement;
import oracle.toplink.essentials.internal.expressions.SQLInsertStatement;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.expressions.TableExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.DirectCollectionChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.RelationalMapping;
import oracle.toplink.essentials.mappings.converters.Converter;
import oracle.toplink.essentials.mappings.converters.ObjectTypeConverter;
import oracle.toplink.essentials.mappings.converters.TypeConversionConverter;
import oracle.toplink.essentials.queryframework.DataModifyQuery;
import oracle.toplink.essentials.queryframework.DataReadQuery;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.DirectReadQuery;
import oracle.toplink.essentials.queryframework.ModifyQuery;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;
import oracle.toplink.essentials.sessions.ObjectCopyingPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectCollectionMapping
extends CollectionMapping
implements RelationalMapping {
    protected static final String Delete = "delete";
    protected static final String Insert = "insert";
    protected static final String DeleteAll = "deleteAll";
    protected Converter valueConverter;
    protected transient DatabaseTable referenceTable;
    protected transient DatabaseField directField;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Vector<DatabaseField> referenceKeyFields;
    protected transient DataModifyQuery insertQuery = new DataModifyQuery();
    protected transient ModifyQuery changeSetDeleteQuery;
    protected transient boolean hasCustomDeleteQuery;
    protected transient boolean hasCustomInsertQuery;

    public DirectCollectionMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.referenceKeyFields = NonSynchronizedVector.newInstance(1);
        this.selectionQuery = new DirectReadQuery();
        this.hasCustomInsertQuery = false;
        this.isPrivateOwned = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public void addReferenceKeyField(DatabaseField referenceForeignKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceKeyFields().addElement(sourcePrimaryKeyField);
        this.getReferenceKeyFields().addElement(referenceForeignKeyField);
    }

    public void addReferenceKeyFieldName(String referenceForeignKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addReferenceKeyField(new DatabaseField(referenceForeignKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    @Override
    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        Object attributeValue = this.getRealCollectionAttributeValueFromObject(original, policy.getSession());
        attributeValue = this.getContainerPolicy().cloneFor(attributeValue);
        this.setRealAttributeValueInObject(copy, attributeValue);
    }

    @Override
    protected Object buildElementClone(Object element, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        Object cloneValue = element;
        if (this.getValueConverter() != null && this.getValueConverter().isMutable()) {
            cloneValue = this.getValueConverter().convertDataValueToObjectValue(this.getValueConverter().convertObjectValueToDataValue(cloneValue, unitOfWork), unitOfWork);
        }
        return cloneValue;
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
    }

    @Override
    public Object clone() {
        DirectCollectionMapping clone = (DirectCollectionMapping)super.clone();
        clone.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        clone.setReferenceKeyFields(this.cloneFields(this.getReferenceKeyFields()));
        return clone;
    }

    @Override
    public void compareCollectionsForChange(Object oldCollection, Object newCollection, ChangeRecord changeRecord, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        int numberOfNewNulls = 0;
        HashMap<Object, Integer> originalKeyValues = new HashMap<Object, Integer>(10);
        HashMap<Object, Integer> cloneKeyValues = new HashMap<Object, Integer>(10);
        if (oldCollection != null) {
            Object backUpIter = cp.iteratorFor(oldCollection);
            while (cp.hasNext(backUpIter)) {
                Object secondObject = cp.next(backUpIter, session);
                if (secondObject == null) {
                    --numberOfNewNulls;
                    continue;
                }
                Integer count = (Integer)originalKeyValues.get(secondObject);
                if (count == null) {
                    originalKeyValues.put(secondObject, new Integer(1));
                    continue;
                }
                originalKeyValues.put(secondObject, new Integer(count + 1));
            }
        }
        HashMap databaseCount = (HashMap)originalKeyValues.clone();
        int databaseNullCount = Math.abs(numberOfNewNulls);
        if (newCollection != null) {
            Object cloneIter = cp.iteratorFor(newCollection);
            while (cp.hasNext(cloneIter)) {
                Object firstObject = cp.next(cloneIter, session);
                if (firstObject == null) {
                    ++numberOfNewNulls;
                    continue;
                }
                Integer count = (Integer)originalKeyValues.get(firstObject);
                if (count == null) {
                    Integer cloneCount = (Integer)cloneKeyValues.get(firstObject);
                    if (cloneCount == null) {
                        cloneKeyValues.put(firstObject, new Integer(1));
                        continue;
                    }
                    cloneKeyValues.put(firstObject, new Integer(cloneCount + 1));
                    continue;
                }
                if (count == 1) {
                    originalKeyValues.remove(firstObject);
                    continue;
                }
                originalKeyValues.put(firstObject, new Integer(count - 1));
            }
        }
        if (cloneKeyValues.isEmpty() && originalKeyValues.isEmpty() && numberOfNewNulls == 0 && !changeRecord.getOwner().isNew()) {
            return;
        }
        ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(cloneKeyValues, databaseCount);
        ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(originalKeyValues, databaseCount);
        if (numberOfNewNulls != 0) {
            Object changeList = null;
            ((DirectCollectionChangeRecord)changeRecord).getCommitAddMap().put(DirectCollectionChangeRecord.Null, new Integer(databaseNullCount));
            if (numberOfNewNulls > 0) {
                ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(DirectCollectionChangeRecord.Null, new Integer(numberOfNewNulls));
            } else {
                ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(DirectCollectionChangeRecord.Null, new Integer(numberOfNewNulls *= -1));
            }
        }
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        boolean numberOfNewNulls = false;
        ContainerPolicy cp = this.getContainerPolicy();
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Object cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(clone, session);
        Object backUpCollection = null;
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            backUpCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
        }
        DirectCollectionChangeRecord changeRecord = new DirectCollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        this.compareCollectionsForChange(backUpCollection, cloneObjectCollection, changeRecord, session);
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        int count;
        Object object;
        Object firstCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(firstCollection) != containerPolicy.sizeFor(secondCollection)) {
            return false;
        }
        HashMap<Object, Integer> firstCounter = new HashMap<Object, Integer>();
        HashMap<Object, Integer> secondCounter = new HashMap<Object, Integer>();
        Object iter = containerPolicy.iteratorFor(firstCollection);
        while (containerPolicy.hasNext(iter)) {
            object = containerPolicy.next(iter, session);
            if (firstCounter.containsKey(object)) {
                count = (Integer)firstCounter.get(object);
                firstCounter.put(object, new Integer(++count));
                continue;
            }
            firstCounter.put(object, new Integer(1));
        }
        iter = containerPolicy.iteratorFor(secondCollection);
        while (containerPolicy.hasNext(iter)) {
            object = containerPolicy.next(iter, session);
            if (secondCounter.containsKey(object)) {
                count = (Integer)secondCounter.get(object);
                secondCounter.put(object, new Integer(++count));
                continue;
            }
            secondCounter.put(object, new Integer(1));
        }
        Iterator iterator = firstCounter.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!secondCounter.containsKey(object) || ((Integer)secondCounter.get(object)).intValue() != ((Integer)firstCounter.get(object)).intValue()) {
                return false;
            }
            iterator.remove();
            secondCounter.remove(object);
        }
        return firstCounter.isEmpty() && secondCounter.isEmpty();
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.valueConverter != null) {
            if (this.valueConverter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.valueConverter).convertClassNamesToClasses(classLoader);
            } else if (this.valueConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.valueConverter).convertClassNamesToClasses(classLoader);
            }
        }
    }

    protected Vector extractKeyFromReferenceRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getReferenceKeyFields().size());
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField relationField = this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceField = this.getSourceKeyFields().elementAt(index);
            Object value = row.get(relationField);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(sourceField));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldEnum = this.getSourceKeyFields().elements();
        while (fieldEnum.hasMoreElements()) {
            DatabaseField field = fieldEnum.nextElement();
            Object value = row.get(field);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    protected ModifyQuery getDeleteQuery() {
        if (this.changeSetDeleteQuery == null) {
            this.changeSetDeleteQuery = new DataModifyQuery();
        }
        return this.changeSetDeleteQuery;
    }

    public DatabaseField getDirectField() {
        return this.directField;
    }

    public String getDirectFieldName() {
        if (this.getDirectField() == null) {
            return null;
        }
        return this.getDirectField().getQualifiedName();
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    @Override
    public Class getReferenceClass() {
        return null;
    }

    @Override
    public String getReferenceClassName() {
        return null;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    public Vector getReferenceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getReferenceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getReferenceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getReferenceKeyFields() {
        return this.referenceKeyFields;
    }

    public DatabaseTable getReferenceTable() {
        return this.referenceTable;
    }

    public String getReferenceTableName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getName();
    }

    public String getReferenceTableQualifiedName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getQualifiedName();
    }

    @Override
    public DatabaseMapping getRelationshipPartner() {
        return null;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.isKeyForSourceSpecified()) {
            this.initializeSourceKeys(session);
        } else {
            this.initializeSourceKeysWithDefaults(session);
        }
        this.initializeReferenceTable(session);
        this.initializeReferenceKeys(session);
        this.initializeDirectField(session);
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
            this.initializeSelectionStatement(session);
        }
        if (!this.getSelectionQuery().hasSessionName()) {
            this.getSelectionQuery().setSessionName(session.getName());
        }
        if (this.getValueConverter() != null && this.getSelectionQuery() instanceof DirectReadQuery) {
            ((DirectReadQuery)this.getSelectionQuery()).setValueConverter(this.getValueConverter());
        }
        this.initializeDeleteAllQuery(session);
        this.initializeDeleteQuery(session);
        this.initializeInsertQuery(session);
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
        super.initialize(session);
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = expression == null ? subExpression : expression.and(subExpression);
        }
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteAllQuery().setSQLStatement(statement);
    }

    protected void initializeDeleteQuery(AbstractSession session) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression directExp = ((Expression)builder).getField(this.getDirectField()).equal(builder.getParameter(this.getDirectField()));
        Expression expression = null;
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = subExpression.and(expression);
        }
        expression = expression.and(directExp);
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeDirectField(AbstractSession session) throws DescriptorException {
        if (this.getDirectField() == null) {
            throw DescriptorException.directFieldNameNotSet(this);
        }
        this.getDirectField().setTable(this.getReferenceTable());
        this.getDirectField().setIndex(0);
    }

    protected void initializeInsertQuery(AbstractSession session) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement statement = new SQLInsertStatement();
        statement.setTable(this.getReferenceTable());
        DatabaseRecord directRow = new DatabaseRecord();
        Enumeration<DatabaseField> referenceEnum = this.getReferenceKeyFields().elements();
        while (referenceEnum.hasMoreElements()) {
            directRow.put(referenceEnum.nextElement(), (Object)null);
        }
        directRow.put(this.getDirectField(), (Object)null);
        statement.setModifyRow(directRow);
        this.getInsertQuery().setSQLStatement(statement);
        this.getInsertQuery().setModifyRow(directRow);
    }

    @Override
    protected void initializeReferenceDescriptor(AbstractSession session) {
    }

    protected void initializeReferenceKeys(AbstractSession session) throws DescriptorException {
        if (this.getReferenceKeyFields().size() == 0) {
            throw DescriptorException.noReferenceKeyIsSpecified(this);
        }
        Enumeration<DatabaseField> referenceEnum = this.getReferenceKeyFields().elements();
        while (referenceEnum.hasMoreElements()) {
            DatabaseField field = referenceEnum.nextElement();
            if (field.hasTableName() && !field.getTableName().equals(this.getReferenceTable().getName())) {
                throw DescriptorException.referenceKeyFieldNotProperlySpecified(field, this);
            }
            field.setTable(this.getReferenceTable());
        }
    }

    protected void initializeReferenceTable(AbstractSession session) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (this.getReferenceTable() == null) {
            throw DescriptorException.referenceTableNotSpecified(this);
        }
        if (platform.getTableQualifier().length() == 0) {
            return;
        }
        if (this.getReferenceTable().getTableQualifier().length() == 0) {
            this.getReferenceTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        Expression criteria = null;
        ExpressionBuilder base = new ExpressionBuilder();
        TableExpression table = (TableExpression)base.getTable(this.getReferenceTable());
        Enumeration<DatabaseField> referenceKeysEnum = this.getReferenceKeyFields().elements();
        Enumeration<DatabaseField> sourceKeysEnum = this.getSourceKeyFields().elements();
        while (referenceKeysEnum.hasMoreElements()) {
            DatabaseField referenceKey = referenceKeysEnum.nextElement();
            DatabaseField sourceKey = sourceKeysEnum.nextElement();
            Expression exp1 = table.getField(referenceKey);
            Expression exp2 = base.getParameter(sourceKey);
            Expression expression = exp1.equal(exp2);
            if (criteria == null) {
                criteria = expression;
                continue;
            }
            criteria = expression.and(criteria);
        }
        this.setSelectionCriteria(criteria);
    }

    @Override
    protected void initializeSelectionQuery(AbstractSession session) {
    }

    protected void initializeSelectionStatement(AbstractSession session) {
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.getReferenceTable());
        statement.addField((DatabaseField)this.getDirectField().clone());
        statement.setWhereClause(this.getSelectionCriteria());
        statement.normalize(session, null);
        this.getSelectionQuery().setSQLStatement(statement);
    }

    protected void initializeSourceKeys(AbstractSession session) {
        Enumeration<DatabaseField> sourceKeyEnum = this.getSourceKeyFields().elements();
        while (sourceKeyEnum.hasMoreElements()) {
            this.getDescriptor().buildField(sourceKeyEnum.nextElement());
        }
    }

    protected void initializeSourceKeysWithDefaults(AbstractSession session) {
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            this.getSourceKeyFields().addElement(primaryKeyFields.get(index));
        }
    }

    @Override
    public boolean isDirectCollectionMapping() {
        return true;
    }

    protected boolean isKeyForSourceSpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public boolean isPrivateOwned() {
        return true;
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        if (iterator.shouldIterateOnPrimitives()) {
            super.iterateOnRealAttributeValue(iterator, realAttributeValue);
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        iterator.iteratePrimitiveForMapping(element, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfTarget = null;
        AbstractSession session = mergeManager.getSession();
        HashMap addObjects = ((DirectCollectionChangeRecord)changeRecord).getAddObjectMap();
        HashMap removeObjects = ((DirectCollectionChangeRecord)changeRecord).getRemoveObjectMap();
        valueOfTarget = this.isAttributeValueInstantiated(target) && !changeRecord.getOwner().isNew() ? this.getRealCollectionAttributeValueFromObject(target, session) : containerPolicy.containerInstance(addObjects.size());
        if (!this.isAttributeValueInstantiated(target)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object iterator = containerPolicy.iteratorFor(this.getRealCollectionAttributeValueFromObject(source, session));
            while (containerPolicy.hasNext(iterator)) {
                containerPolicy.addInto(containerPolicy.next(iterator, session), valueOfTarget, session);
            }
        } else {
            Object object = valueOfTarget;
            synchronized (object) {
                int i;
                int objectCount;
                for (Object object2 : addObjects.keySet()) {
                    objectCount = (Integer)addObjects.get(object2);
                    for (i = 0; i < objectCount; ++i) {
                        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                            if (containerPolicy.contains(object2, valueOfTarget, session)) continue;
                            containerPolicy.addInto(object2, valueOfTarget, session);
                            continue;
                        }
                        containerPolicy.addInto(object2, valueOfTarget, session);
                    }
                }
                for (Object object2 : removeObjects.keySet()) {
                    objectCount = (Integer)removeObjects.get(object2);
                    for (i = 0; i < objectCount; ++i) {
                        containerPolicy.removeFrom(object2, valueOfTarget, session);
                    }
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
        Object newContainer = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        boolean fireChangeEvents = false;
        valueOfTarget = newContainer;
        Object sourceValuesIterator = containerPolicy.iteratorFor(valueOfSource);
        while (containerPolicy.hasNext(sourceValuesIterator)) {
            Object sourceValue = containerPolicy.next(sourceValuesIterator, mergeManager.getSession());
            containerPolicy.addInto(sourceValue, valueOfTarget, mergeManager.getSession());
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        if (event[0] == Delete) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
        } else if (event[0] == Insert) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
        } else if (event[0] == DeleteAll) {
            this.preDelete((DeleteObjectQuery)event[1]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(event[0], this);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        DatabaseRecord databaseRow = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(objects)) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(referenceKey, sourceKeyValue);
        }
        Object iter = containerPolicy.iteratorFor(objects);
        while (containerPolicy.hasNext(iter)) {
            Object object = containerPolicy.next(iter, query.getSession());
            if (this.getValueConverter() != null) {
                object = this.getValueConverter().convertObjectValueToDataValue(object, query.getSession());
            }
            databaseRow.put(this.getDirectField(), object);
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{Insert, this.getInsertQuery(), databaseRow.clone()};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
                continue;
            }
            query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (writeQuery.getObjectChangeSet() != null) {
            this.postUpdateWithChangeSet(writeQuery);
            return;
        }
        if (!this.isAttributeValueInstantiated(writeQuery.getObject())) {
            return;
        }
        if (writeQuery.getSession().isUnitOfWork() && this.compareObjects(writeQuery.getObject(), writeQuery.getBackupClone(), writeQuery.getSession())) {
            return;
        }
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        deleteQuery.setObject(writeQuery.getObject());
        deleteQuery.setSession(writeQuery.getSession());
        deleteQuery.setTranslationRow(writeQuery.getTranslationRow());
        if (writeQuery.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[3];
            event[0] = DeleteAll;
            event[1] = deleteQuery;
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.preDelete(deleteQuery);
        }
        this.postInsert(writeQuery);
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeQuery) throws DatabaseException {
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        DirectCollectionChangeRecord changeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            return;
        }
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Object sourceKeyValue = writeQuery.getTranslationRow().get(sourceKey);
            writeQuery.getTranslationRow().put(referenceKey, sourceKeyValue);
        }
        for (Object object : changeRecord.getRemoveObjectMap().keySet()) {
            AbstractRecord thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
            Object value = object;
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertObjectValueToDataValue(value, writeQuery.getSession());
            }
            if (value == DirectCollectionChangeRecord.Null) {
                thisRow.add(this.getDirectField(), null);
            } else {
                thisRow.add(this.getDirectField(), value);
            }
            Object[] event = new Object[]{Delete, this.getDeleteQuery(), thisRow};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            Integer count = (Integer)changeRecord.getCommitAddMap().get(object);
            if (count == null) continue;
            for (int counter = count.intValue(); counter > 0; --counter) {
                thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
                thisRow.add(this.getDirectField(), value);
                event = new Object[]{Insert, this.getInsertQuery(), thisRow};
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            }
        }
        for (Object object : changeRecord.getAddObjectMap().keySet()) {
            Integer count = (Integer)changeRecord.getAddObjectMap().get(object);
            for (int counter = count.intValue(); counter > 0; --counter) {
                AbstractRecord thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
                Object value = object;
                if (this.getValueConverter() != null) {
                    value = this.getValueConverter().convertObjectValueToDataValue(value, writeQuery.getSession());
                }
                if (value == DirectCollectionChangeRecord.Null) {
                    thisRow.add(this.getDirectField(), null);
                } else {
                    thisRow.add(this.getDirectField(), value);
                }
                Object[] event = new Object[]{Insert, this.getInsertQuery(), thisRow};
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            }
        }
    }

    @Override
    public void preDelete(WriteObjectQuery query) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        query.getSession().executeQuery((DatabaseQuery)this.getDeleteAllQuery(), query.getTranslationRow());
    }

    @Override
    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, AbstractSession session) {
        Enumeration<DatabaseField> sourceFieldsEnum = this.getSourceKeyFields().elements();
        while (sourceFieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = sourceFieldsEnum.nextElement();
            if (translationRow.containsKey(sourceKey)) continue;
            Object value = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, sourceKey, session);
            translationRow.put(sourceKey, value);
        }
    }

    protected void setDeleteQuery(ModifyQuery query) {
        this.changeSetDeleteQuery = query;
    }

    public void setDeleteSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteQuery(query);
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        ((DataReadQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setCustomDeleteQuery(ModifyQuery query) {
        this.setDeleteQuery(query);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery query) {
        this.setInsertQuery(query);
        this.setHasCustomInsertQuery(true);
    }

    public void setDirectField(DatabaseField field) {
        this.directField = field;
    }

    public void setDirectFieldClassification(Class fieldType) {
        this.getDirectField().setType(fieldType);
    }

    public void setDirectFieldName(String fieldName) {
        this.setDirectField(new DatabaseField(fieldName));
    }

    protected void setHasCustomDeleteQuery(boolean bool) {
        this.hasCustomDeleteQuery = bool;
    }

    protected void setHasCustomInsertQuery(boolean bool) {
        this.hasCustomInsertQuery = bool;
    }

    protected void setInsertQuery(DataModifyQuery insertQuery) {
        this.insertQuery = insertQuery;
    }

    public void setInsertSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomInsertQuery(query);
    }

    @Override
    public void setReferenceClass(Class referenceClass) {
    }

    @Override
    public void setReferenceClassName(String referenceClassName) {
    }

    public void setReferenceKeyFieldName(String fieldName) {
        this.getReferenceKeyFields().addElement(new DatabaseField(fieldName));
    }

    public void setReferenceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setReferenceKeyFields(fields);
    }

    public void setReferenceKeyFields(Vector<DatabaseField> aVector) {
        this.referenceKeyFields = aVector;
    }

    public void setReferenceTable(DatabaseTable table) {
        this.referenceTable = table;
    }

    public void setReferenceTableName(String tableName) {
        if (tableName == null) {
            this.setReferenceTable(null);
        } else {
            this.setReferenceTable(new DatabaseTable(tableName));
        }
    }

    @Override
    public void setSessionName(String name) {
        super.setSessionName(name);
        this.getInsertQuery().setSessionName(name);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    @Override
    public void calculateDeferredChanges(ChangeRecord changeRecord, AbstractSession session) {
        DirectCollectionChangeRecord collectionRecord = (DirectCollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object objectToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
            Object collection = this.getRealAttributeValueFromObject(changeSet.getUnitOfWorkClone(), session);
            collectionChangeRecord.storeDatabaseCounts(collection, this.getContainerPolicy(), session);
        }
        collectionChangeRecord.addAdditionChange(objectToAdd, new Integer(1));
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object objectToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
            Object collection = this.getRealAttributeValueFromObject(changeSet.getUnitOfWorkClone(), session);
            collectionChangeRecord.storeDatabaseCounts(collection, this.getContainerPolicy(), session);
        }
        collectionChangeRecord.addRemoveChange(objectToRemove, new Integer(1));
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.setOriginalCollection(oldValue);
        }
        collectionChangeRecord.setLatestCollection(newValue);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    @Override
    public void useCollectionClass(Class concreteClass) {
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass);
        this.setContainerPolicy(policy);
    }

    @Override
    public void useMapClass(Class concreteClass, String methodName) {
        throw ValidationException.illegalUseOfMapInDirectCollection(this, concreteClass, methodName);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession session) throws DatabaseException {
        ReadQuery targetQuery = this.getSelectionQuery();
        return this.getIndirectionPolicy().valueFromQuery(targetQuery, row, query.getSession());
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.getContainerPolicy().isEmpty(value);
    }

    @Override
    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        DirectCollectionChangeRecord collectionChangeRecord;
        if (newValue == null) {
            newValue = DirectCollectionChangeRecord.Null;
        }
        if ((collectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName())) == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
            Object collection = this.getRealAttributeValueFromObject(objectChangeSet.getUnitOfWorkClone(), uow);
            collectionChangeRecord.storeDatabaseCounts(collection, this.getContainerPolicy(), uow);
        }
        collectionChangeRecord.addAdditionChange(newValue, new Integer(1));
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported() {
        return true;
    }

    @Override
    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        DirectCollectionChangeRecord collectionChangeRecord;
        if (newValue == null) {
            newValue = DirectCollectionChangeRecord.Null;
        }
        if ((collectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName())) == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
            Object collection = this.getRealAttributeValueFromObject(objectChangeSet.getUnitOfWorkClone(), uow);
            collectionChangeRecord.storeDatabaseCounts(collection, this.getContainerPolicy(), uow);
        }
        collectionChangeRecord.addRemoveChange(newValue, new Integer(1));
    }
}

