/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.tools.schemaframework.SequenceDefinition;

public class SequenceObjectDefinition
extends SequenceDefinition {
    public SequenceObjectDefinition(Sequence sequence) {
        super(sequence);
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) {
        try {
            int startWith = this.sequence.getInitialValue() + this.sequence.getPreallocationSize() - 1;
            session.getPlatform().buildSequenceObjectCreationWriter(writer, this.getFullName(), this.sequence.getPreallocationSize(), startWith);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) {
        try {
            session.getPlatform().buildSequenceObjectDeletionWriter(writer, this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildAlterIncrementWriter(AbstractSession session, Writer writer) {
        try {
            session.getPlatform().buildSequenceObjectAlterIncrementWriter(writer, this.getFullName(), this.sequence.getPreallocationSize());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public boolean checkIfExist(AbstractSession session) throws DatabaseException {
        boolean isConnected = this.sequence.isConnected();
        if (!isConnected) {
            this.sequence.onConnect(session.getPlatform());
        }
        try {
            if (this.sequence.shouldUsePreallocation()) {
                this.sequence.getGeneratedVector(null, session);
            } else {
                this.sequence.getGeneratedValue(null, session);
            }
            boolean bl = true;
            return bl;
        }
        catch (DatabaseException databaseException) {
            boolean bl = false;
            return bl;
        }
        catch (ValidationException validationException) {
            if (validationException.getErrorCode() == 7027) {
                boolean bl = true;
                return bl;
            }
            throw validationException;
        }
        finally {
            if (!isConnected) {
                this.sequence.onDisconnect(session.getPlatform());
            }
        }
    }

    public boolean isAlterSupported(AbstractSession session) {
        return session.getPlatform().isAlterSequenceObjectSupported();
    }

    public void alterOnDatabase(AbstractSession session) throws TopLinkException {
        try {
            session.executeNonSelectingCall(new SQLCall(this.buildAlterIncrementWriter(session, new StringWriter()).toString()));
        }
        catch (DatabaseException exception) {
            this.createOnDatabase(session);
        }
    }

    public void alterIncrement(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.alterOnDatabase(session);
        } else {
            this.buildAlterIncrementWriter(session, schemaWriter);
        }
    }
}

