/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

public class SemanticVersion {
    public static int compose(int major, int minor, int patch) {
        if (major < 0 || major > 255) {
            throw new IllegalArgumentException("major must be 0-255: " + major);
        }
        if (minor < 0 || minor > 255) {
            throw new IllegalArgumentException("minor must be 0-255: " + minor);
        }
        if (patch < 1 || patch > 255) {
            throw new IllegalArgumentException("patch must be 1-255: " + patch);
        }
        return major << 16 | minor << 8 | patch;
    }

    public static int major(int version) {
        return version >> 16 & 0xFF;
    }

    public static int minor(int version) {
        return version >> 8 & 0xFF;
    }

    public static int patch(int version) {
        return version & 0xFF;
    }
}

