/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import uk.co.real_logic.agrona.BitUtil;
import uk.co.real_logic.agrona.Verify;
import uk.co.real_logic.agrona.collections.CollectionUtil;
import uk.co.real_logic.agrona.collections.Hashing;
import uk.co.real_logic.agrona.collections.IntIterator;
import uk.co.real_logic.agrona.generation.DoNotSub;

public final class IntHashSet
implements Set<Integer> {
    public static final double DEFAULT_LOAD_FACTOR = (double)0.67f;
    @DoNotSub
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] values;
    private final IntIterator iterator;
    private final int missingValue;
    private final double loadFactor;
    @DoNotSub
    private int mask;
    @DoNotSub
    private int resizeThreshold;
    @DoNotSub
    private int capacity;
    @DoNotSub
    private int size;

    public IntHashSet(int missingValue) {
        this(8, missingValue);
    }

    public IntHashSet(@DoNotSub int proposedCapacity, int missingValue) {
        this(proposedCapacity, missingValue, 0.67f);
    }

    public IntHashSet(@DoNotSub int initialCapacity, int missingValue, double loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.size = 0;
        this.missingValue = missingValue;
        this.capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        this.mask = this.capacity - 1;
        this.resizeThreshold = (int)((double)this.capacity * loadFactor);
        this.values = new int[this.capacity];
        Arrays.fill(this.values, missingValue);
        this.iterator = new IntIterator(missingValue, this.values);
    }

    public int missingValue() {
        return this.missingValue;
    }

    @Override
    public boolean add(Integer value) {
        return this.add((int)value);
    }

    @Override
    public boolean add(int value) {
        int index = Hashing.hash(value, this.mask);
        while (this.values[index] != this.missingValue) {
            if (this.values[index] == value) {
                return false;
            }
            index = this.next(index);
        }
        this.values[index] = value;
        ++this.size;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.capacity << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(@DoNotSub int newCapacity) {
        CollectionUtil.validatePowerOfTwo(newCapacity);
        this.capacity = newCapacity;
        this.mask = newCapacity - 1;
        this.resizeThreshold = (int)((double)newCapacity * this.loadFactor);
        int[] tempValues = new int[this.capacity];
        Arrays.fill(tempValues, this.missingValue);
        for (int value : this.values) {
            if (value == this.missingValue) continue;
            int newHash = Hashing.hash(value, this.mask);
            while (tempValues[newHash] != this.missingValue) {
                ++newHash;
                newHash &= this.mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        return value instanceof Integer && this.remove((Integer)value);
    }

    public boolean remove(int value) {
        int index = Hashing.hash(value, this.mask);
        int[] values = this.values;
        while (values[index] != this.missingValue) {
            if (values[index] == value) {
                values[index] = this.missingValue;
                this.compactChain(index);
                --this.size;
                return true;
            }
            index = this.next(index);
        }
        return false;
    }

    @DoNotSub
    private int next(int index) {
        return index + 1 & this.mask;
    }

    @DoNotSub
    private void compactChain(int deleteIndex) {
        int[] values = this.values;
        int index = deleteIndex;
        while (values[index = this.next(index)] != this.missingValue) {
            int hash = Hashing.hash(values[index], this.mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = this.missingValue;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    @Override
    public boolean contains(Object value) {
        return value instanceof Integer && this.contains((Integer)value);
    }

    public boolean contains(int value) {
        int index = Hashing.hash(value, this.mask);
        while (this.values[index] != this.missingValue) {
            if (this.values[index] == value) {
                return true;
            }
            index = this.next(index);
        }
        return false;
    }

    @Override
    @DoNotSub
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public double loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, this.missingValue);
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> coll) {
        return this.conjunction(coll, x -> this.add((Integer)x));
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.conjunction(coll, this::contains);
    }

    public boolean containsAll(IntHashSet other) {
        boolean containsAll = true;
        for (int value : this.values) {
            if (value == this.missingValue || other.contains(value)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public IntHashSet difference(IntHashSet other) {
        Objects.requireNonNull(other);
        IntHashSet difference = null;
        for (int value : this.values) {
            if (value == this.missingValue || other.contains(value)) continue;
            if (difference == null) {
                difference = new IntHashSet(this.size, this.missingValue);
            }
            difference.add(value);
        }
        return difference;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.conjunction(coll, this::remove);
    }

    private <T> boolean conjunction(Collection<T> collection, Predicate<T> predicate) {
        Objects.requireNonNull(collection);
        boolean acc = false;
        for (T t : collection) {
            acc |= predicate.test(t);
        }
        return acc;
    }

    public IntIterator iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public void copy(IntHashSet obj) {
        if (this.mask != obj.mask) {
            throw new IllegalArgumentException("Cannot copy object: masks not equal");
        }
        if (this.missingValue != obj.missingValue) {
            throw new IllegalArgumentException("Cannot copy object: missingValues not equal");
        }
        System.arraycopy(obj.values, 0, this.values, 0, this.values.length);
        this.size = obj.size;
    }

    public String toString() {
        return this.stream().map(x -> Integer.toString(x)).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public <T> T[] toArray(T[] into) {
        Verify.notNull(into, "into");
        Class<Integer> componentType = into.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Integer.class)) {
            throw new ArrayStoreException("Cannot store Integers in array of type " + componentType);
        }
        int size = this.size;
        Object[] arrayCopy = into.length >= size ? into : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        IntIterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            arrayCopy[i] = iterator.next();
            ++i;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IntHashSet) {
            IntHashSet otherSet = (IntHashSet)other;
            return otherSet.missingValue == this.missingValue && otherSet.size == this.size && this.containsAll(otherSet);
        }
        return false;
    }

    @Override
    @DoNotSub
    public int hashCode() {
        int total = 0;
        for (int value : this.values) {
            total += value;
        }
        return total;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

