/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.co.real_logic.agrona.generation.DoNotSub;

public class LongIterator
implements Iterator<Long> {
    private final long missingValue;
    private long[] values;
    @DoNotSub
    private int mask;
    @DoNotSub
    private int positionCounter;
    @DoNotSub
    private int stopCounter;

    public LongIterator(long missingValue, long[] values) {
        this.missingValue = missingValue;
        this.reset(values);
    }

    void reset() {
        this.reset(this.values);
    }

    void reset(long[] values) {
        this.values = values;
        int length = values.length;
        this.mask = length - 1;
        int i = length;
        if (values[length - 1] != this.missingValue) {
            int size = length;
            for (i = 0; i < size && values[i] != this.missingValue; ++i) {
            }
        }
        this.stopCounter = i;
        this.positionCounter = i + length;
    }

    @DoNotSub
    protected int position() {
        return this.positionCounter & this.mask;
    }

    @Override
    public boolean hasNext() {
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & this.mask;
            if (this.values[index] == this.missingValue) continue;
            return true;
        }
        return false;
    }

    protected void findNext() {
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & this.mask;
            if (this.values[index] == this.missingValue) continue;
            this.positionCounter = i;
            return;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Long next() {
        return this.nextValue();
    }

    public long nextValue() {
        this.findNext();
        return this.values[this.position()];
    }
}

