/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.util.Arrays;
import java.util.List;
import uk.co.real_logic.agrona.concurrent.Agent;

public class CompositeAgent
implements Agent {
    private final Agent[] agents;
    private final String roleName;

    public CompositeAgent(List<? extends Agent> agents) {
        this(agents.toArray(new Agent[agents.size()]));
    }

    public CompositeAgent(Agent ... agents) {
        if (agents == null) {
            throw new NullPointerException("Expecting at least one Agent");
        }
        if (agents.length == 0) {
            throw new IllegalArgumentException("Expecting at least one Agent");
        }
        StringBuilder buff = new StringBuilder(agents.length * 16);
        buff.append('[');
        for (Agent agent : agents) {
            if (agent == null) {
                throw new NullPointerException("Agents list contains a null");
            }
            buff.append(agent.roleName());
            buff.append(',');
        }
        buff.setCharAt(buff.length() - 1, ']');
        this.roleName = buff.toString();
        this.agents = Arrays.copyOf(agents, agents.length);
    }

    @Override
    public int doWork() throws Exception {
        int sum = 0;
        for (Agent agent : this.agents) {
            sum += agent.doWork();
        }
        return sum;
    }

    @Override
    public void onClose() {
        for (Agent agent : this.agents) {
            agent.onClose();
        }
    }

    @Override
    public String roleName() {
        return this.roleName;
    }
}

