/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.concurrent;

import java.util.Collection;
import java.util.function.Consumer;
import uk.co.real_logic.agrona.UnsafeAccess;
import uk.co.real_logic.agrona.concurrent.AbstractConcurrentArrayQueue;

public class ManyToOneConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueue<E> {
    public ManyToOneConcurrentArrayQueue(int requestedCapacity) {
        super(requestedCapacity);
    }

    @Override
    public boolean offer(E e) {
        long currentTail;
        if (null == e) {
            throw new NullPointerException("element cannot be null");
        }
        int capacity = this.capacity;
        long currentHead = this.sharedHeadCache;
        long bufferLimit = currentHead + (long)capacity;
        do {
            if ((currentTail = this.tail) < bufferLimit) continue;
            currentHead = this.head;
            bufferLimit = currentHead + (long)capacity;
            if (currentTail >= bufferLimit) {
                return false;
            }
            UnsafeAccess.UNSAFE.putOrderedLong(this, SHARED_HEAD_CACHE_OFFSET, currentHead);
        } while (!UnsafeAccess.UNSAFE.compareAndSwapLong(this, TAIL_OFFSET, currentTail, currentTail + 1L));
        UnsafeAccess.UNSAFE.putOrderedObject(this.buffer, ManyToOneConcurrentArrayQueue.sequenceToBufferOffset(currentTail, capacity - 1), e);
        return true;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long currentHead = this.head;
        long elementOffset = ManyToOneConcurrentArrayQueue.sequenceToBufferOffset(currentHead, this.capacity - 1);
        Object e = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, elementOffset);
        if (null != e) {
            UnsafeAccess.UNSAFE.putObject(buffer, elementOffset, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, currentHead + 1L);
        }
        return (E)e;
    }

    @Override
    public int drain(Consumer<E> elementHandler) {
        long elementOffset;
        Object item;
        long currentHead;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long nextSequence = currentHead = this.head;
        long limit = nextSequence + mask + 1L;
        while (nextSequence < limit && null != (item = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, elementOffset = ManyToOneConcurrentArrayQueue.sequenceToBufferOffset(nextSequence, mask)))) {
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, elementOffset, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, ++nextSequence);
            elementHandler.accept(item);
        }
        return (int)(nextSequence - currentHead);
    }

    @Override
    public int drainTo(Collection<? super E> target, int limit) {
        long elementOffset;
        Object e;
        int count;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long nextSequence = this.head;
        for (count = 0; count < limit && null != (e = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, elementOffset = ManyToOneConcurrentArrayQueue.sequenceToBufferOffset(nextSequence, mask))); ++count) {
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, elementOffset, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, ++nextSequence);
            target.add(e);
        }
        return count;
    }
}

