/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.agrona.nio;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.Selector;
import uk.co.real_logic.agrona.LangUtil;
import uk.co.real_logic.agrona.nio.NioSelectedKeySet;

public class TransportPoller
implements AutoCloseable {
    private static final String SELECTOR_IMPL = "sun.nio.ch.SelectorImpl";
    protected static final Field SELECTED_KEYS_FIELD;
    protected static final Field PUBLIC_SELECTED_KEYS_FIELD;
    protected static final int ITERATION_THRESHOLD = 5;
    protected final Selector selector;
    protected final NioSelectedKeySet selectedKeySet;

    public TransportPoller() {
        try {
            this.selector = Selector.open();
            this.selectedKeySet = new NioSelectedKeySet();
            SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
            PUBLIC_SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        this.selector.wakeup();
        try {
            this.selector.close();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public void selectNowWithoutProcessing() {
        try {
            this.selector.selectNow();
            this.selectedKeySet.reset();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    static {
        Field selectKeysField = null;
        Field publicSelectKeysField = null;
        try {
            Class<?> clazz = Class.forName(SELECTOR_IMPL, false, ClassLoader.getSystemClassLoader());
            if (clazz.isAssignableFrom(Selector.open().getClass())) {
                selectKeysField = clazz.getDeclaredField("selectedKeys");
                selectKeysField.setAccessible(true);
                publicSelectKeysField = clazz.getDeclaredField("publicSelectedKeys");
                publicSelectKeysField.setAccessible(true);
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        finally {
            SELECTED_KEYS_FIELD = selectKeysField;
            PUBLIC_SELECTED_KEYS_FIELD = publicSelectKeysField;
        }
    }
}

