/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ValidationUtil {
    private static final Set<String> CPP_KEYWORDS = new HashSet<String>(Arrays.asList("alignas", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "class", "compl", "const", "const_cast", "continue", "char16_t", "char32_t", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "not", "not_eq", "noexcept", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "return", "short", "signed", "sizeof", "static", "static_cast", "struct", "switch", "template", "this", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq", "override", "alignof", "constexpr", "decltype", "nullptr", "static_assert", "thread_local", "final"));
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "null", "true", "false"));

    private static boolean isSbeCppIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private static boolean isSbeCppIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean isSbeCppName(String value) {
        if (ValidationUtil.possibleCppKeyword(value)) {
            return !CPP_KEYWORDS.contains(value);
        }
        return false;
    }

    private static boolean possibleCppKeyword(String stringVal) {
        int size = stringVal.length();
        for (int i = 0; i < size; ++i) {
            char c = stringVal.charAt(i);
            if (i == 0 && ValidationUtil.isSbeCppIdentifierStart(c) || ValidationUtil.isSbeCppIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSbeJavaName(String value) {
        for (String token : value.split("\\.", -1)) {
            if (ValidationUtil.possibleJavaKeyword(token)) {
                if (!JAVA_KEYWORDS.contains(token)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean possibleJavaKeyword(String value) {
        if (value.length() == 0) {
            return false;
        }
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (i == 0 && Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }
}

