/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;
import org.agrona.collections.MapDelegatingSet;
import org.agrona.generation.DoNotSub;

public class Int2IntHashMap
implements Map<Integer, Integer> {
    @DoNotSub
    private final double loadFactor;
    private final int missingValue;
    @DoNotSub
    private int resizeThreshold;
    @DoNotSub
    private int size = 0;
    private int[] entries;
    private final KeySet keySet;
    private final Values values;
    private final Set<Map.Entry<Integer, Integer>> entrySet;

    public Int2IntHashMap(int missingValue) {
        this(16, 0.67, missingValue);
    }

    public Int2IntHashMap(@DoNotSub int initialCapacity, @DoNotSub double loadFactor, int missingValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(initialCapacity));
        this.keySet = new KeySet();
        this.values = new Values();
        this.entrySet = new EntrySet();
    }

    public int missingValue() {
        return this.missingValue;
    }

    @Override
    @DoNotSub
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int key) {
        int candidateKey;
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int value = missingValue;
        while ((candidateKey = entries[index]) != missingValue) {
            if (candidateKey == key) {
                value = entries[index + 1];
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public int put(int key, int value) {
        int candidateKey;
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = missingValue;
        while ((candidateKey = entries[index]) != missingValue) {
            if (candidateKey == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        if (oldValue == missingValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(@DoNotSub int newCapacity) {
        int[] oldEntries = this.entries;
        int missingValue = this.missingValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        for (int i = 0; i < length; i += 2) {
            int key = oldEntries[i];
            if (key == missingValue) continue;
            this.put(key, oldEntries[i + 1]);
        }
    }

    public void intForEach(IntIntConsumer consumer) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int length = entries.length;
        for (int i = 0; i < length; i += 2) {
            int key = entries[i];
            if (key == missingValue) continue;
            consumer.accept(entries[i], entries[i + 1]);
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != this.missingValue;
    }

    public boolean containsValue(int value) {
        int[] entries = this.entries;
        int length = entries.length;
        boolean found = false;
        for (int i = 1; i < length; i += 2) {
            if (value != entries[i]) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public void clear() {
        Arrays.fill(this.entries, this.missingValue);
        this.size = 0;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    @Override
    public Integer get(Object key) {
        return this.get((Integer)key);
    }

    @Override
    public Integer put(Integer key, Integer value) {
        return this.put((int)key, (int)value);
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Integer> action) {
        this.intForEach(action::accept);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        for (Map.Entry<? extends Integer, ? extends Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        return this.keySet;
    }

    public Values values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Integer>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Integer remove(Object key) {
        return this.remove((Integer)key);
    }

    public int remove(int key) {
        int candidateKey;
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = missingValue;
        while ((candidateKey = entries[index]) != missingValue) {
            if (candidateKey == key) {
                int valueIndex = index + 1;
                oldValue = entries[valueIndex];
                entries[index] = missingValue;
                entries[valueIndex] = missingValue;
                --this.size;
                this.compactChain(index);
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        return oldValue;
    }

    private void compactChain(@DoNotSub int deleteIndex) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = deleteIndex;
        while (entries[index = Int2IntHashMap.next(index, mask)] != missingValue) {
            int hash = Hashing.evenHash(entries[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            entries[deleteIndex] = entries[index];
            entries[deleteIndex + 1] = entries[index + 1];
            entries[index] = missingValue;
            entries[index + 1] = missingValue;
            deleteIndex = index;
        }
    }

    public int minValue() {
        int missingValue = this.missingValue;
        int min = this.size == 0 ? missingValue : Integer.MAX_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = entries[i];
            if (value == missingValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public int maxValue() {
        int missingValue = this.missingValue;
        int max = this.size == 0 ? missingValue : Integer.MIN_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = entries[i];
            if (value == missingValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<Integer, Integer> entry : this.entrySet()) {
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @DoNotSub
    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(@DoNotSub int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((double)newCapacity * this.loadFactor);
        this.entries = new int[entriesLength];
        this.size = 0;
        Arrays.fill(this.entries, this.missingValue);
    }

    private final class EntrySet
    extends MapDelegatingSet<Map.Entry<Integer, Integer>> {
        private final EntryIterator entryIterator;

        private EntrySet() {
            super(Int2IntHashMap.this);
            this.entryIterator = new EntryIterator();
        }

        @Override
        public Iterator<Map.Entry<Integer, Integer>> iterator() {
            return this.entryIterator.reset();
        }

        @Override
        public boolean contains(Object o) {
            return Int2IntHashMap.this.containsKey(((Map.Entry)o).getKey());
        }
    }

    public final class Values
    extends AbstractCollection<Integer> {
        private final IntIterator valueIterator;

        private Values() {
            this.valueIterator = new IntIterator(1);
        }

        public IntIterator iterator() {
            return this.valueIterator.reset();
        }

        @Override
        @DoNotSub
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2IntHashMap.this.containsValue(key);
        }
    }

    public final class KeySet
    extends MapDelegatingSet<Integer> {
        private final IntIterator keyIterator;

        private KeySet() {
            super(Int2IntHashMap.this);
            this.keyIterator = new IntIterator(0);
        }

        public IntIterator iterator() {
            return this.keyIterator.reset();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2IntHashMap.this.containsKey(key);
        }
    }

    final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Integer, Integer>>,
    Map.Entry<Integer, Integer> {
        private int key;
        private int value;

        private EntryIterator() {
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            this.findNext();
            int keyPosition = this.keyPosition();
            this.key = Int2IntHashMap.this.entries[keyPosition];
            this.value = Int2IntHashMap.this.entries[keyPosition + 1];
            return this;
        }

        public EntryIterator reset() {
            ((AbstractIterator)this).reset();
            this.key = Int2IntHashMap.this.missingValue;
            this.value = Int2IntHashMap.this.missingValue;
            return this;
        }
    }

    public final class IntIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @DoNotSub
        private final int offset;

        private IntIterator(int offset) {
            this.offset = offset;
        }

        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition() + this.offset];
        }

        public IntIterator reset() {
            ((AbstractIterator)this).reset();
            return this;
        }
    }

    abstract class AbstractIterator {
        @DoNotSub
        private int positionCounter;
        @DoNotSub
        private int stopCounter;

        AbstractIterator() {
            this.reset();
        }

        private void reset() {
            int capacity;
            int missingValue = Int2IntHashMap.this.missingValue;
            int[] entries = Int2IntHashMap.this.entries;
            int i = capacity = entries.length;
            if (entries[capacity - 2] != missingValue) {
                int size = capacity;
                for (i = 0; i < size && entries[i] != missingValue; i += 2) {
                }
            }
            this.stopCounter = i;
            this.positionCounter = i + capacity;
        }

        @DoNotSub
        protected int keyPosition() {
            return this.positionCounter & Int2IntHashMap.this.entries.length - 1;
        }

        public boolean hasNext() {
            int[] entries = Int2IntHashMap.this.entries;
            int missingValue = Int2IntHashMap.this.missingValue;
            int mask = entries.length - 1;
            boolean hasNext = false;
            for (int i = this.positionCounter - 2; i >= this.stopCounter; i -= 2) {
                int index = i & mask;
                if (entries[index] == missingValue) continue;
                hasNext = true;
                break;
            }
            return hasNext;
        }

        protected void findNext() {
            int[] entries = Int2IntHashMap.this.entries;
            int missingValue = Int2IntHashMap.this.missingValue;
            int mask = entries.length - 1;
            for (int i = this.positionCounter - 2; i >= this.stopCounter; i -= 2) {
                int index = i & mask;
                if (entries[index] == missingValue) continue;
                this.positionCounter = i;
                return;
            }
            throw new NoSuchElementException();
        }
    }
}

