/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir.generated;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.sbe.ir.generated.ByteOrderCodec;
import uk.co.real_logic.sbe.ir.generated.MessageHeaderDecoder;
import uk.co.real_logic.sbe.ir.generated.MetaAttribute;
import uk.co.real_logic.sbe.ir.generated.PresenceCodec;
import uk.co.real_logic.sbe.ir.generated.PrimitiveTypeCodec;
import uk.co.real_logic.sbe.ir.generated.SignalCodec;

public final class TokenCodecDecoder {
    private static final boolean ENABLE_BOUNDS_CHECKS = !Boolean.getBoolean("agrona.disable.bounds.checks");
    private static final boolean SBE_ENABLE_IR_PRECEDENCE_CHECKS = Boolean.parseBoolean(System.getProperty("sbe.enable.ir.precedence.checks", Boolean.toString(ENABLE_BOUNDS_CHECKS)));
    private int codecState = 0;
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final TokenCodecDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    private int codecState() {
        return this.codecState;
    }

    private void codecState(int newState) {
        this.codecState = newState;
    }

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return SEMANTIC_VERSION;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    private void onWrap(int actingVersion) {
        switch (actingVersion) {
            case 0: {
                this.codecState(1);
                break;
            }
            default: {
                this.codecState(1);
            }
        }
    }

    public TokenCodecDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onWrap(actingVersion);
        }
        return this;
    }

    public TokenCodecDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (2 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public TokenCodecDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        int currentCodecState = this.codecState();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.codecState(currentCodecState);
        }
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int tokenOffsetId() {
        return 1;
    }

    public static int tokenOffsetSinceVersion() {
        return 0;
    }

    public static int tokenOffsetEncodingOffset() {
        return 0;
    }

    public static int tokenOffsetEncodingLength() {
        return 4;
    }

    public static String tokenOffsetMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onTokenOffsetAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"tokenOffset\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public static int tokenOffsetNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenOffsetMinValue() {
        return -2147483647;
    }

    public static int tokenOffsetMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int tokenOffset() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTokenOffsetAccessed();
        }
        return this.buffer.getInt(this.offset + 0, BYTE_ORDER);
    }

    public static int tokenSizeId() {
        return 2;
    }

    public static int tokenSizeSinceVersion() {
        return 0;
    }

    public static int tokenSizeEncodingOffset() {
        return 4;
    }

    public static int tokenSizeEncodingLength() {
        return 4;
    }

    public static String tokenSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onTokenSizeAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"tokenSize\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public static int tokenSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenSizeMinValue() {
        return -2147483647;
    }

    public static int tokenSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int tokenSize() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTokenSizeAccessed();
        }
        return this.buffer.getInt(this.offset + 4, BYTE_ORDER);
    }

    public static int fieldIdId() {
        return 3;
    }

    public static int fieldIdSinceVersion() {
        return 0;
    }

    public static int fieldIdEncodingOffset() {
        return 8;
    }

    public static int fieldIdEncodingLength() {
        return 4;
    }

    public static String fieldIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onFieldIdAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"fieldId\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public static int fieldIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int fieldIdMinValue() {
        return -2147483647;
    }

    public static int fieldIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int fieldId() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onFieldIdAccessed();
        }
        return this.buffer.getInt(this.offset + 8, BYTE_ORDER);
    }

    public static int tokenVersionId() {
        return 4;
    }

    public static int tokenVersionSinceVersion() {
        return 0;
    }

    public static int tokenVersionEncodingOffset() {
        return 12;
    }

    public static int tokenVersionEncodingLength() {
        return 4;
    }

    public static String tokenVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onTokenVersionAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"tokenVersion\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public static int tokenVersionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int tokenVersionMinValue() {
        return -2147483647;
    }

    public static int tokenVersionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int tokenVersion() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTokenVersionAccessed();
        }
        return this.buffer.getInt(this.offset + 12, BYTE_ORDER);
    }

    public static int componentTokenCountId() {
        return 5;
    }

    public static int componentTokenCountSinceVersion() {
        return 0;
    }

    public static int componentTokenCountEncodingOffset() {
        return 16;
    }

    public static int componentTokenCountEncodingLength() {
        return 4;
    }

    public static String componentTokenCountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onComponentTokenCountAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"componentTokenCount\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public static int componentTokenCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int componentTokenCountMinValue() {
        return -2147483647;
    }

    public static int componentTokenCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int componentTokenCount() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onComponentTokenCountAccessed();
        }
        return this.buffer.getInt(this.offset + 16, BYTE_ORDER);
    }

    public static int signalId() {
        return 6;
    }

    public static int signalSinceVersion() {
        return 0;
    }

    public static int signalEncodingOffset() {
        return 20;
    }

    public static int signalEncodingLength() {
        return 1;
    }

    public static String signalMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onSignalAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"signal\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public short signalRaw() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSignalAccessed();
        }
        return (short)(this.buffer.getByte(this.offset + 20) & 0xFF);
    }

    public SignalCodec signal() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSignalAccessed();
        }
        return SignalCodec.get((short)(this.buffer.getByte(this.offset + 20) & 0xFF));
    }

    public static int primitiveTypeId() {
        return 7;
    }

    public static int primitiveTypeSinceVersion() {
        return 0;
    }

    public static int primitiveTypeEncodingOffset() {
        return 21;
    }

    public static int primitiveTypeEncodingLength() {
        return 1;
    }

    public static String primitiveTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onPrimitiveTypeAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"primitiveType\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public short primitiveTypeRaw() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPrimitiveTypeAccessed();
        }
        return (short)(this.buffer.getByte(this.offset + 21) & 0xFF);
    }

    public PrimitiveTypeCodec primitiveType() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPrimitiveTypeAccessed();
        }
        return PrimitiveTypeCodec.get((short)(this.buffer.getByte(this.offset + 21) & 0xFF));
    }

    public static int byteOrderId() {
        return 8;
    }

    public static int byteOrderSinceVersion() {
        return 0;
    }

    public static int byteOrderEncodingOffset() {
        return 22;
    }

    public static int byteOrderEncodingLength() {
        return 1;
    }

    public static String byteOrderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onByteOrderAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"byteOrder\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public short byteOrderRaw() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onByteOrderAccessed();
        }
        return (short)(this.buffer.getByte(this.offset + 22) & 0xFF);
    }

    public ByteOrderCodec byteOrder() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onByteOrderAccessed();
        }
        return ByteOrderCodec.get((short)(this.buffer.getByte(this.offset + 22) & 0xFF));
    }

    public static int presenceId() {
        return 9;
    }

    public static int presenceSinceVersion() {
        return 0;
    }

    public static int presenceEncodingOffset() {
        return 23;
    }

    public static int presenceEncodingLength() {
        return 1;
    }

    public static String presenceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    private void onPresenceAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"presence\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public short presenceRaw() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPresenceAccessed();
        }
        return (short)(this.buffer.getByte(this.offset + 23) & 0xFF);
    }

    public PresenceCodec presence() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onPresenceAccessed();
        }
        return PresenceCodec.get((short)(this.buffer.getByte(this.offset + 23) & 0xFF));
    }

    public static int deprecatedId() {
        return 10;
    }

    public static int deprecatedSinceVersion() {
        return 0;
    }

    public static int deprecatedEncodingOffset() {
        return 24;
    }

    public static int deprecatedEncodingLength() {
        return 4;
    }

    public static String deprecatedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return SEMANTIC_VERSION;
    }

    private void onDeprecatedAccessed() {
        if (this.codecState() == 0) {
            throw new IllegalStateException("Illegal field access order. Cannot access field \"deprecated\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
        }
    }

    public static int deprecatedNullValue() {
        return 0;
    }

    public static int deprecatedMinValue() {
        return -2147483647;
    }

    public static int deprecatedMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int deprecated() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDeprecatedAccessed();
        }
        return this.buffer.getInt(this.offset + 24, BYTE_ORDER);
    }

    public static int nameId() {
        return 11;
    }

    public static int nameSinceVersion() {
        return 0;
    }

    public static String nameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String nameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int nameHeaderLength() {
        return 2;
    }

    void onNameLengthAccessed() {
        switch (this.codecState()) {
            case 1: {
                this.codecState(1);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"name\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onNameAccessed() {
        switch (this.codecState()) {
            case 1: {
                this.codecState(2);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"name\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int nameLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipName() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getName(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getName(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapName(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String name() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int constValueId() {
        return 12;
    }

    public static int constValueSinceVersion() {
        return 0;
    }

    public static String constValueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String constValueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int constValueHeaderLength() {
        return 2;
    }

    void onConstValueLengthAccessed() {
        switch (this.codecState()) {
            case 2: {
                this.codecState(2);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"constValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onConstValueAccessed() {
        switch (this.codecState()) {
            case 2: {
                this.codecState(3);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"constValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int constValueLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipConstValue() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getConstValue(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getConstValue(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapConstValue(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String constValue() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onConstValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int minValueId() {
        return 13;
    }

    public static int minValueSinceVersion() {
        return 0;
    }

    public static String minValueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String minValueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int minValueHeaderLength() {
        return 2;
    }

    void onMinValueLengthAccessed() {
        switch (this.codecState()) {
            case 3: {
                this.codecState(3);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"minValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onMinValueAccessed() {
        switch (this.codecState()) {
            case 3: {
                this.codecState(4);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"minValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int minValueLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipMinValue() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMinValue(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMinValue(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMinValue(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String minValue() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMinValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int maxValueId() {
        return 14;
    }

    public static int maxValueSinceVersion() {
        return 0;
    }

    public static String maxValueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String maxValueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int maxValueHeaderLength() {
        return 2;
    }

    void onMaxValueLengthAccessed() {
        switch (this.codecState()) {
            case 4: {
                this.codecState(4);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"maxValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onMaxValueAccessed() {
        switch (this.codecState()) {
            case 4: {
                this.codecState(5);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"maxValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int maxValueLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipMaxValue() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMaxValue(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMaxValue(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMaxValue(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String maxValue() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onMaxValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int nullValueId() {
        return 15;
    }

    public static int nullValueSinceVersion() {
        return 0;
    }

    public static String nullValueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String nullValueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int nullValueHeaderLength() {
        return 2;
    }

    void onNullValueLengthAccessed() {
        switch (this.codecState()) {
            case 5: {
                this.codecState(5);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"nullValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onNullValueAccessed() {
        switch (this.codecState()) {
            case 5: {
                this.codecState(6);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"nullValue\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int nullValueLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipNullValue() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getNullValue(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getNullValue(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapNullValue(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String nullValue() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onNullValueAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int characterEncodingId() {
        return 16;
    }

    public static int characterEncodingSinceVersion() {
        return 0;
    }

    public static String characterEncodingCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String characterEncodingMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int characterEncodingHeaderLength() {
        return 2;
    }

    void onCharacterEncodingLengthAccessed() {
        switch (this.codecState()) {
            case 6: {
                this.codecState(6);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"characterEncoding\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onCharacterEncodingAccessed() {
        switch (this.codecState()) {
            case 6: {
                this.codecState(7);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"characterEncoding\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int characterEncodingLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipCharacterEncoding() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getCharacterEncoding(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getCharacterEncoding(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapCharacterEncoding(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String characterEncoding() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onCharacterEncodingAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int epochId() {
        return 17;
    }

    public static int epochSinceVersion() {
        return 0;
    }

    public static String epochCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String epochMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int epochHeaderLength() {
        return 2;
    }

    void onEpochLengthAccessed() {
        switch (this.codecState()) {
            case 7: {
                this.codecState(7);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"epoch\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onEpochAccessed() {
        switch (this.codecState()) {
            case 7: {
                this.codecState(8);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"epoch\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int epochLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipEpoch() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getEpoch(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getEpoch(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapEpoch(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String epoch() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onEpochAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int timeUnitId() {
        return 18;
    }

    public static int timeUnitSinceVersion() {
        return 0;
    }

    public static String timeUnitCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String timeUnitMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int timeUnitHeaderLength() {
        return 2;
    }

    void onTimeUnitLengthAccessed() {
        switch (this.codecState()) {
            case 8: {
                this.codecState(8);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"timeUnit\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onTimeUnitAccessed() {
        switch (this.codecState()) {
            case 8: {
                this.codecState(9);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"timeUnit\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int timeUnitLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipTimeUnit() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getTimeUnit(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getTimeUnit(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapTimeUnit(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String timeUnit() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onTimeUnitAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int semanticTypeId() {
        return 19;
    }

    public static int semanticTypeSinceVersion() {
        return 0;
    }

    public static String semanticTypeCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String semanticTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int semanticTypeHeaderLength() {
        return 2;
    }

    void onSemanticTypeLengthAccessed() {
        switch (this.codecState()) {
            case 9: {
                this.codecState(9);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"semanticType\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onSemanticTypeAccessed() {
        switch (this.codecState()) {
            case 9: {
                this.codecState(10);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"semanticType\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int semanticTypeLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipSemanticType() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getSemanticType(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSemanticType(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapSemanticType(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String semanticType() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onSemanticTypeAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int descriptionId() {
        return 20;
    }

    public static int descriptionSinceVersion() {
        return 0;
    }

    public static String descriptionCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String descriptionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int descriptionHeaderLength() {
        return 2;
    }

    void onDescriptionLengthAccessed() {
        switch (this.codecState()) {
            case 10: {
                this.codecState(10);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"description\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onDescriptionAccessed() {
        switch (this.codecState()) {
            case 10: {
                this.codecState(11);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"description\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int descriptionLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipDescription() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getDescription(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getDescription(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapDescription(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String description() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onDescriptionAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int referencedNameId() {
        return 21;
    }

    public static int referencedNameSinceVersion() {
        return 0;
    }

    public static String referencedNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String referencedNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return SEMANTIC_VERSION;
    }

    public static int referencedNameHeaderLength() {
        return 2;
    }

    void onReferencedNameLengthAccessed() {
        switch (this.codecState()) {
            case 11: {
                this.codecState(11);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot decode length of var data \"referencedName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    private void onReferencedNameAccessed() {
        switch (this.codecState()) {
            case 11: {
                this.codecState(12);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal field access order. Cannot access field \"referencedName\" in state: " + CodecStates.name(this.codecState()) + ". Expected one of these transitions: [" + CodecStates.transitions(this.codecState()) + "]. Please see the diagram in the Javadoc of the class TokenCodecDecoder#CodecStates.");
            }
        }
    }

    public int referencedNameLength() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameLengthAccessed();
        }
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
    }

    public int skipReferencedName() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int dataOffset = limit + 2;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getReferencedName(MutableDirectBuffer dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getReferencedName(byte[] dst, int dstOffset, int length) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapReferencedName(DirectBuffer wrapBuffer) {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String referencedName() {
        if (SBE_ENABLE_IR_PRECEDENCE_CHECKS) {
            this.onReferencedNameAccessed();
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, BYTE_ORDER) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return SEMANTIC_VERSION;
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return SEMANTIC_VERSION;
        }
        TokenCodecDecoder decoder = new TokenCodecDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[TokenCodec](sbeTemplateId=");
        builder.append(2);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 28) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(28);
        builder.append("):");
        builder.append("tokenOffset=");
        builder.append(this.tokenOffset());
        builder.append('|');
        builder.append("tokenSize=");
        builder.append(this.tokenSize());
        builder.append('|');
        builder.append("fieldId=");
        builder.append(this.fieldId());
        builder.append('|');
        builder.append("tokenVersion=");
        builder.append(this.tokenVersion());
        builder.append('|');
        builder.append("componentTokenCount=");
        builder.append(this.componentTokenCount());
        builder.append('|');
        builder.append("signal=");
        builder.append((Object)this.signal());
        builder.append('|');
        builder.append("primitiveType=");
        builder.append((Object)this.primitiveType());
        builder.append('|');
        builder.append("byteOrder=");
        builder.append((Object)this.byteOrder());
        builder.append('|');
        builder.append("presence=");
        builder.append((Object)this.presence());
        builder.append('|');
        builder.append("deprecated=");
        builder.append(this.deprecated());
        builder.append('|');
        builder.append("name=");
        builder.append('\'').append(this.name()).append('\'');
        builder.append('|');
        builder.append("constValue=");
        builder.append('\'').append(this.constValue()).append('\'');
        builder.append('|');
        builder.append("minValue=");
        builder.append('\'').append(this.minValue()).append('\'');
        builder.append('|');
        builder.append("maxValue=");
        builder.append('\'').append(this.maxValue()).append('\'');
        builder.append('|');
        builder.append("nullValue=");
        builder.append('\'').append(this.nullValue()).append('\'');
        builder.append('|');
        builder.append("characterEncoding=");
        builder.append('\'').append(this.characterEncoding()).append('\'');
        builder.append('|');
        builder.append("epoch=");
        builder.append('\'').append(this.epoch()).append('\'');
        builder.append('|');
        builder.append("timeUnit=");
        builder.append('\'').append(this.timeUnit()).append('\'');
        builder.append('|');
        builder.append("semanticType=");
        builder.append('\'').append(this.semanticType()).append('\'');
        builder.append('|');
        builder.append("description=");
        builder.append('\'').append(this.description()).append('\'');
        builder.append('|');
        builder.append("referencedName=");
        builder.append('\'').append(this.referencedName()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public TokenCodecDecoder sbeSkip() {
        this.sbeRewind();
        this.skipName();
        this.skipConstValue();
        this.skipMinValue();
        this.skipMaxValue();
        this.skipNullValue();
        this.skipCharacterEncoding();
        this.skipEpoch();
        this.skipTimeUnit();
        this.skipSemanticType();
        this.skipDescription();
        this.skipReferencedName();
        return this;
    }

    private static class CodecStates {
        private static final int NOT_WRAPPED = 0;
        private static final int V0_BLOCK = 1;
        private static final int V0_NAME_DONE = 2;
        private static final int V0_CONSTVALUE_DONE = 3;
        private static final int V0_MINVALUE_DONE = 4;
        private static final int V0_MAXVALUE_DONE = 5;
        private static final int V0_NULLVALUE_DONE = 6;
        private static final int V0_CHARACTERENCODING_DONE = 7;
        private static final int V0_EPOCH_DONE = 8;
        private static final int V0_TIMEUNIT_DONE = 9;
        private static final int V0_SEMANTICTYPE_DONE = 10;
        private static final int V0_DESCRIPTION_DONE = 11;
        private static final int V0_REFERENCEDNAME_DONE = 12;
        private static final String[] STATE_NAME_LOOKUP = new String[]{"NOT_WRAPPED", "V0_BLOCK", "V0_NAME_DONE", "V0_CONSTVALUE_DONE", "V0_MINVALUE_DONE", "V0_MAXVALUE_DONE", "V0_NULLVALUE_DONE", "V0_CHARACTERENCODING_DONE", "V0_EPOCH_DONE", "V0_TIMEUNIT_DONE", "V0_SEMANTICTYPE_DONE", "V0_DESCRIPTION_DONE", "V0_REFERENCEDNAME_DONE"};
        private static final String[] STATE_TRANSITIONS_LOOKUP = new String[]{"\"wrap(version=0)\"", "\"tokenOffset(?)\", \"tokenSize(?)\", \"fieldId(?)\", \"tokenVersion(?)\", \"componentTokenCount(?)\", \"signal(?)\", \"primitiveType(?)\", \"byteOrder(?)\", \"presence(?)\", \"deprecated(?)\", \"nameLength()\", \"name(?)\"", "\"constValueLength()\", \"constValue(?)\"", "\"minValueLength()\", \"minValue(?)\"", "\"maxValueLength()\", \"maxValue(?)\"", "\"nullValueLength()\", \"nullValue(?)\"", "\"characterEncodingLength()\", \"characterEncoding(?)\"", "\"epochLength()\", \"epoch(?)\"", "\"timeUnitLength()\", \"timeUnit(?)\"", "\"semanticTypeLength()\", \"semanticType(?)\"", "\"descriptionLength()\", \"description(?)\"", "\"referencedNameLength()\", \"referencedName(?)\"", ""};

        private CodecStates() {
        }

        private static String name(int state) {
            return STATE_NAME_LOOKUP[state];
        }

        private static String transitions(int state) {
            return STATE_TRANSITIONS_LOOKUP[state];
        }
    }
}

