/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.csharp;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.agrona.Verify;
import org.agrona.collections.MutableBoolean;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.common.FieldPrecedenceModel;
import uk.co.real_logic.sbe.generation.common.PrecedenceChecks;
import uk.co.real_logic.sbe.generation.csharp.CSharpUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class CSharpGenerator
implements CodeGenerator {
    private static final String META_ATTRIBUTE_ENUM = "MetaAttribute";
    private static final String INDENT = "    ";
    private static final String TWO_INDENT = "        ";
    private static final String THREE_INDENT = "            ";
    private static final String BASE_INDENT = "    ";
    private final Ir ir;
    private final OutputManager outputManager;
    private final PrecedenceChecks precedenceChecks;
    private final String precedenceChecksFlagName;

    public CSharpGenerator(Ir ir, OutputManager outputManager) {
        this(ir, PrecedenceChecks.newInstance(new PrecedenceChecks.Context()), outputManager);
    }

    public CSharpGenerator(Ir ir, PrecedenceChecks precedenceChecks, OutputManager outputManager) {
        Verify.notNull(ir, "ir");
        Verify.notNull(outputManager, "outputManager");
        this.ir = ir;
        this.precedenceChecks = precedenceChecks;
        this.precedenceChecksFlagName = precedenceChecks.context().precedenceChecksFlagName();
        this.outputManager = outputManager;
    }

    public void generateMessageHeaderStub() throws IOException {
        this.generateComposite(this.ir.headerStructure().tokens());
    }

    public void generateTypeStubs() throws IOException {
        this.generateMetaAttributeEnum();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateBitSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                    break;
                }
            }
        }
    }

    @Override
    public void generate() throws IOException {
        this.generateMessageHeaderStub();
        this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String className = CSharpUtil.formatClassName(msgToken.name());
            String stateClassName = className + ".CodecState";
            FieldPrecedenceModel fieldPrecedenceModel = this.precedenceChecks.createCodecModel(stateClassName, tokens);
            Writer out = this.outputManager.createOutput(className);
            Throwable throwable = null;
            try {
                List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
                int offset = 0;
                ArrayList<Token> fields = new ArrayList<Token>();
                offset = GenerationUtil.collectFields(messageBody, offset, fields);
                ArrayList<Token> groups = new ArrayList<Token>();
                offset = GenerationUtil.collectGroups(messageBody, offset, groups);
                ArrayList<Token> varData = new ArrayList<Token>();
                GenerationUtil.collectVarData(messageBody, offset, varData);
                out.append(this.generateFileHeader(this.ir.applicableNamespace()));
                out.append(CSharpGenerator.generateDocumentation("    ", msgToken));
                out.append(this.generateClassDeclaration(className));
                out.append(this.generateMessageFlyweightCode(className, msgToken, fieldPrecedenceModel, "    "));
                out.append(CSharpGenerator.generateFieldOrderStates(TWO_INDENT, fieldPrecedenceModel));
                out.append(this.generateFullyEncodedCheck(TWO_INDENT, fieldPrecedenceModel));
                out.append(this.generateFields(fieldPrecedenceModel, fields, "    "));
                StringBuilder sb = new StringBuilder();
                this.generateGroups(sb, className, groups, fieldPrecedenceModel, "    ");
                out.append(sb);
                out.append(this.generateVarData(fieldPrecedenceModel, varData, TWO_INDENT));
                out.append(this.generateDisplay(Generators.toUpperFirstChar(msgToken.name()), fields, groups, varData, fieldPrecedenceModel));
                out.append("    }\n");
                out.append("}\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private void generateGroups(StringBuilder sb, String parentMessageClassName, List<Token> tokens, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            sb.append(this.generateGroupProperty(groupName, fieldPrecedenceModel, groupToken, indent + "    "));
            this.generateGroupClassHeader(sb, groupName, parentMessageClassName, tokens, fieldPrecedenceModel, i, indent + "    ");
            ++i;
            i += tokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            sb.append(this.generateFields(fieldPrecedenceModel, fields, indent + "    "));
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateGroups(sb, parentMessageClassName, groups, fieldPrecedenceModel, indent + "    ");
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            sb.append(this.generateVarData(fieldPrecedenceModel, varData, indent + "    " + "    "));
            this.appendGroupInstanceDisplay(sb, fields, groups, varData, indent + TWO_INDENT);
            sb.append(indent).append("    }\n");
        }
    }

    private void generateGroupClassHeader(StringBuilder sb, String groupName, String parentMessageClassName, List<Token> tokens, FieldPrecedenceModel fieldPrecedenceModel, int index, String indent) {
        String dimensionsClassName = CSharpUtil.formatClassName(tokens.get(index + 1).name());
        int dimensionHeaderLength = tokens.get(index + 1).encodedLength();
        sb.append(String.format("\n%1$s" + indent + "public sealed partial class %2$sGroup\n" + indent + "{\n" + indent + "    " + "private readonly %3$s _dimensions = new %3$s();\n" + indent + "    " + "private %4$s _parentMessage;\n" + indent + "    " + "private DirectBuffer _buffer;\n" + indent + "    " + "private int _blockLength;\n" + indent + "    " + "private int _actingVersion;\n" + indent + "    " + "private int _count;\n" + indent + "    " + "private int _index;\n" + indent + "    " + "private int _offset;\n", CSharpGenerator.generateDocumentation(indent, tokens.get(index)), CSharpUtil.formatClassName(groupName), dimensionsClassName, parentMessageClassName));
        Token numInGroupToken = Generators.findFirst("numInGroup", tokens, index);
        boolean isIntCastSafe = this.isRepresentableByInt32(numInGroupToken.encoding());
        if (!isIntCastSafe) {
            throw new IllegalArgumentException(String.format("%s.numInGroup - cannot be represented safely by an int. Please constrain the maxValue.", groupName));
        }
        sb.append("\n").append(indent).append("    ").append("internal void NotPresent()\n").append(indent).append("    ").append("{\n").append(indent).append(TWO_INDENT).append("_count = 0;\n").append(indent).append(TWO_INDENT).append("_index = 0;\n").append(indent).append(TWO_INDENT).append("_buffer = null;\n").append(indent).append(TWO_INDENT).append("_offset = 0;\n").append(indent).append("    ").append("}\n");
        sb.append(String.format("\n" + indent + "    " + "public void WrapForDecode(%s parentMessage, DirectBuffer buffer, int actingVersion)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "_parentMessage = parentMessage;\n" + indent + "    " + "    " + "_buffer = buffer;\n" + indent + "    " + "    " + "_dimensions.Wrap(buffer, parentMessage.Limit, actingVersion);\n" + indent + "    " + "    " + "_parentMessage.Limit = parentMessage.Limit + SbeHeaderSize;\n" + indent + "    " + "    " + "_blockLength = _dimensions.BlockLength;\n" + indent + "    " + "    " + "_count = (int) _dimensions.NumInGroup;\n" + indent + "    " + "    " + "_actingVersion = actingVersion;\n" + indent + "    " + "    " + "_index = 0;\n" + indent + "    " + "}\n", parentMessageClassName));
        int blockLength = tokens.get(index).encodedLength();
        String typeForBlockLength = CSharpUtil.cSharpTypeName(tokens.get(index + 2).encoding().primitiveType());
        String typeForNumInGroup = CSharpUtil.cSharpTypeName(numInGroupToken.encoding().primitiveType());
        String throwCondition = numInGroupToken.encoding().applicableMinValue().longValue() == 0L ? "if ((uint) count > %3$d)\n" : "if (count < %2$d || count > %3$d)\n";
        sb.append(String.format("\n" + indent + "    " + "public void WrapForEncode(%1$s parentMessage, DirectBuffer buffer, int count)\n" + indent + "    " + "{\n" + indent + "    " + "    " + throwCondition + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "ThrowHelper.ThrowCountOutOfRangeException(count);\n" + indent + "    " + "    " + "}\n\n" + indent + "    " + "    " + "_parentMessage = parentMessage;\n" + indent + "    " + "    " + "_buffer = buffer;\n" + indent + "    " + "    " + "_dimensions.Wrap(buffer, parentMessage.Limit, SchemaVersion);\n" + indent + "    " + "    " + "parentMessage.Limit = parentMessage.Limit + SbeHeaderSize;\n" + indent + "    " + "    " + "_dimensions.BlockLength = SbeBlockLength;\n" + indent + "    " + "    " + "_dimensions.NumInGroup = (%5$s) count;\n" + indent + "    " + "    " + "_index = 0;\n" + indent + "    " + "    " + "_count = count;\n" + indent + "    " + "    " + "_blockLength = SbeBlockLength;\n" + indent + "    " + "    " + "_actingVersion = SchemaVersion;\n" + indent + "    " + "}\n", parentMessageClassName, numInGroupToken.encoding().applicableMinValue().longValue(), numInGroupToken.encoding().applicableMaxValue().longValue(), typeForBlockLength, typeForNumInGroup));
        sb.append(String.format("\n" + indent + "    " + "public const int SbeBlockLength = %d;\n" + indent + "    " + "public const int SbeHeaderSize = %d;\n", blockLength, dimensionHeaderLength));
        if (null != fieldPrecedenceModel) {
            sb.append("\n").append(indent).append("    private CodecState codecState()\n").append(indent).append("    {\n").append(indent).append("        return _parentMessage.codecState();\n").append(indent).append("    }\n");
            sb.append("\n").append(indent).append("    private void codecState(CodecState newState)\n").append(indent).append("    {\n").append(indent).append("        _parentMessage.codecState(newState);\n").append(indent).append("    }\n");
        }
        Token groupToken = tokens.get(index);
        this.generateGroupEnumerator(sb, fieldPrecedenceModel, groupToken, groupName, typeForNumInGroup, indent);
    }

    private void generateGroupEnumerator(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, Token groupToken, String groupName, String typeForNumInGroup, String indent) {
        CSharpGenerator.generateAccessOrderListenerMethodForNextGroupElement(sb, fieldPrecedenceModel, indent + "    ", groupToken);
        CSharpGenerator.generateAccessOrderListenerMethodForResetGroupCount(sb, fieldPrecedenceModel, indent + "    ", groupToken);
        sb.append(indent + "    " + "public int ActingBlockLength { get { return _blockLength; } }\n\n" + indent + "    " + "public int Count { get { return _count; } }\n\n" + indent + "    " + "public bool HasNext { get { return _index < _count; } }\n\n");
        sb.append(String.format("\n" + indent + "    " + "public int ResetCountToIndex()\n" + indent + "    " + "{\n%s" + indent + "    " + "    " + "_count = _index;\n" + indent + "    " + "    " + "_dimensions.NumInGroup = (%s) _count;\n\n" + indent + "    " + "    " + "return _count;\n" + indent + "    " + "}\n", this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + TWO_INDENT, "OnResetCountToIndex", new String[0]), typeForNumInGroup));
        sb.append(String.format("\n" + indent + "    " + "public %sGroup Next()\n" + indent + "    " + "{\n" + indent + "    " + "    " + "if (_index >= _count)\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "ThrowHelper.ThrowInvalidOperationException();\n" + indent + "    " + "    " + "}\n\n" + this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + TWO_INDENT, "OnNextElementAccessed", new String[0]) + indent + "    " + "    " + "_offset = _parentMessage.Limit;\n" + indent + "    " + "    " + "_parentMessage.Limit = _offset + _blockLength;\n" + indent + "    " + "    " + "++_index;\n\n" + indent + "    " + "    " + "return this;\n" + indent + "    " + "}\n", CSharpUtil.formatClassName(groupName)));
        sb.append("\n" + indent + "    " + "public System.Collections.IEnumerator GetEnumerator()\n" + indent + "    " + "{\n" + indent + "    " + "    " + "while (this.HasNext)\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "yield return this.Next();\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n");
    }

    private boolean isRepresentableByInt32(Encoding encoding) {
        return encoding.applicableMinValue().longValue() >= Integer.MIN_VALUE && encoding.applicableMaxValue().longValue() <= Integer.MAX_VALUE;
    }

    private CharSequence generateGroupProperty(String groupName, FieldPrecedenceModel fieldPrecedenceModel, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String className = CSharpUtil.formatClassName(groupName);
        sb.append(String.format("\n" + indent + "private readonly %sGroup _%s = new %sGroup();\n", className, Generators.toLowerFirstChar(groupName), className));
        sb.append(String.format("\n" + indent + "public const long %sId = %d;\n", Generators.toUpperFirstChar(groupName), token.id()));
        CSharpGenerator.generateAccessOrderListenerMethodForGroupWrap(sb, fieldPrecedenceModel, indent, token);
        this.generateSinceActingDeprecated(sb, indent, Generators.toUpperFirstChar(groupName), token);
        String groupField = "_" + Generators.toLowerFirstChar(groupName);
        CharSequence accessOrderListenerCallOnDecode = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + TWO_INDENT, token, groupField + ".Count", "\"decode\"");
        sb.append(String.format("\n%1$s" + indent + "public %2$sGroup %3$s\n" + indent + "{\n" + indent + "    " + "get\n" + indent + "    " + "{\n%5$s" + indent + "    " + "    " + "_%4$s.WrapForDecode(_parentMessage, _buffer, _actingVersion);\n%6$s" + indent + "    " + "    " + "return _%4$s;\n" + indent + "    " + "}\n" + indent + "}\n", CSharpGenerator.generateDocumentation(indent, token), className, Generators.toUpperFirstChar(groupName), Generators.toLowerFirstChar(groupName), this.generateGroupNotPresentCondition(token.version(), indent + "    " + "    ", groupField), accessOrderListenerCallOnDecode));
        CharSequence accessOrderListenerCallOnEncode = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "    ", token, "count", "\"encode\"");
        sb.append(String.format("\n" + indent + "public %1$sGroup %2$sCount(int count)\n" + indent + "{\n%4$s" + indent + "    " + "_%3$s.WrapForEncode(_parentMessage, _buffer, count);\n" + indent + "    " + "return _%3$s;\n" + indent + "}\n", className, Generators.toUpperFirstChar(groupName), Generators.toLowerFirstChar(groupName), accessOrderListenerCallOnEncode));
        return sb;
    }

    private CharSequence generateVarData(FieldPrecedenceModel fieldPrecedenceModel, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            this.generateFieldIdMethod(sb, token, indent);
            this.generateSinceActingDeprecated(sb, indent, CSharpUtil.formatPropertyName(token.name()), token);
            this.generateOffsetMethod(sb, token, indent);
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            this.generateCharacterEncodingMethod(sb, token.name(), characterEncoding, indent);
            this.generateFieldMetaAttributeMethod(sb, token, indent);
            String propertyName = Generators.toUpperFirstChar(token.name());
            Token lengthToken = Generators.findFirst("length", tokens, i);
            int sizeOfLengthField = lengthToken.encodedLength();
            Encoding lengthEncoding = lengthToken.encoding();
            String lengthCSharpType = CSharpUtil.cSharpTypeName(lengthEncoding.primitiveType());
            String lengthTypePrefix = Generators.toUpperFirstChar(lengthEncoding.primitiveType().primitiveName());
            ByteOrder byteOrder = lengthEncoding.byteOrder();
            String byteOrderStr = this.generateByteOrder(byteOrder, lengthEncoding.primitiveType().size());
            CSharpGenerator.generateAccessOrderListenerMethodForVarDataLength(sb, fieldPrecedenceModel, indent, token);
            CSharpGenerator.generateAccessOrderListenerMethod(sb, fieldPrecedenceModel, indent, token);
            sb.append(String.format("\n" + indent + "public const int %sHeaderSize = %d;\n", propertyName, sizeOfLengthField));
            CharSequence lengthAccessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "    ", CSharpGenerator.accessOrderListenerMethodName(token, "Length"), new String[0]);
            sb.append(String.format(indent + "\n" + indent + "public int %1$sLength()\n" + indent + "{\n%5$s%6$s" + indent + "    " + "_buffer.CheckLimit(_parentMessage.Limit + %2$d);\n" + indent + "    " + "return (int)_buffer.%3$sGet%4$s(_parentMessage.Limit);\n" + indent + "}\n", propertyName, sizeOfLengthField, lengthTypePrefix, byteOrderStr, this.generateArrayFieldNotPresentCondition(token.version(), indent, "0"), lengthAccessOrderListenerCall));
            CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "    ", token, new String[0]);
            sb.append(String.format("\n" + indent + "public int Get%1$s(byte[] dst, int dstOffset, int length) =>\n" + indent + "    " + "Get%1$s(new Span<byte>(dst, dstOffset, length));\n", propertyName));
            sb.append(String.format("\n" + indent + "public int Get%1$s(Span<byte> dst)\n" + indent + "{\n%2$s%6$s" + indent + "    " + "const int sizeOfLengthField = %3$d;\n" + indent + "    " + "int limit = _parentMessage.Limit;\n" + indent + "    " + "_buffer.CheckLimit(limit + sizeOfLengthField);\n" + indent + "    " + "int dataLength = (int)_buffer.%4$sGet%5$s(limit);\n" + indent + "    " + "int bytesCopied = Math.Min(dst.Length, dataLength);\n" + indent + "    " + "_parentMessage.Limit = limit + sizeOfLengthField + dataLength;\n" + indent + "    " + "_buffer.GetBytes(limit + sizeOfLengthField, dst.Slice(0, bytesCopied));\n\n" + indent + "    " + "return bytesCopied;\n" + indent + "}\n", propertyName, this.generateArrayFieldNotPresentCondition(token.version(), indent, "0"), sizeOfLengthField, lengthTypePrefix, byteOrderStr, accessOrderListenerCall));
            sb.append(String.format(indent + "\n" + indent + "// Allocates and returns a new byte array\n" + indent + "public byte[] Get%1$sBytes()\n" + indent + "{\n%5$s%6$s" + indent + "    " + "const int sizeOfLengthField = %2$d;\n" + indent + "    " + "int limit = _parentMessage.Limit;\n" + indent + "    " + "_buffer.CheckLimit(limit + sizeOfLengthField);\n" + indent + "    " + "int dataLength = (int)_buffer.%3$sGet%4$s(limit);\n" + indent + "    " + "byte[] data = new byte[dataLength];\n" + indent + "    " + "_parentMessage.Limit = limit + sizeOfLengthField + dataLength;\n" + indent + "    " + "_buffer.GetBytes(limit + sizeOfLengthField, data);\n\n" + indent + "    " + "return data;\n" + indent + "}\n", propertyName, sizeOfLengthField, lengthTypePrefix, byteOrderStr, this.generateArrayFieldNotPresentCondition(token.version(), indent, "new byte[0]"), accessOrderListenerCall));
            sb.append(String.format("\n" + indent + "public int Set%1$s(byte[] src, int srcOffset, int length) =>\n" + indent + "    " + "Set%1$s(new ReadOnlySpan<byte>(src, srcOffset, length));\n", propertyName));
            sb.append(String.format("\n" + indent + "public int Set%1$s(ReadOnlySpan<byte> src)\n" + indent + "{\n%6$s" + indent + "    " + "const int sizeOfLengthField = %2$d;\n" + indent + "    " + "int limit = _parentMessage.Limit;\n" + indent + "    " + "_parentMessage.Limit = limit + sizeOfLengthField + src.Length;\n" + indent + "    " + "_buffer.%3$sPut%5$s(limit, (%4$s)src.Length);\n" + indent + "    " + "_buffer.SetBytes(limit + sizeOfLengthField, src);\n\n" + indent + "    " + "return src.Length;\n" + indent + "}\n", propertyName, sizeOfLengthField, lengthTypePrefix, lengthCSharpType, byteOrderStr, accessOrderListenerCall));
            if (characterEncoding == null) continue;
            sb.append(System.lineSeparator()).append(String.format(indent + "public string Get%1$s()\n" + indent + "{\n%6$s%7$s" + indent + "    " + "const int sizeOfLengthField = %2$d;\n" + indent + "    " + "int limit = _parentMessage.Limit;\n" + indent + "    " + "_buffer.CheckLimit(limit + sizeOfLengthField);\n" + indent + "    " + "int dataLength = (int)_buffer.%3$sGet%4$s(limit);\n" + indent + "    " + "_parentMessage.Limit = limit + sizeOfLengthField + dataLength;\n" + indent + "    " + "return _buffer.GetStringFromBytes(%1$sResolvedCharacterEncoding, limit + sizeOfLengthField, dataLength);\n" + indent + "}\n\n" + indent + "public void Set%1$s(string value)\n" + indent + "{\n%7$s" + indent + "    " + "var encoding = %1$sResolvedCharacterEncoding;\n" + indent + "    " + "const int sizeOfLengthField = %2$d;\n" + indent + "    " + "int limit = _parentMessage.Limit;\n" + indent + "    " + "int byteCount = _buffer.SetBytesFromString(encoding, value, limit + sizeOfLengthField);\n" + indent + "    " + "_parentMessage.Limit = limit + sizeOfLengthField + byteCount;\n" + indent + "    " + "_buffer.%3$sPut%4$s(limit, (%5$s)byteCount);\n" + indent + "}\n", propertyName, sizeOfLengthField, lengthTypePrefix, byteOrderStr, lengthCSharpType, this.generateArrayFieldNotPresentCondition(token.version(), indent, "\"\""), accessOrderListenerCall));
        }
        return sb;
    }

    private void generateBitSet(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = CSharpUtil.formatClassName(enumToken.applicableTypeName());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(CSharpGenerator.generateDocumentation("    ", enumToken));
            String enumPrimitiveType = CSharpUtil.cSharpTypeName(enumToken.encoding().primitiveType());
            out.append(this.generateEnumDeclaration(enumName, enumPrimitiveType, true));
            out.append(this.generateChoices(tokens.subList(1, tokens.size() - 1)));
            out.append("    }\n");
            out.append(this.generateChoiceDisplay(enumName));
            out.append("}\n");
        }
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = CSharpUtil.formatClassName(enumToken.applicableTypeName());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(CSharpGenerator.generateDocumentation("    ", enumToken));
            String enumPrimitiveType = CSharpUtil.cSharpTypeName(enumToken.encoding().primitiveType());
            out.append(this.generateEnumDeclaration(enumName, enumPrimitiveType, false));
            out.append(this.generateEnumValues(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append("    }\n");
            out.append("}\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String compositeName = CSharpUtil.formatClassName(tokens.get(0).applicableTypeName());
        try (Writer out = this.outputManager.createOutput(compositeName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(CSharpGenerator.generateDocumentation("    ", tokens.get(0)));
            out.append(this.generateClassDeclaration(compositeName));
            out.append(this.generateFixedFlyweightCode(tokens.get(0).encodedLength()));
            out.append(this.generateCompositePropertyElements(tokens.subList(1, tokens.size() - 1), "    "));
            out.append(this.generateCompositeDisplay(tokens));
            out.append("    }\n");
            out.append("}\n");
        }
    }

    private CharSequence generateCompositePropertyElements(List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            String propertyName = CSharpUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(propertyName, token, token, null, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(propertyName, token, token, null, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitSetProperty(propertyName, token, token, null, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, token, token, null, indent));
                    continue block6;
                }
            }
        }
        return sb;
    }

    private CharSequence generateChoices(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String choiceName = Generators.toUpperFirstChar(token.applicableTypeName());
            String choiceBitPosition = token.encoding().constValue().toString();
            int choiceValue = (int)Math.pow(2.0, Integer.parseInt(choiceBitPosition));
            sb.append(String.format("        %s = %s,\n", choiceName, choiceValue));
        }
        return sb;
    }

    private CharSequence generateEnumValues(List<Token> tokens, Token encodingToken) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = encodingToken.encoding();
        for (Token token : tokens) {
            sb.append(CSharpGenerator.generateDocumentation(TWO_INDENT, token)).append("    ").append("    ").append(token.name()).append(" = ").append(token.encoding().constValue()).append(",\n");
        }
        PrimitiveValue nullVal = encoding.applicableNullValue();
        sb.append("    ").append("    ").append("NULL_VALUE = ").append(nullVal).append("\n");
        return sb;
    }

    private CharSequence generateFileHeader(String packageName) {
        String[] tokens = packageName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String t : tokens) {
            sb.append(Generators.toUpperFirstChar(t)).append(".");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        tokens = sb.toString().split("-");
        sb.setLength(0);
        for (String t : tokens) {
            sb.append(Generators.toUpperFirstChar(t));
        }
        return String.format("// <auto-generated>\n//     Generated SBE (Simple Binary Encoding) message codec\n// </auto-generated>\n\n#pragma warning disable 1591 // disable warning on missing comments\nusing System;\nusing System.Text;\nusing Org.SbeTool.Sbe.Dll;\n\nnamespace %s\n{\n", sb);
    }

    private CharSequence generateClassDeclaration(String className) {
        return String.format("    public sealed partial class %s\n    {\n", className);
    }

    private static String generateDocumentation(String indent, Token token) {
        String description = token.description();
        if (null == description || description.isEmpty()) {
            return "";
        }
        return indent + "/// <summary>\n" + indent + "/// " + description + "\n" + indent + "/// </summary>\n";
    }

    private void generateMetaAttributeEnum() throws IOException {
        try (Writer out = this.outputManager.createOutput(META_ATTRIBUTE_ENUM);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append("    public enum MetaAttribute\n    {\n        Epoch,\n        TimeUnit,\n        SemanticType,\n        Presence\n    }\n}\n");
        }
    }

    private CharSequence generateEnumDeclaration(String name, String primitiveType, boolean addFlagsAttribute) {
        String result = "";
        if (addFlagsAttribute) {
            result = result + "    [Flags]\n";
        }
        result = result + "    public enum " + name + " : " + primitiveType + "\n" + "    " + "{\n";
        return result;
    }

    private CharSequence generatePrimitiveProperty(String propertyName, Token fieldToken, Token typeToken, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatePrimitiveFieldMetaData(propertyName, typeToken, indent + "    "));
        if (typeToken.isConstantEncoding()) {
            sb.append(this.generateConstPropertyMethods(propertyName, typeToken, indent));
        } else {
            sb.append(this.generatePrimitivePropertyMethods(propertyName, fieldToken, typeToken, fieldPrecedenceModel, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitivePropertyMethods(String propertyName, Token fieldToken, Token typeToken, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        int arrayLength = typeToken.arrayLength();
        if (arrayLength == 1) {
            return this.generateSingleValueProperty(propertyName, fieldToken, typeToken, fieldPrecedenceModel, indent + "    ");
        }
        if (arrayLength > 1) {
            return this.generateArrayProperty(propertyName, fieldToken, typeToken, fieldPrecedenceModel, indent + "    ");
        }
        return "";
    }

    private CharSequence generatePrimitiveFieldMetaData(String propertyName, Token token, String indent) {
        PrimitiveType primitiveType = token.encoding().primitiveType();
        String typeName = CSharpUtil.cSharpTypeName(primitiveType);
        return String.format("\n" + indent + "public const %1$s %2$sNullValue = %3$s;\n" + indent + "public const %1$s %2$sMinValue = %4$s;\n" + indent + "public const %1$s %2$sMaxValue = %5$s;\n", typeName, Generators.toUpperFirstChar(propertyName), this.generateLiteral(primitiveType, token.encoding().applicableNullValue().toString()), this.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString()), this.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString()));
    }

    private CharSequence generateSingleValueProperty(String propertyName, Token fieldToken, Token typeToken, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        String typeName = CSharpUtil.cSharpTypeName(typeToken.encoding().primitiveType());
        String typePrefix = Generators.toUpperFirstChar(typeToken.encoding().primitiveType().primitiveName());
        int offset = typeToken.offset();
        ByteOrder byteOrder = typeToken.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, typeToken.encoding().primitiveType().size());
        CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + TWO_INDENT, fieldToken, new String[0]);
        return String.format("\n%1$s" + indent + "public %2$s %3$s\n" + indent + "{\n" + indent + "    " + "get\n" + indent + "    " + "{\n%4$s%8$s" + indent + "    " + "    " + "return _buffer.%5$sGet%7$s(_offset + %6$d);\n" + indent + "    " + "}\n" + indent + "    " + "set\n" + indent + "    " + "{\n%8$s" + indent + "    " + "    " + "_buffer.%5$sPut%7$s(_offset + %6$d, value);\n" + indent + "    " + "}\n" + indent + "}\n\n", CSharpGenerator.generateDocumentation(indent, fieldToken), typeName, Generators.toUpperFirstChar(propertyName), this.generateFieldNotPresentCondition(fieldToken.version(), typeToken.encoding(), indent), typePrefix, offset, byteOrderStr, accessOrderListenerCall);
    }

    private CharSequence generateFieldNotPresentCondition(int sinceVersion, Encoding encoding, String indent) {
        if (0 == sinceVersion) {
            return "";
        }
        String literal = sinceVersion > 0 ? this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()) : "(byte)0";
        return String.format(indent + "    " + "    " + "if (_actingVersion < %1$d) return %2$s;\n\n", sinceVersion, literal);
    }

    private CharSequence generateGroupNotPresentCondition(int sinceVersion, String indent, String groupInstanceField) {
        if (0 == sinceVersion) {
            return "";
        }
        return indent + "if (_actingVersion < " + sinceVersion + ")" + indent + "{\n" + indent + "    " + groupInstanceField + ".NotPresent();\n" + indent + "    " + "return " + groupInstanceField + ";\n" + indent + "}\n\n";
    }

    private CharSequence generateArrayFieldNotPresentCondition(int sinceVersion, String indent, String defaultValue) {
        if (0 == sinceVersion) {
            return "";
        }
        return indent + "    " + "if (_actingVersion < " + sinceVersion + ") return " + defaultValue + ";\n\n";
    }

    private CharSequence generateBitSetNotPresentCondition(int sinceVersion, String indent, String bitSetName) {
        if (0 == sinceVersion) {
            return "";
        }
        return String.format(indent + "    " + "    " + "    " + "if (_actingVersion < %1$d) return (%2$s)0;\n\n", sinceVersion, bitSetName);
    }

    private CharSequence generateTypeFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return "";
        }
        return String.format(indent + "    " + "    " + "if (_actingVersion < %d) return null;\n\n", sinceVersion);
    }

    private CharSequence generateArrayProperty(String propertyName, Token fieldToken, Token typeToken, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        String typeName = CSharpUtil.cSharpTypeName(typeToken.encoding().primitiveType());
        String typePrefix = Generators.toUpperFirstChar(typeToken.encoding().primitiveType().primitiveName());
        int offset = typeToken.offset();
        ByteOrder byteOrder = typeToken.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, typeToken.encoding().primitiveType().size());
        int fieldLength = typeToken.arrayLength();
        int typeSize = typeToken.encoding().primitiveType().size();
        String propName = Generators.toUpperFirstChar(propertyName);
        CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + "    ", fieldToken, new String[0]);
        CharSequence accessOrderListenerCallDoubleIndent = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + TWO_INDENT, fieldToken, new String[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "public const int %sLength = %d;\n", propName, fieldLength));
        sb.append(String.format("\n%1$s" + indent + "public %2$s Get%3$s(int index)\n" + indent + "{\n" + indent + "    " + "if ((uint) index >= %4$d)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "ThrowHelper.ThrowIndexOutOfRangeException(index);\n" + indent + "    " + "}\n\n%5$s%10$s" + indent + "    " + "return _buffer.%6$sGet%9$s(_offset + %7$d + (index * %8$d));\n" + indent + "}\n", CSharpGenerator.generateDocumentation(indent, fieldToken), typeName, propName, fieldLength, this.generateFieldNotPresentCondition(fieldToken.version(), typeToken.encoding(), indent), typePrefix, offset, typeSize, byteOrderStr, accessOrderListenerCall));
        sb.append(String.format("\n%1$s" + indent + "public void Set%2$s(int index, %3$s value)\n" + indent + "{\n" + indent + "    " + "if ((uint) index >= %4$d)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "ThrowHelper.ThrowIndexOutOfRangeException(index);\n" + indent + "    " + "}\n\n%9$s" + indent + "    " + "_buffer.%5$sPut%8$s(_offset + %6$d + (index * %7$d), value);\n" + indent + "}\n", CSharpGenerator.generateDocumentation(indent, fieldToken), propName, typeName, fieldLength, typePrefix, offset, typeSize, byteOrderStr, accessOrderListenerCall));
        sb.append(String.format("\n%1$s" + indent + "public ReadOnlySpan<%2$s> %3$s\n" + indent + "{\n" + indent + "    " + "get\n" + indent + "    " + "{\n%5$s%6$s" + indent + "    " + "    " + "return _buffer.AsReadOnlySpan<%2$s>(_offset + %4$s, %3$sLength);\n" + indent + "    " + "}\n" + indent + "    " + "set\n" + indent + "    " + "{\n%6$s" + indent + "    " + "    " + "value.CopyTo(_buffer.AsSpan<%2$s>(_offset + %4$s, %3$sLength));\n" + indent + "    " + "}\n" + indent + "}\n", CSharpGenerator.generateDocumentation(indent, fieldToken), typeName, propName, offset, this.generateArrayFieldNotPresentCondition(fieldToken.version(), indent + "    " + "    ", "new " + typeName + "[0]"), accessOrderListenerCallDoubleIndent));
        sb.append(String.format("\n%1$s" + indent + "public Span<%2$s> %3$sAsSpan()\n" + indent + "{\n%5$s%6$s" + indent + "    " + "return _buffer.AsSpan<%2$s>(_offset + %4$s, %3$sLength);\n" + indent + "}\n", CSharpGenerator.generateDocumentation(indent, fieldToken), typeName, propName, offset, this.generateArrayFieldNotPresentCondition(fieldToken.version(), indent + "    " + "    ", "new " + typeName + "[0]"), accessOrderListenerCall));
        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
            this.generateCharacterEncodingMethod(sb, propertyName, typeToken.encoding().characterEncoding(), indent);
            sb.append(String.format("\n" + indent + "public int Get%1$s(byte[] dst, int dstOffset)\n" + indent + "{\n" + indent + "    " + "const int length = %2$d;\n%3$s%4$s" + indent + "    " + "return Get%1$s(new Span<byte>(dst, dstOffset, length));\n" + indent + "}\n", propName, fieldLength, this.generateArrayFieldNotPresentCondition(fieldToken.version(), indent, "0"), accessOrderListenerCall));
            sb.append(String.format("\n" + indent + "public int Get%1$s(Span<byte> dst)\n" + indent + "{\n" + indent + "    " + "const int length = %2$d;\n" + indent + "    " + "if (dst.Length < length)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "ThrowHelper.ThrowWhenSpanLengthTooSmall(dst.Length);\n" + indent + "    " + "}\n\n%3$s%5$s" + indent + "    " + "_buffer.GetBytes(_offset + %4$d, dst);\n" + indent + "    " + "return length;\n" + indent + "}\n", propName, fieldLength, this.generateArrayFieldNotPresentCondition(fieldToken.version(), indent, "0"), offset, accessOrderListenerCall));
            sb.append(String.format("\n" + indent + "public void Set%1$s(byte[] src, int srcOffset)\n" + indent + "{\n" + indent + "    " + "Set%1$s(new ReadOnlySpan<byte>(src, srcOffset, src.Length - srcOffset));\n" + indent + "}\n", propName, fieldLength, offset));
            sb.append(String.format("\n" + indent + "public void Set%1$s(ReadOnlySpan<byte> src)\n" + indent + "{\n" + indent + "    " + "const int length = %2$d;\n" + indent + "    " + "if (src.Length > length)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "ThrowHelper.ThrowWhenSpanLengthTooLarge(src.Length);\n" + indent + "    " + "}\n\n%4$s" + indent + "    " + "_buffer.SetBytes(_offset + %3$d, src);\n" + indent + "}\n", propName, fieldLength, offset, accessOrderListenerCall));
            sb.append(String.format("\n" + indent + "public void Set%1$s(string value)\n" + indent + "{\n%3$s" + indent + "    " + "_buffer.SetNullTerminatedBytesFromString(%1$sResolvedCharacterEncoding, value, _offset + %2$s, %1$sLength, %1$sNullValue);\n" + indent + "}\n" + indent + "public string Get%1$s()\n" + indent + "{\n%3$s" + indent + "    " + "return _buffer.GetStringFromNullTerminatedBytes(%1$sResolvedCharacterEncoding, _offset + %2$s, %1$sLength, %1$sNullValue);\n" + indent + "}\n", propName, offset, accessOrderListenerCall));
        }
        return sb;
    }

    private void generateCharacterEncodingMethod(StringBuilder sb, String propertyName, String encoding, String indent) {
        if (encoding != null) {
            sb.append(String.format("\n" + indent + "public const string %1$sCharacterEncoding = \"%2$s\";\n" + indent + "public static Encoding %1$sResolvedCharacterEncoding = Encoding.GetEncoding(%1$sCharacterEncoding);\n\n", CSharpUtil.formatPropertyName(propertyName), encoding));
        }
    }

    private CharSequence generateConstPropertyMethods(String propertyName, Token token, String indent) {
        if (token.encoding().primitiveType() != PrimitiveType.CHAR) {
            return String.format("\n%1s" + indent + "    " + "public %2$s %3$s { get { return %4$s; } }\n", CSharpGenerator.generateDocumentation(indent + "    ", token), CSharpUtil.cSharpTypeName(token.encoding().primitiveType()), Generators.toUpperFirstChar(propertyName), this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString()));
        }
        StringBuilder sb = new StringBuilder();
        String javaTypeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        byte[] constantValue = token.encoding().constValue().byteArrayValue(token.encoding().primitiveType());
        CharSequence values = this.generateByteLiteralList(token.encoding().constValue().byteArrayValue(token.encoding().primitiveType()));
        sb.append(String.format("\n" + indent + "    " + "private static readonly byte[] _%1$sValue = { %2$s };\n", propertyName, values));
        sb.append(String.format("\n" + indent + "    " + "public const int %1$sLength = %2$d;\n", Generators.toUpperFirstChar(propertyName), constantValue.length));
        sb.append(String.format(indent + "    " + "public %1$s %2$s(int index)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "return _%3$sValue[index];\n" + indent + "    " + "}\n\n", javaTypeName, Generators.toUpperFirstChar(propertyName), propertyName));
        sb.append(String.format(indent + "    " + "public int Get%1$s(byte[] dst, int offset, int length)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "int bytesCopied = Math.Min(length, %2$d);\n" + indent + "    " + "    " + "Array.Copy(_%3$sValue, 0, dst, offset, bytesCopied);\n" + indent + "    " + "    " + "return bytesCopied;\n" + indent + "    " + "}\n", Generators.toUpperFirstChar(propertyName), constantValue.length, propertyName));
        return sb;
    }

    private CharSequence generateByteLiteralList(byte[] bytes) {
        StringBuilder values = new StringBuilder();
        for (byte b : bytes) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        return values;
    }

    private CharSequence generateFixedFlyweightCode(int size) {
        return String.format("        public const %1$s SbeSchemaId = %2$s;\n        public const %3$s SbeSchemaVersion = %4$s;\n        public const int Size = %5$d;\n\n        private DirectBuffer _buffer;\n        private int _offset;\n        private int _actingVersion;\n\n        public void Wrap(DirectBuffer buffer, int offset, int actingVersion)\n        {\n            _offset = offset;\n            _actingVersion = actingVersion;\n            _buffer = buffer;\n        }\n\n", CSharpUtil.cSharpTypeName(this.ir.headerStructure().schemaIdType()), this.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), CSharpUtil.cSharpTypeName(this.ir.headerStructure().schemaVersionType()), this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(this.ir.version())), size);
    }

    private CharSequence generateMessageFlyweightCode(String className, Token token, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        String blockLengthType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().blockLengthType());
        String templateIdType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().templateIdType());
        String schemaIdType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().schemaVersionType());
        String semanticType = token.encoding().semanticType() == null ? "" : token.encoding().semanticType();
        String semanticVersion = this.ir.semanticVersion() == null ? "" : this.ir.semanticVersion();
        return String.format(indent + "    " + "public const %1$s BlockLength = %2$s;\n" + indent + "    " + "public const %3$s TemplateId = %4$s;\n" + indent + "    " + "public const %5$s SchemaId = %6$s;\n" + indent + "    " + "public const %7$s SchemaVersion = %8$s;\n" + indent + "    " + "public const string SemanticType = \"%9$s\";\n" + indent + "    " + "public const string SemanticVersion = \"%11$s\";\n\n" + indent + "    " + "private readonly %10$s _parentMessage;\n" + indent + "    " + "private DirectBuffer _buffer;\n" + indent + "    " + "private int _offset;\n" + indent + "    " + "private int _limit;\n" + indent + "    " + "private int _actingBlockLength;\n" + indent + "    " + "private int _actingVersion;\n\n" + indent + "    " + "public int Offset { get { return _offset; } }\n\n" + indent + "    " + "public %10$s()\n" + indent + "    " + "{\n" + indent + "    " + "    " + "_parentMessage = this;\n" + indent + "    " + "}\n\n" + indent + "    " + "public %10$s WrapForEncode(DirectBuffer buffer, int offset)\n" + indent + "    " + "{\n%12$s" + indent + "    " + "    " + "_buffer = buffer;\n" + indent + "    " + "    " + "_offset = offset;\n" + indent + "    " + "    " + "_actingBlockLength = BlockLength;\n" + indent + "    " + "    " + "_actingVersion = SchemaVersion;\n" + indent + "    " + "    " + "Limit = offset + _actingBlockLength;\n" + indent + "    " + "    " + "return this;\n" + indent + "    " + "}\n\n" + indent + "    " + "public %10$s WrapForEncodeAndApplyHeader(DirectBuffer buffer, int offset, MessageHeader headerEncoder)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "headerEncoder.Wrap(buffer, offset, SchemaVersion);\n" + indent + "    " + "    " + "headerEncoder.BlockLength = BlockLength;\n" + indent + "    " + "    " + "headerEncoder.TemplateId = TemplateId;\n" + indent + "    " + "    " + "headerEncoder.SchemaId = SchemaId;\n" + indent + "    " + "    " + "headerEncoder.Version = SchemaVersion;\n" + indent + "    " + "    " + "\n" + indent + "    " + "    " + "return WrapForEncode(buffer, offset + MessageHeader.Size);\n" + indent + "    " + "}\n\n%13$s" + indent + "    " + "public %10$s WrapForDecode(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion)\n" + indent + "    " + "{\n%14$s" + indent + "    " + "    " + "_buffer = buffer;\n" + indent + "    " + "    " + "_offset = offset;\n" + indent + "    " + "    " + "_actingBlockLength = actingBlockLength;\n" + indent + "    " + "    " + "_actingVersion = actingVersion;\n" + indent + "    " + "    " + "Limit = offset + _actingBlockLength;\n" + indent + "    " + "    " + "return this;\n" + indent + "    " + "}\n\n" + indent + "    " + "public %10$s WrapForDecodeAndApplyHeader(DirectBuffer buffer, int offset, MessageHeader headerDecoder)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "headerDecoder.Wrap(buffer, offset, SchemaVersion);\n" + indent + "    " + "    " + "\n" + indent + "    " + "    " + "return WrapForDecode(buffer, offset + MessageHeader.Size,  headerDecoder.BlockLength, headerDecoder.Version);\n" + indent + "    " + "}\n\n" + indent + "    " + "public int Size\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "return _limit - _offset;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n\n" + indent + "    " + "public int Limit\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "return _limit;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "    " + "set\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "_buffer.CheckLimit(value);\n" + indent + "    " + "    " + "    " + "_limit = value;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n\n", blockLengthType, this.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.encodedLength())), templateIdType, this.generateLiteral(this.ir.headerStructure().templateIdType(), Integer.toString(token.id())), schemaIdType, this.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(this.ir.version())), semanticType, className, semanticVersion, this.generateEncoderWrapListener(fieldPrecedenceModel, indent + TWO_INDENT), CSharpGenerator.generateDecoderWrapListener(fieldPrecedenceModel, indent + "    "), this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + TWO_INDENT, "OnWrapForDecode", "actingVersion"));
    }

    private static CharSequence qualifiedStateCase(FieldPrecedenceModel.State state) {
        return "CodecState." + state.name();
    }

    private static CharSequence stateCaseForSwitchCase(FieldPrecedenceModel.State state) {
        return CSharpGenerator.qualifiedStateCase(state);
    }

    private static CharSequence unqualifiedStateCase(FieldPrecedenceModel.State state) {
        return state.name();
    }

    private static CharSequence generateFieldOrderStates(String indent, FieldPrecedenceModel fieldPrecedenceModel) {
        if (null == fieldPrecedenceModel) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("///\n");
        sb.append(indent).append("/// <summary>\n");
        sb.append(indent).append("///   <para>\n");
        sb.append(indent).append("///     The states in which a encoder/decoder/codec can live.\n");
        sb.append(indent).append("///   </para>\n");
        sb.append(indent).append("///   <para>\n");
        sb.append(indent).append("///     The state machine diagram below, encoded in the dot language, describes\n");
        sb.append(indent).append("///     the valid state transitions according to the order in which fields may be\n");
        sb.append(indent).append("///     accessed safely. Tools such as PlantUML and Graphviz can render it.\n");
        sb.append(indent).append("///   </para>\n");
        sb.append(indent).append("///   <code>\n");
        fieldPrecedenceModel.generateGraph(sb, indent + "///     ");
        sb.append(indent).append("///   </code>\n");
        sb.append(indent).append("/// </summary>\n");
        sb.append(indent).append("private enum CodecState\n").append(indent).append("{\n");
        fieldPrecedenceModel.forEachStateOrderedByStateNumber(state -> sb.append(indent).append("    ").append(CSharpGenerator.unqualifiedStateCase(state)).append(" = ").append(state.number()).append(",\n"));
        sb.append(indent).append("}\n\n");
        sb.append("\n").append(indent).append("private static readonly string[] StateNameLookup = new []\n").append(indent).append("{\n");
        fieldPrecedenceModel.forEachStateOrderedByStateNumber(state -> sb.append(indent).append("    ").append("\"").append(state.name()).append("\",\n"));
        sb.append(indent).append("};\n\n");
        sb.append(indent).append("private static readonly string[] StateTransitionsLookup = new []\n").append(indent).append("{\n");
        fieldPrecedenceModel.forEachStateOrderedByStateNumber(state -> {
            sb.append(indent).append("    ").append("\"");
            MutableBoolean isFirst = new MutableBoolean(true);
            HashSet transitionDescriptions = new HashSet();
            fieldPrecedenceModel.forEachTransitionFrom((FieldPrecedenceModel.State)state, transitionGroup -> {
                if (transitionDescriptions.add(transitionGroup.exampleCode())) {
                    if (isFirst.get()) {
                        isFirst.set(false);
                    } else {
                        sb.append(", ");
                    }
                    sb.append("\\\"").append(transitionGroup.exampleCode()).append("\\\"");
                }
            });
            sb.append("\",\n");
        });
        sb.append(indent).append("};\n\n");
        sb.append(indent).append("private static string codecStateName(CodecState state)\n").append(indent).append("{\n").append(indent).append("    ").append("return StateNameLookup[(int) state];\n").append(indent).append("}\n\n");
        sb.append(indent).append("private static string codecStateTransitions(CodecState state)\n").append(indent).append("{\n").append(indent).append("    ").append("return StateTransitionsLookup[(int) state];\n").append(indent).append("}\n\n");
        sb.append(indent).append("private CodecState _codecState = ").append(CSharpGenerator.qualifiedStateCase(fieldPrecedenceModel.notWrappedState())).append(";\n\n");
        sb.append(indent).append("private CodecState codecState()\n").append(indent).append("{\n").append(indent).append("    ").append("return _codecState;\n").append(indent).append("}\n\n");
        sb.append(indent).append("private void codecState(CodecState newState)\n").append(indent).append("{\n").append(indent).append("    ").append("_codecState = newState;\n").append(indent).append("}\n");
        return sb;
    }

    private CharSequence generateFullyEncodedCheck(String indent, FieldPrecedenceModel fieldPrecedenceModel) {
        if (null == fieldPrecedenceModel) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(indent).append("public void CheckEncodingIsComplete()\n").append(indent).append("{\n").append("#if ").append(this.precedenceChecksFlagName).append("\n").append(indent).append("    ").append("switch (_codecState)\n").append(indent).append("    ").append("{\n");
        fieldPrecedenceModel.forEachTerminalEncoderState(state -> sb.append(indent).append(TWO_INDENT).append("case ").append(CSharpGenerator.stateCaseForSwitchCase(state)).append(":\n").append(indent).append(THREE_INDENT).append("return;\n"));
        sb.append(indent).append(TWO_INDENT).append("default:\n").append(indent).append(THREE_INDENT).append("throw new InvalidOperationException(\"Not fully encoded, current state: \" +\n").append(indent).append(THREE_INDENT).append("    ").append("codecStateName(_codecState) + \", allowed transitions: \" +\n").append(indent).append(THREE_INDENT).append("    ").append("codecStateTransitions(_codecState));\n").append(indent).append("    ").append("}\n").append("#endif\n").append(indent).append("}\n\n");
        return sb;
    }

    private static String accessOrderListenerMethodName(Token token) {
        return "On" + Generators.toUpperFirstChar(token.name()) + "Accessed";
    }

    private static String accessOrderListenerMethodName(Token token, String suffix) {
        return "On" + Generators.toUpperFirstChar(token.name()) + suffix + "Accessed";
    }

    private static void generateAccessOrderListenerMethod(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append("\n").append(indent).append("private void ").append(CSharpGenerator.accessOrderListenerMethodName(token)).append("()\n").append(indent).append("{\n");
        FieldPrecedenceModel.CodecInteraction fieldAccess = fieldPrecedenceModel.interactionFactory().accessField(token);
        CSharpGenerator.generateAccessOrderListener(sb, indent + "    ", "access field", fieldPrecedenceModel, fieldAccess);
        sb.append(indent).append("}\n");
    }

    private CharSequence generateAccessOrderListenerCall(FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token, String ... arguments) {
        return this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent, CSharpGenerator.accessOrderListenerMethodName(token), arguments);
    }

    private CharSequence generateAccessOrderListenerCall(FieldPrecedenceModel fieldPrecedenceModel, String indent, String methodName, String ... arguments) {
        if (null == fieldPrecedenceModel) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#if ").append(this.precedenceChecksFlagName).append("\n").append(indent).append(methodName).append("(");
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(arguments[i]);
        }
        sb.append(");\n");
        sb.append("#endif\n");
        return sb;
    }

    private static void generateAccessOrderListenerMethodForGroupWrap(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append("\n").append(indent).append("private void ").append(CSharpGenerator.accessOrderListenerMethodName(token)).append("(int remaining, string action)\n").append(indent).append("{\n").append(indent).append("    ").append("if (remaining == 0)\n").append(indent).append("    ").append("{\n");
        FieldPrecedenceModel.CodecInteraction selectEmptyGroup = fieldPrecedenceModel.interactionFactory().determineGroupIsEmpty(token);
        CSharpGenerator.generateAccessOrderListener(sb, indent + TWO_INDENT, "\" + action + \" count of repeating group", fieldPrecedenceModel, selectEmptyGroup);
        sb.append(indent).append("    ").append("}\n").append(indent).append("    ").append("else\n").append(indent).append("    ").append("{\n");
        FieldPrecedenceModel.CodecInteraction selectNonEmptyGroup = fieldPrecedenceModel.interactionFactory().determineGroupHasElements(token);
        CSharpGenerator.generateAccessOrderListener(sb, indent + TWO_INDENT, "\" + action + \" count of repeating group", fieldPrecedenceModel, selectNonEmptyGroup);
        sb.append(indent).append("    ").append("}\n").append(indent).append("}\n");
    }

    private static void generateAccessOrderListener(StringBuilder sb, String indent, String action, FieldPrecedenceModel fieldPrecedenceModel, FieldPrecedenceModel.CodecInteraction interaction) {
        if (interaction.isTopLevelBlockFieldAccess()) {
            sb.append(indent).append("if (codecState() == ").append(CSharpGenerator.qualifiedStateCase(fieldPrecedenceModel.notWrappedState())).append(")\n").append(indent).append("{\n");
            CSharpGenerator.generateAccessOrderException(sb, indent + "    ", action, fieldPrecedenceModel, interaction);
            sb.append(indent).append("}\n");
        } else {
            sb.append(indent).append("switch (codecState())\n").append(indent).append("{\n");
            fieldPrecedenceModel.forEachTransition(interaction, transitionGroup -> {
                transitionGroup.forEachStartState(startState -> sb.append(indent).append("    ").append("case ").append(CSharpGenerator.stateCaseForSwitchCase(startState)).append(":\n"));
                sb.append(indent).append(TWO_INDENT).append("codecState(").append(CSharpGenerator.qualifiedStateCase(transitionGroup.endState())).append(");\n").append(indent).append(TWO_INDENT).append("break;\n");
            });
            sb.append(indent).append("    ").append("default:\n");
            CSharpGenerator.generateAccessOrderException(sb, indent + TWO_INDENT, action, fieldPrecedenceModel, interaction);
            sb.append(indent).append("}\n");
        }
    }

    private static void generateAccessOrderException(StringBuilder sb, String indent, String action, FieldPrecedenceModel fieldPrecedenceModel, FieldPrecedenceModel.CodecInteraction interaction) {
        sb.append(indent).append("throw new InvalidOperationException(").append("\"Illegal field access order. \" +\n").append(indent).append("    ").append("\"Cannot ").append(action).append(" \\\"").append(interaction.groupQualifiedName()).append("\\\" in state: \" + codecStateName(codecState()) +\n").append(indent).append("    ").append("\". Expected one of these transitions: [\" + codecStateTransitions(codecState()) +\n").append(indent).append("    ").append("\"]. Please see the diagram in the docs of the enum ").append(fieldPrecedenceModel.generatedRepresentationClassName()).append(".\");\n");
    }

    private static void generateAccessOrderListenerMethodForNextGroupElement(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append("\n");
        sb.append(indent).append("private void OnNextElementAccessed()\n").append(indent).append("{\n").append(indent).append("    ").append("int remaining = ").append("_count - _index").append(";\n").append(indent).append("    ").append("if (remaining > 1)\n").append(indent).append("    ").append("{\n");
        FieldPrecedenceModel.CodecInteraction selectNextElementInGroup = fieldPrecedenceModel.interactionFactory().moveToNextElement(token);
        CSharpGenerator.generateAccessOrderListener(sb, indent + TWO_INDENT, "access next element in repeating group", fieldPrecedenceModel, selectNextElementInGroup);
        sb.append(indent).append("    ").append("}\n").append(indent).append("    ").append("else if (remaining == 1)\n").append(indent).append("    ").append("{\n");
        FieldPrecedenceModel.CodecInteraction selectLastElementInGroup = fieldPrecedenceModel.interactionFactory().moveToLastElement(token);
        CSharpGenerator.generateAccessOrderListener(sb, indent + TWO_INDENT, "access next element in repeating group", fieldPrecedenceModel, selectLastElementInGroup);
        sb.append(indent).append("    ").append("}\n").append(indent).append("}\n");
    }

    private static void generateAccessOrderListenerMethodForResetGroupCount(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append(indent).append("private void OnResetCountToIndex()\n").append(indent).append("{\n");
        FieldPrecedenceModel.CodecInteraction resetCountToIndex = fieldPrecedenceModel.interactionFactory().resetCountToIndex(token);
        CSharpGenerator.generateAccessOrderListener(sb, indent + "   ", "reset count of repeating group", fieldPrecedenceModel, resetCountToIndex);
        sb.append(indent).append("}\n");
    }

    private static void generateAccessOrderListenerMethodForVarDataLength(StringBuilder sb, FieldPrecedenceModel fieldPrecedenceModel, String indent, Token token) {
        if (null == fieldPrecedenceModel) {
            return;
        }
        sb.append("\n").append(indent).append("private void ").append(CSharpGenerator.accessOrderListenerMethodName(token, "Length")).append("()\n").append(indent).append("{\n");
        FieldPrecedenceModel.CodecInteraction accessLength = fieldPrecedenceModel.interactionFactory().accessVarDataLength(token);
        CSharpGenerator.generateAccessOrderListener(sb, indent + "    ", "decode length of var data", fieldPrecedenceModel, accessLength);
        sb.append(indent).append("}\n");
    }

    private static CharSequence generateDecoderWrapListener(FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        if (null == fieldPrecedenceModel) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("private void OnWrapForDecode(int actingVersion)\n").append(indent).append("{\n");
        fieldPrecedenceModel.forEachWrappedStateByVersionDesc((version, state) -> sb.append(indent).append("    if (actingVersion >= ").append(version).append(")\n").append(indent).append("    {\n").append(indent).append("        codecState(").append(CSharpGenerator.qualifiedStateCase(state)).append(");\n").append(indent).append("        return;\n").append(indent).append("    }\n\n"));
        sb.append(indent).append("    throw new InvalidOperationException(\"Unsupported acting version: \" + actingVersion);\n").append(indent).append("}\n\n");
        return sb;
    }

    private CharSequence generateEncoderWrapListener(FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        if (null == fieldPrecedenceModel) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#if ").append(this.precedenceChecksFlagName).append("\n").append(indent).append("codecState(").append(CSharpGenerator.qualifiedStateCase(fieldPrecedenceModel.latestVersionWrappedState())).append(");\n").append("#endif\n");
        return sb;
    }

    private CharSequence generateFields(FieldPrecedenceModel fieldPrecedenceModel, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = signalToken.name();
            this.generateFieldIdMethod(sb, signalToken, indent + "    ");
            this.generateSinceActingDeprecated(sb, indent + "    ", CSharpUtil.formatPropertyName(signalToken.name()), signalToken);
            this.generateOffsetMethod(sb, signalToken, indent + "    ");
            this.generateFieldMetaAttributeMethod(sb, signalToken, indent + "    ");
            CSharpGenerator.generateAccessOrderListenerMethod(sb, fieldPrecedenceModel, indent + "    ", signalToken);
            switch (encodingToken.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(propertyName, signalToken, encodingToken, fieldPrecedenceModel, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(propertyName, signalToken, encodingToken, fieldPrecedenceModel, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitSetProperty(propertyName, signalToken, encodingToken, fieldPrecedenceModel, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, signalToken, encodingToken, fieldPrecedenceModel, indent));
                    continue block6;
                }
            }
        }
        return sb;
    }

    private void generateFieldIdMethod(StringBuilder sb, Token token, String indent) {
        sb.append(String.format("\n" + indent + "public const int %sId = %d;\n", CSharpUtil.formatPropertyName(token.name()), token.id()));
    }

    private void generateOffsetMethod(StringBuilder sb, Token token, String indent) {
        sb.append(String.format("\n" + indent + "public const int %sOffset = %d;\n", CSharpUtil.formatPropertyName(token.name()), token.offset()));
    }

    private void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? "" : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? "" : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? "" : encoding.semanticType();
        String presence = encoding.presence() == null ? "" : encoding.presence().toString().toLowerCase();
        sb.append(String.format("\n" + indent + "public static string %sMetaAttribute(MetaAttribute metaAttribute)\n" + indent + "{\n" + indent + "    " + "switch (metaAttribute)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "case MetaAttribute.Epoch: return \"%s\";\n" + indent + "    " + "    " + "case MetaAttribute.TimeUnit: return \"%s\";\n" + indent + "    " + "    " + "case MetaAttribute.SemanticType: return \"%s\";\n" + indent + "    " + "    " + "case MetaAttribute.Presence: return \"%s\";\n" + indent + "    " + "}\n\n" + indent + "    " + "return \"\";\n" + indent + "}\n", Generators.toUpperFirstChar(token.name()), epoch, timeUnit, semanticType, presence));
    }

    private CharSequence generateEnumFieldNotPresentCondition(int sinceVersion, String enumName, String indent) {
        if (0 == sinceVersion) {
            return "";
        }
        return String.format(indent + "    " + "    " + "if (_actingVersion < %d) return %s.NULL_VALUE;\n\n", sinceVersion, enumName);
    }

    private CharSequence generateEnumProperty(String propertyName, Token fieldToken, Token typeToken, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        String enumName = CSharpUtil.formatClassName(typeToken.applicableTypeName());
        String typePrefix = Generators.toUpperFirstChar(typeToken.encoding().primitiveType().primitiveName());
        String enumUnderlyingType = CSharpUtil.cSharpTypeName(typeToken.encoding().primitiveType());
        int offset = typeToken.offset();
        ByteOrder byteOrder = typeToken.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, typeToken.encoding().primitiveType().size());
        if (fieldToken.isConstantEncoding()) {
            String constValue = fieldToken.encoding().constValue().toString();
            return String.format("\n%1$s" + indent + "    " + "public %2$s %3$s\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "return %4$s;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n\n", CSharpGenerator.generateDocumentation(indent + "    ", fieldToken), enumName, Generators.toUpperFirstChar(propertyName), constValue);
        }
        CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + TWO_INDENT, fieldToken, new String[0]);
        return String.format("\n%1$s" + indent + "    " + "public %2$s %3$s\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n%4$s%10$s" + indent + "    " + "    " + "    " + "return (%5$s)_buffer.%6$sGet%8$s(_offset + %7$d);\n" + indent + "    " + "    " + "}\n" + indent + "    " + "    " + "set\n" + indent + "    " + "    " + "{\n%10$s" + indent + "    " + "    " + "    " + "_buffer.%6$sPut%8$s(_offset + %7$d, (%9$s)value);\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n\n", CSharpGenerator.generateDocumentation(indent + "    ", fieldToken), enumName, Generators.toUpperFirstChar(propertyName), this.generateEnumFieldNotPresentCondition(fieldToken.version(), enumName, indent), enumName, typePrefix, offset, byteOrderStr, enumUnderlyingType, accessOrderListenerCall);
    }

    private String generateBitSetProperty(String propertyName, Token fieldToken, Token typeToken, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        String bitSetName = CSharpUtil.formatClassName(typeToken.applicableTypeName());
        int offset = typeToken.offset();
        String typePrefix = Generators.toUpperFirstChar(typeToken.encoding().primitiveType().primitiveName());
        ByteOrder byteOrder = typeToken.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, typeToken.encoding().primitiveType().size());
        String typeName = CSharpUtil.cSharpTypeName(typeToken.encoding().primitiveType());
        CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + TWO_INDENT, fieldToken, new String[0]);
        return String.format("\n%1$s" + indent + "    " + "public %2$s %3$s\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n%4$s%10$s" + indent + "    " + "    " + "    " + "return (%5$s)_buffer.%6$sGet%8$s(_offset + %7$d);\n" + indent + "    " + "    " + "}\n" + indent + "    " + "    " + "set\n" + indent + "    " + "    " + "{\n%10$s" + indent + "    " + "    " + "    " + "_buffer.%6$sPut%8$s(_offset + %7$d, (%9$s)value);\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n", CSharpGenerator.generateDocumentation(indent + "    ", fieldToken), bitSetName, Generators.toUpperFirstChar(propertyName), this.generateBitSetNotPresentCondition(fieldToken.version(), indent, bitSetName), bitSetName, typePrefix, offset, byteOrderStr, typeName, accessOrderListenerCall);
    }

    private Object generateCompositeProperty(String propertyName, Token fieldToken, Token typeToken, FieldPrecedenceModel fieldPrecedenceModel, String indent) {
        String compositeName = CSharpUtil.formatClassName(typeToken.applicableTypeName());
        int offset = typeToken.offset();
        CharSequence accessOrderListenerCall = this.generateAccessOrderListenerCall(fieldPrecedenceModel, indent + THREE_INDENT, fieldToken, new String[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    " + "private readonly %1$s _%2$s = new %3$s();\n", compositeName, Generators.toLowerFirstChar(propertyName), compositeName));
        sb.append(String.format("\n%1$s" + indent + "    " + "public %2$s %3$s\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n%4$s%7$s" + indent + "    " + "    " + "    " + "_%5$s.Wrap(_buffer, _offset + %6$d, _actingVersion);\n" + indent + "    " + "    " + "    " + "return _%5$s;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n", CSharpGenerator.generateDocumentation(indent + "    ", fieldToken), compositeName, Generators.toUpperFirstChar(propertyName), this.generateTypeFieldNotPresentCondition(fieldToken.version(), indent), Generators.toLowerFirstChar(propertyName), offset, accessOrderListenerCall));
        return sb;
    }

    private void generateSinceActingDeprecated(StringBuilder sb, String indent, String propertyName, Token token) {
        sb.append(String.format(indent + "public const int %1$sSinceVersion = %2$d;\n" + indent + "public const int %1$sDeprecated = %3$d;\n" + indent + "public bool %1$sInActingVersion()\n" + indent + "{\n" + indent + "    " + "return _actingVersion >= %1$sSinceVersion;\n" + indent + "}\n", propertyName, token.version(), token.deprecated()));
    }

    private String generateByteOrder(ByteOrder byteOrder, int primitiveTypeSize) {
        if (primitiveTypeSize == 1) {
            return "";
        }
        if ("BIG_ENDIAN".equals(byteOrder.toString())) {
            return "BigEndian";
        }
        return "LittleEndian";
    }

    private String generateLiteral(PrimitiveType type, String value) {
        String literal = "";
        String castType = CSharpUtil.cSharpTypeName(type);
        switch (type) {
            case CHAR: 
            case UINT8: 
            case INT8: 
            case INT16: 
            case UINT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case INT32: {
                literal = value;
                break;
            }
            case UINT32: {
                literal = value + "U";
                break;
            }
            case FLOAT: {
                if (value.endsWith("NaN")) {
                    literal = "float.NaN";
                    break;
                }
                literal = value + "f";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "UL";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "double.NaN" : value + "d";
            }
        }
        return literal;
    }

    private void appendGroupInstanceDisplay(StringBuilder sb, List<Token> fields, List<Token> groups, List<Token> varData, String baseIndent) {
        String indent = baseIndent + "    ";
        sb.append('\n');
        CSharpUtil.append(sb, indent, "internal void BuildString(StringBuilder builder)");
        CSharpUtil.append(sb, indent, "{");
        CSharpUtil.append(sb, indent, "    if (_buffer == null)");
        CSharpUtil.append(sb, indent, "    {");
        CSharpUtil.append(sb, indent, "        return;");
        CSharpUtil.append(sb, indent, "    }");
        sb.append('\n');
        CSharpUtil.Separators.BEGIN_COMPOSITE.appendToGeneratedBuilder(sb, indent + "    ");
        this.appendDisplay(sb, fields, groups, varData, indent + "    ");
        CSharpUtil.Separators.END_COMPOSITE.appendToGeneratedBuilder(sb, indent + "    ");
        sb.append('\n');
        CSharpUtil.append(sb, indent, "}");
    }

    private void appendDisplay(StringBuilder sb, List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        Token varDataToken;
        int lengthBeforeLastGeneratedSeparator = -1;
        int i = 0;
        int size = fields.size();
        while (i < size) {
            Token fieldToken = fields.get(i);
            if (fieldToken.signal() == Signal.BEGIN_FIELD) {
                Token encodingToken = fields.get(i + 1);
                String fieldName = CSharpUtil.formatPropertyName(fieldToken.name());
                lengthBeforeLastGeneratedSeparator = this.writeTokenDisplay(fieldName, encodingToken, sb, indent);
                i += fieldToken.componentTokenCount();
                continue;
            }
            ++i;
        }
        size = groups.size();
        for (i = 0; i < size; ++i) {
            Token groupToken = groups.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = CSharpUtil.formatPropertyName(groupToken.name());
            String varName = CSharpUtil.formatVariableName(groupToken.name());
            CSharpUtil.append(sb, indent, "builder.Append(\"" + groupName + (Object)((Object)CSharpUtil.Separators.KEY_VALUE) + (Object)((Object)CSharpUtil.Separators.BEGIN_GROUP) + "\");");
            CSharpUtil.append(sb, indent, "var " + varName + " = this." + groupName + ";");
            CSharpUtil.append(sb, indent, "if (" + varName + ".Count > 0)");
            CSharpUtil.append(sb, indent, "{");
            CSharpUtil.append(sb, indent, "    var first = true;");
            CSharpUtil.append(sb, indent, "    while (" + varName + ".HasNext)");
            CSharpUtil.append(sb, indent, "    {");
            CSharpUtil.append(sb, indent, "        if (!first)");
            CSharpUtil.append(sb, indent, "        {");
            CSharpUtil.append(sb, indent, "            builder.Append(',');");
            CSharpUtil.append(sb, indent, "        }");
            CSharpUtil.append(sb, indent, "        first = false;");
            CSharpUtil.append(sb, indent, TWO_INDENT + varName + ".Next().BuildString(builder);");
            CSharpUtil.append(sb, indent, "    }");
            CSharpUtil.append(sb, indent, "}");
            CSharpUtil.append(sb, indent, "builder.Append(\"" + (Object)((Object)CSharpUtil.Separators.END_GROUP) + "\");");
            lengthBeforeLastGeneratedSeparator = sb.length();
            CSharpUtil.Separators.FIELD.appendToGeneratedBuilder(sb, indent);
            i = GenerationUtil.findEndSignal(groups, i, Signal.END_GROUP, groupToken.name());
        }
        size = varData.size();
        for (i = 0; i < size; i += varDataToken.componentTokenCount()) {
            Token lengthToken = Generators.findFirst("length", varData, i);
            int sizeOfLengthField = lengthToken.encodedLength();
            varDataToken = varData.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + varDataToken);
            }
            String characterEncoding = varData.get(i + 3).encoding().characterEncoding();
            String varDataName = CSharpUtil.formatPropertyName(varDataToken.name());
            String getterName = CSharpUtil.formatGetterName(varDataToken.name());
            CSharpUtil.append(sb, indent, "builder.Append(\"" + varDataName + (Object)((Object)CSharpUtil.Separators.KEY_VALUE) + "\");");
            if (characterEncoding == null) {
                String name = Generators.toUpperFirstChar(varDataToken.name());
                CSharpUtil.append(sb, indent, "builder.Append(" + name + "Length()).Append(\" bytes of raw data\");");
                CSharpUtil.append(sb, indent, "_parentMessage.Limit = _parentMessage.Limit + " + sizeOfLengthField + " + " + name + "Length();\n");
            } else {
                CSharpUtil.append(sb, indent, "builder.Append('\\'').Append(" + getterName + "()).Append('\\'');");
            }
            lengthBeforeLastGeneratedSeparator = sb.length();
            CSharpUtil.Separators.FIELD.appendToGeneratedBuilder(sb, indent);
        }
        if (lengthBeforeLastGeneratedSeparator > -1) {
            sb.setLength(lengthBeforeLastGeneratedSeparator);
        }
    }

    private int writeTokenDisplay(String fieldName, Token typeToken, StringBuilder sb, String indent) {
        if (typeToken.encodedLength() <= 0) {
            return -1;
        }
        CSharpUtil.append(sb, indent, "builder.Append(\"" + fieldName + (Object)((Object)CSharpUtil.Separators.KEY_VALUE) + "\");");
        if (typeToken.isConstantEncoding()) {
            CSharpUtil.append(sb, indent, "builder.Append(\"" + typeToken.encoding().constValue() + "\");");
        } else {
            switch (typeToken.signal()) {
                case ENCODING: {
                    if (typeToken.arrayLength() > 1) {
                        if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
                            CSharpUtil.append(sb, indent, "builder.Append(\"'\");");
                            CSharpUtil.append(sb, indent, "for (int i = 0; i < " + fieldName + "Length && this.Get" + fieldName + "(i) > 0; ++i)");
                            CSharpUtil.append(sb, indent, "{");
                            CSharpUtil.append(sb, indent, "    builder.Append((char)this.Get" + fieldName + "(i));");
                            CSharpUtil.append(sb, indent, "}");
                            CSharpUtil.append(sb, indent, "builder.Append(\"'\");");
                            break;
                        }
                        CSharpUtil.Separators.BEGIN_ARRAY.appendToGeneratedBuilder(sb, indent);
                        CSharpUtil.append(sb, indent, "for (int i = 0; i < " + fieldName + "Length; ++i)");
                        CSharpUtil.append(sb, indent, "{");
                        CSharpUtil.append(sb, indent, "    if (i > 0)");
                        CSharpUtil.append(sb, indent, "    {");
                        CSharpUtil.append(sb, indent, "        builder.Append(',');");
                        CSharpUtil.append(sb, indent, "    }");
                        CSharpUtil.append(sb, indent, "    builder.Append(Get" + fieldName + "(i));");
                        CSharpUtil.append(sb, indent, "}");
                        CSharpUtil.Separators.END_ARRAY.appendToGeneratedBuilder(sb, indent);
                        break;
                    }
                    CSharpUtil.append(sb, indent, "builder.Append(this." + fieldName + ");");
                    break;
                }
                case BEGIN_ENUM: {
                    CSharpUtil.append(sb, indent, "builder.Append(this." + fieldName + ");");
                    break;
                }
                case BEGIN_SET: {
                    CSharpUtil.append(sb, indent, "this." + fieldName + ".BuildString(builder);");
                    break;
                }
                case BEGIN_COMPOSITE: {
                    CSharpUtil.append(sb, indent, "if (this." + fieldName + " != null)");
                    CSharpUtil.append(sb, indent, "{");
                    CSharpUtil.append(sb, indent, "    this." + fieldName + ".BuildString(builder);");
                    CSharpUtil.append(sb, indent, "}");
                    CSharpUtil.append(sb, indent, "else");
                    CSharpUtil.append(sb, indent, "{");
                    CSharpUtil.append(sb, indent, "    builder.Append(\"null\");");
                    CSharpUtil.append(sb, indent, "}");
                    break;
                }
            }
        }
        int lengthBeforeFieldSeparator = sb.length();
        CSharpUtil.Separators.FIELD.appendToGeneratedBuilder(sb, indent);
        return lengthBeforeFieldSeparator;
    }

    private void appendToString(StringBuilder sb, String indent) {
        sb.append('\n');
        CSharpUtil.append(sb, indent, "public override string ToString()");
        CSharpUtil.append(sb, indent, "{");
        CSharpUtil.append(sb, indent, "    var sb = new StringBuilder(100);");
        CSharpUtil.append(sb, indent, "    this.BuildString(sb);");
        CSharpUtil.append(sb, indent, "    return sb.ToString();");
        CSharpUtil.append(sb, indent, "}");
    }

    private CharSequence generateChoiceDisplay(String enumName) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        CSharpUtil.append(sb, "    ", "static class " + enumName + "Ext");
        CSharpUtil.append(sb, "    ", "{");
        CSharpUtil.append(sb, TWO_INDENT, "internal static void BuildString(this " + enumName + " val, StringBuilder builder)");
        CSharpUtil.append(sb, TWO_INDENT, "{");
        CSharpUtil.Separators.BEGIN_SET.appendToGeneratedBuilder(sb, THREE_INDENT);
        CSharpUtil.append(sb, THREE_INDENT, "builder.Append(val);");
        CSharpUtil.Separators.END_SET.appendToGeneratedBuilder(sb, THREE_INDENT);
        CSharpUtil.append(sb, TWO_INDENT, "}");
        CSharpUtil.append(sb, "    ", "}");
        return sb;
    }

    private CharSequence generateDisplay(String name, List<Token> tokens, List<Token> groups, List<Token> varData, FieldPrecedenceModel fieldPrecedenceModel) {
        StringBuilder sb = new StringBuilder(100);
        this.appendToString(sb, TWO_INDENT);
        sb.append('\n');
        CSharpUtil.append(sb, TWO_INDENT, "internal void BuildString(StringBuilder builder)");
        CSharpUtil.append(sb, TWO_INDENT, "{");
        CSharpUtil.append(sb, TWO_INDENT, "    if (_buffer == null)");
        CSharpUtil.append(sb, TWO_INDENT, "    {");
        CSharpUtil.append(sb, TWO_INDENT, "        throw new ArgumentNullException(\"_buffer\");");
        CSharpUtil.append(sb, TWO_INDENT, "    }");
        sb.append('\n');
        CSharpUtil.append(sb, TWO_INDENT, "    int originalLimit = this.Limit;");
        if (null != fieldPrecedenceModel) {
            sb.append("#if ").append(this.precedenceChecksFlagName).append("\n");
            CSharpUtil.append(sb, TWO_INDENT, "    CodecState originalState = _codecState;");
            sb.append(THREE_INDENT).append("_codecState = ").append(CSharpGenerator.qualifiedStateCase(fieldPrecedenceModel.notWrappedState())).append(";\n");
            CSharpUtil.append(sb, TWO_INDENT, "    OnWrapForDecode(_actingVersion);");
            sb.append("#endif\n");
        }
        CSharpUtil.append(sb, TWO_INDENT, "    this.Limit = _offset + _actingBlockLength;");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(\"[" + name + "](sbeTemplateId=\");");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(" + name + ".TemplateId);");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(\"|sbeSchemaId=\");");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(" + name + ".SchemaId);");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(\"|sbeSchemaVersion=\");");
        CSharpUtil.append(sb, TWO_INDENT, "    if (_parentMessage._actingVersion != " + name + ".SchemaVersion)");
        CSharpUtil.append(sb, TWO_INDENT, "    {");
        CSharpUtil.append(sb, TWO_INDENT, "        builder.Append(_parentMessage._actingVersion);");
        CSharpUtil.append(sb, TWO_INDENT, "        builder.Append('/');");
        CSharpUtil.append(sb, TWO_INDENT, "    }");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(" + name + ".SchemaVersion);");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(\"|sbeBlockLength=\");");
        CSharpUtil.append(sb, TWO_INDENT, "    if (_actingBlockLength != " + name + ".BlockLength)");
        CSharpUtil.append(sb, TWO_INDENT, "    {");
        CSharpUtil.append(sb, TWO_INDENT, "        builder.Append(_actingBlockLength);");
        CSharpUtil.append(sb, TWO_INDENT, "        builder.Append('/');");
        CSharpUtil.append(sb, TWO_INDENT, "    }");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(" + name + ".BlockLength);");
        CSharpUtil.append(sb, TWO_INDENT, "    builder.Append(\"):\");");
        sb.append('\n');
        this.appendDisplay(sb, tokens, groups, varData, THREE_INDENT);
        sb.append('\n');
        if (null != fieldPrecedenceModel) {
            sb.append("#if ").append(this.precedenceChecksFlagName).append("\n");
            CSharpUtil.append(sb, TWO_INDENT, "    _codecState = originalState;");
            sb.append("#endif\n");
        }
        CSharpUtil.append(sb, TWO_INDENT, "    this.Limit = originalLimit;");
        sb.append('\n');
        CSharpUtil.append(sb, TWO_INDENT, "}");
        return sb;
    }

    private CharSequence generateCompositeDisplay(List<Token> tokens) {
        Token encodingToken;
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb, TWO_INDENT);
        sb.append('\n');
        CSharpUtil.append(sb, TWO_INDENT, "internal void BuildString(StringBuilder builder)");
        CSharpUtil.append(sb, TWO_INDENT, "{");
        CSharpUtil.append(sb, TWO_INDENT, "    if (_buffer == null)");
        CSharpUtil.append(sb, TWO_INDENT, "    {");
        CSharpUtil.append(sb, TWO_INDENT, "        return;");
        CSharpUtil.append(sb, TWO_INDENT, "    }");
        sb.append('\n');
        CSharpUtil.Separators.BEGIN_COMPOSITE.appendToGeneratedBuilder(sb, THREE_INDENT);
        int lengthBeforeLastGeneratedSeparator = -1;
        int end = tokens.size() - 1;
        for (int i = 1; i < end; i += encodingToken.componentTokenCount()) {
            encodingToken = tokens.get(i);
            String propertyName = CSharpUtil.formatPropertyName(encodingToken.name());
            lengthBeforeLastGeneratedSeparator = this.writeTokenDisplay(propertyName, encodingToken, sb, THREE_INDENT);
        }
        if (lengthBeforeLastGeneratedSeparator > -1) {
            sb.setLength(lengthBeforeLastGeneratedSeparator);
        }
        CSharpUtil.Separators.END_COMPOSITE.appendToGeneratedBuilder(sb, THREE_INDENT);
        sb.append('\n');
        CSharpUtil.append(sb, TWO_INDENT, "}");
        return sb;
    }
}

