/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;

public class UnsafeBuffer
implements AtomicBuffer {
    public static final int ALIGNMENT = 8;
    public static final String DISABLE_BOUNDS_CHECKS_PROP_NAME = "agrona.disable.bounds.checks";
    public static final boolean SHOULD_BOUNDS_CHECK = !Boolean.getBoolean("agrona.disable.bounds.checks");
    private long addressOffset;
    private int capacity;
    private byte[] byteArray;
    private ByteBuffer byteBuffer;

    public UnsafeBuffer(byte[] buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(byte[] buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(ByteBuffer buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(ByteBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(DirectBuffer buffer) {
        this.wrap(buffer);
    }

    public UnsafeBuffer(DirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public UnsafeBuffer(long address, int length) {
        this.wrap(address, length);
    }

    @Override
    public void wrap(byte[] buffer) {
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET;
        this.capacity = buffer.length;
        this.byteArray = buffer;
        this.byteBuffer = null;
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            int bufferLength = buffer.length;
            if (offset != 0 && (offset < 0 || offset > bufferLength - 1)) {
                throw new IllegalArgumentException("offset=" + offset + " not valid for buffer.length=" + bufferLength);
            }
            if (length < 0 || length > bufferLength - offset) {
                throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for buffer.length=" + bufferLength);
            }
        }
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)offset;
        this.capacity = length;
        this.byteArray = buffer;
        this.byteBuffer = null;
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        if (buffer.isDirect()) {
            this.byteArray = null;
            this.addressOffset = BufferUtil.address(buffer);
        } else {
            this.byteArray = BufferUtil.array(this.byteBuffer);
            this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(this.byteBuffer);
        }
        this.capacity = buffer.capacity();
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            int bufferCapacity = buffer.capacity();
            if (offset != 0 && (offset < 0 || offset > bufferCapacity - 1)) {
                throw new IllegalArgumentException("offset=" + offset + " not valid for buffer.capacity()=" + bufferCapacity);
            }
            if (length < 0 || length > bufferCapacity - offset) {
                throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for buffer.capacity()=" + bufferCapacity);
            }
        }
        this.byteBuffer = buffer;
        if (buffer.isDirect()) {
            this.byteArray = null;
            this.addressOffset = BufferUtil.address(buffer) + (long)offset;
        } else {
            this.byteArray = BufferUtil.array(buffer);
            this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(buffer) + (long)offset;
        }
        this.capacity = length;
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        this.addressOffset = buffer.addressOffset();
        this.capacity = buffer.capacity();
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            int bufferCapacity = buffer.capacity();
            if (offset != 0 && (offset < 0 || offset > bufferCapacity - 1)) {
                throw new IllegalArgumentException("offset=" + offset + " not valid for buffer.capacity()=" + bufferCapacity);
            }
            if (length < 0 || length > bufferCapacity - offset) {
                throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for buffer.capacity()=" + bufferCapacity);
            }
        }
        this.addressOffset = buffer.addressOffset() + (long)offset;
        this.capacity = length;
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
    }

    @Override
    public void wrap(long address, int length) {
        this.addressOffset = address;
        this.capacity = length;
        this.byteArray = null;
        this.byteBuffer = null;
    }

    @Override
    public long addressOffset() {
        return this.addressOffset;
    }

    @Override
    public byte[] byteArray() {
        return this.byteArray;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void setMemory(int index, int length, byte value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
        }
        UnsafeAccess.UNSAFE.setMemory(this.byteArray, this.addressOffset + (long)index, length, value);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void checkLimit(int limit) {
        if (limit > this.capacity) {
            String msg = String.format("limit=%d is beyond capacity=%d", limit, this.capacity);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public void verifyAlignment() {
        if (0L != (this.addressOffset & 7L)) {
            throw new IllegalStateException(String.format("AtomicBuffer is not correctly aligned: addressOffset=%d in not divisible by %d", this.addressOffset, 8));
        }
    }

    @Override
    public long getLong(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putLong(int index, long value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public long getLong(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putLong(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long getLongVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putLongVolatile(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putLongVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void putLongOrdered(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long addLongOrdered(int index, long increment) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        long offset = this.addressOffset + (long)index;
        byte[] byteArray = this.byteArray;
        long value = UnsafeAccess.UNSAFE.getLong(byteArray, offset);
        UnsafeAccess.UNSAFE.putOrderedLong(byteArray, offset, value + increment);
        return value;
    }

    @Override
    public boolean compareAndSetLong(int index, long expectedValue, long updateValue) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    @Override
    public long getAndSetLong(int index, long value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getAndSetLong(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public long getAndAddLong(int index, long delta) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset + (long)index, delta);
    }

    @Override
    public int getInt(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putInt(int index, int value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        int bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public int getInt(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putInt(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int getIntVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getIntVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putIntVolatile(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putIntVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void putIntOrdered(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putOrderedInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int addIntOrdered(int index, int increment) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        long offset = this.addressOffset + (long)index;
        byte[] byteArray = this.byteArray;
        int value = UnsafeAccess.UNSAFE.getInt(byteArray, offset);
        UnsafeAccess.UNSAFE.putOrderedInt(byteArray, offset, value + increment);
        return value;
    }

    @Override
    public boolean compareAndSetInt(int index, int expectedValue, int updateValue) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapInt(this.byteArray, this.addressOffset + (long)index, expectedValue, updateValue);
    }

    @Override
    public int getAndSetInt(int index, int value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getAndSetInt(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public int getAndAddInt(int index, int delta) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getAndAddInt(this.byteArray, this.addressOffset + (long)index, delta);
    }

    @Override
    public double getDouble(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, this.addressOffset + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putDouble(int index, double value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UnsafeAccess.UNSAFE.putLong(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    @Override
    public double getDouble(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putDouble(int index, double value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 8);
        }
        UnsafeAccess.UNSAFE.putDouble(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public float getFloat(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, this.addressOffset + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putFloat(int index, float value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UnsafeAccess.UNSAFE.putInt(this.byteArray, this.addressOffset + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
        }
    }

    @Override
    public float getFloat(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putFloat(int index, float value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 4);
        }
        UnsafeAccess.UNSAFE.putFloat(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public short getShort(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        short bits = UnsafeAccess.UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putShort(int index, short value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        short bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public short getShort(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getShort(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putShort(int index, short value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putShort(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public short getShortVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getShortVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putShortVolatile(int index, short value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putShortVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public byte getByte(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        return UnsafeAccess.UNSAFE.getByte(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putByte(int index, byte value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        UnsafeAccess.UNSAFE.putByte(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public byte getByteVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        return UnsafeAccess.UNSAFE.getByteVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putByteVolatile(int index, byte value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(index);
        }
        UnsafeAccess.UNSAFE.putByteVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(dst, (long)offset, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dst, BufferUtil.ARRAY_BASE_OFFSET + (long)offset, length);
    }

    @Override
    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        dstBuffer.putBytes(dstIndex, this, index, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        int dstOffset = dstBuffer.position();
        this.getBytes(index, dstBuffer, dstOffset, length);
        dstBuffer.position(dstOffset + length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int dstOffset, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(dstBuffer, (long)dstOffset, length);
        }
        if (dstBuffer.isDirect()) {
            dstByteArray = null;
            dstBaseOffset = BufferUtil.address(dstBuffer);
        } else {
            dstByteArray = BufferUtil.array(dstBuffer);
            dstBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(dstBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, this.addressOffset + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, length);
    }

    @Override
    public void putBytes(int index, byte[] src) {
        this.putBytes(index, src, 0, src.length);
    }

    @Override
    public void putBytes(int index, byte[] src, int offset, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(src, (long)offset, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(src, BufferUtil.ARRAY_BASE_OFFSET + (long)offset, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        int srcIndex = srcBuffer.position();
        this.putBytes(index, srcBuffer, srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            BufferUtil.boundsCheck(srcBuffer, (long)srcIndex, length);
        }
        if (srcBuffer.isDirect()) {
            srcByteArray = null;
            srcBaseOffset = BufferUtil.address(srcBuffer);
        } else {
            srcByteArray = BufferUtil.array(srcBuffer);
            srcBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(srcBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, length);
            srcBuffer.boundsCheck(srcIndex, length);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcBuffer.byteArray(), srcBuffer.addressOffset() + (long)srcIndex, this.byteArray, this.addressOffset + (long)index, length);
    }

    @Override
    public char getChar(int index, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        char bits = UnsafeAccess.UNSAFE.getChar(this.byteArray, this.addressOffset + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        return bits;
    }

    @Override
    public void putChar(int index, char value, ByteOrder byteOrder) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        char bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        UnsafeAccess.UNSAFE.putChar(this.byteArray, this.addressOffset + (long)index, bits);
    }

    @Override
    public char getChar(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getChar(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putChar(int index, char value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putChar(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public char getCharVolatile(int index) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        return UnsafeAccess.UNSAFE.getCharVolatile(this.byteArray, this.addressOffset + (long)index);
    }

    @Override
    public void putCharVolatile(int index, char value) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(index, 2);
        }
        UnsafeAccess.UNSAFE.putCharVolatile(this.byteArray, this.addressOffset + (long)index, value);
    }

    @Override
    public String getStringUtf8(int index) {
        int length = this.getInt(index);
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, ByteOrder byteOrder) {
        int length = this.getInt(index, byteOrder);
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(index + 4, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringUtf8(int index, String value) {
        return this.putStringUtf8(index, value, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(index, value, byteOrder, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, int maxEncodedSize) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedSize) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedSize);
        }
        this.putInt(index, bytes.length);
        this.putBytes(index + 4, bytes);
        return 4 + bytes.length;
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder, int maxEncodedSize) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedSize) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedSize);
        }
        this.putInt(index, bytes.length, byteOrder);
        this.putBytes(index + 4, bytes);
        return 4 + bytes.length;
    }

    @Override
    public String getStringWithoutLengthUtf8(int index, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(index, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringWithoutLengthUtf8(int index, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.putBytes(index, bytes);
        return bytes.length;
    }

    private void boundsCheck(int index) {
        if (index < 0 || index >= this.capacity) {
            throw new IndexOutOfBoundsException(String.format("index=%d, capacity=%d", index, this.capacity));
        }
    }

    private void boundsCheck0(int index, int length) {
        long resultingPosition = (long)index + (long)length;
        if (index < 0 || resultingPosition > (long)this.capacity) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, this.capacity));
        }
    }

    @Override
    public void boundsCheck(int index, int length) {
        this.boundsCheck0(index, length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnsafeBuffer that = (UnsafeBuffer)obj;
        if (this.capacity != that.capacity) {
            return false;
        }
        byte[] thisByteArray = this.byteArray;
        byte[] thatByteArray = that.byteArray;
        long thisOffset = this.addressOffset;
        long thatOffset = that.addressOffset;
        int length = this.capacity;
        for (int i = 0; i < length; ++i) {
            if (UnsafeAccess.UNSAFE.getByte(thisByteArray, thisOffset + (long)i) == UnsafeAccess.UNSAFE.getByte(thatByteArray, thatOffset + (long)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        byte[] byteArray = this.byteArray;
        long addressOffset = this.addressOffset;
        int length = this.capacity;
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + UnsafeAccess.UNSAFE.getByte(byteArray, addressOffset + (long)i);
        }
        return hashCode;
    }

    @Override
    public int compareTo(DirectBuffer that) {
        int thisCapacity = this.capacity;
        int thatCapacity = that.capacity();
        byte[] thisByteArray = this.byteArray;
        byte[] thatByteArray = that.byteArray();
        long thisOffset = this.addressOffset;
        long thatOffset = that.addressOffset();
        int length = Math.min(thisCapacity, thatCapacity);
        for (int i = 0; i < length; ++i) {
            int cmp = Byte.compare(UnsafeAccess.UNSAFE.getByte(thisByteArray, thisOffset + (long)i), UnsafeAccess.UNSAFE.getByte(thatByteArray, thatOffset + (long)i));
            if (0 == cmp) continue;
            return cmp;
        }
        if (thisCapacity != thatCapacity) {
            return thisCapacity - thatCapacity;
        }
        return 0;
    }
}

