/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.otf;

import java.util.List;
import org.agrona.DirectBuffer;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.otf.TokenListener;
import uk.co.real_logic.sbe.otf.Types;

public class OtfMessageDecoder {
    public static int decode(DirectBuffer buffer, int bufferIdx, int actingVersion, int blockLength, List<Token> msgTokens, TokenListener listener) {
        listener.onBeginMessage(msgTokens.get(0));
        int numTokens = msgTokens.size();
        int tokenIdx = OtfMessageDecoder.decodeFields(buffer, bufferIdx, actingVersion, msgTokens, 1, numTokens, listener);
        long packedValues = OtfMessageDecoder.decodeGroups(buffer, bufferIdx += blockLength, actingVersion, msgTokens, tokenIdx, numTokens, listener);
        bufferIdx = OtfMessageDecoder.decodeData(buffer, OtfMessageDecoder.bufferIndex(packedValues), msgTokens, OtfMessageDecoder.tokenIndex(packedValues), numTokens, listener);
        listener.onEndMessage(msgTokens.get(numTokens - 1));
        return bufferIdx;
    }

    private static int decodeFields(DirectBuffer buffer, int bufferIdx, int actingVersion, List<Token> tokens, int tokenIdx, int numTokens, TokenListener listener) {
        Token fieldToken;
        while (tokenIdx < numTokens && Signal.BEGIN_FIELD == (fieldToken = tokens.get(tokenIdx)).signal()) {
            int nextFieldIdx = tokenIdx + fieldToken.componentTokenCount();
            Token typeToken = tokens.get(++tokenIdx);
            int offset = typeToken.offset();
            switch (typeToken.signal()) {
                case BEGIN_COMPOSITE: {
                    OtfMessageDecoder.decodeComposite(fieldToken, buffer, bufferIdx + offset, tokens, tokenIdx, nextFieldIdx - 2, actingVersion, listener);
                    break;
                }
                case BEGIN_ENUM: {
                    listener.onEnum(fieldToken, buffer, bufferIdx + offset, tokens, tokenIdx, nextFieldIdx - 2, actingVersion);
                    break;
                }
                case BEGIN_SET: {
                    listener.onBitSet(fieldToken, buffer, bufferIdx + offset, tokens, tokenIdx, nextFieldIdx - 2, actingVersion);
                    break;
                }
                case ENCODING: {
                    listener.onEncoding(fieldToken, buffer, bufferIdx + offset, typeToken, actingVersion);
                }
            }
            tokenIdx = nextFieldIdx;
        }
        return tokenIdx;
    }

    private static long decodeGroups(DirectBuffer buffer, int bufferIdx, int actingVersion, List<Token> tokens, int tokenIdx, int numTokens, TokenListener listener) {
        Token token;
        while (tokenIdx < numTokens && Signal.BEGIN_GROUP == (token = tokens.get(tokenIdx)).signal()) {
            Token blockLengthToken = tokens.get(tokenIdx + 2);
            int blockLength = Types.getInt(buffer, bufferIdx + blockLengthToken.offset(), blockLengthToken.encoding().primitiveType(), blockLengthToken.encoding().byteOrder());
            Token numInGroupToken = tokens.get(tokenIdx + 3);
            int numInGroup = Types.getInt(buffer, bufferIdx + numInGroupToken.offset(), numInGroupToken.encoding().primitiveType(), numInGroupToken.encoding().byteOrder());
            Token dimensionTypeComposite = tokens.get(tokenIdx + 1);
            bufferIdx += dimensionTypeComposite.encodedLength();
            int beginFieldsIdx = tokenIdx + dimensionTypeComposite.componentTokenCount() + 1;
            listener.onGroupHeader(token, numInGroup);
            for (int i = 0; i < numInGroup; ++i) {
                listener.onBeginGroup(token, i, numInGroup);
                int afterFieldsIdx = OtfMessageDecoder.decodeFields(buffer, bufferIdx, actingVersion, tokens, beginFieldsIdx, numTokens, listener);
                long packedValues = OtfMessageDecoder.decodeGroups(buffer, bufferIdx += blockLength, actingVersion, tokens, afterFieldsIdx, numTokens, listener);
                bufferIdx = OtfMessageDecoder.decodeData(buffer, OtfMessageDecoder.bufferIndex(packedValues), tokens, OtfMessageDecoder.tokenIndex(packedValues), numTokens, listener);
                listener.onEndGroup(token, i, numInGroup);
            }
            tokenIdx += token.componentTokenCount();
        }
        return OtfMessageDecoder.pack(bufferIdx, tokenIdx);
    }

    private static void decodeComposite(Token fieldToken, DirectBuffer buffer, int bufferIdx, List<Token> tokens, int tokenIdx, int toIndex, int actingVersion, TokenListener listener) {
        Token typeToken;
        listener.onBeginComposite(fieldToken, tokens, tokenIdx, toIndex);
        block6: for (int i = tokenIdx + 1; i < toIndex; i += typeToken.componentTokenCount()) {
            typeToken = tokens.get(i);
            int nextFieldIdx = i + typeToken.componentTokenCount();
            int offset = typeToken.offset();
            switch (typeToken.signal()) {
                case BEGIN_COMPOSITE: {
                    OtfMessageDecoder.decodeComposite(fieldToken, buffer, bufferIdx + offset, tokens, i, nextFieldIdx - 1, actingVersion, listener);
                    continue block6;
                }
                case BEGIN_ENUM: {
                    listener.onEnum(fieldToken, buffer, bufferIdx + offset, tokens, i, nextFieldIdx - 1, actingVersion);
                    continue block6;
                }
                case BEGIN_SET: {
                    listener.onBitSet(fieldToken, buffer, bufferIdx + offset, tokens, i, nextFieldIdx - 1, actingVersion);
                    continue block6;
                }
                case ENCODING: {
                    listener.onEncoding(typeToken, buffer, bufferIdx + offset, typeToken, actingVersion);
                }
            }
        }
        listener.onEndComposite(fieldToken, tokens, tokenIdx, toIndex);
    }

    private static int decodeData(DirectBuffer buffer, int bufferIdx, List<Token> tokens, int tokenIdx, int numTokens, TokenListener listener) {
        Token token;
        while (tokenIdx < numTokens && Signal.BEGIN_VAR_DATA == (token = tokens.get(tokenIdx)).signal()) {
            Token lengthToken = tokens.get(tokenIdx + 2);
            int length = Types.getInt(buffer, bufferIdx + lengthToken.offset(), lengthToken.encoding().primitiveType(), lengthToken.encoding().byteOrder());
            Token dataToken = tokens.get(tokenIdx + 3);
            listener.onVarData(token, buffer, bufferIdx += dataToken.offset(), length, dataToken);
            bufferIdx += length;
            tokenIdx += token.componentTokenCount();
        }
        return bufferIdx;
    }

    private static long pack(int bufferIndex, int tokenIndex) {
        return (long)bufferIndex << 32 | (long)tokenIndex;
    }

    private static int bufferIndex(long packedValues) {
        return (int)(packedValues >>> 32);
    }

    private static int tokenIndex(long packedValues) {
        return (int)packedValues;
    }
}

