/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIterator;

public final class IntHashSet
extends AbstractSet<Integer> {
    public static final float DEFAULT_LOAD_FACTOR = 0.67f;
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size;
    private int[] values;
    private final IntIterator iterator;

    public IntHashSet(int missingValue) {
        this(8, missingValue);
    }

    public IntHashSet(int proposedCapacity, int missingValue) {
        this(proposedCapacity, missingValue, 0.67f);
    }

    public IntHashSet(int initialCapacity, int missingValue, float loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.size = 0;
        this.missingValue = missingValue;
        int capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.values = new int[capacity];
        Arrays.fill(this.values, missingValue);
        this.iterator = new IntHashSetIterator(missingValue, this.values);
    }

    public int missingValue() {
        return this.missingValue;
    }

    @Override
    public boolean add(Integer value) {
        return this.add((int)value);
    }

    @Override
    public boolean add(int value) {
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != this.missingValue) {
            if (values[index] == value) {
                return false;
            }
            index = IntHashSet.next(index, mask);
        }
        values[index] = value;
        ++this.size;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int capacity = newCapacity;
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        int[] tempValues = new int[capacity];
        int missingValue = this.missingValue;
        Arrays.fill(tempValues, missingValue);
        for (int value : this.values) {
            if (value == missingValue) continue;
            int newHash = Hashing.hash(value, mask);
            while (tempValues[newHash] != missingValue) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        return value instanceof Integer && this.remove((Integer)value);
    }

    public boolean remove(int value) {
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != this.missingValue) {
            if (values[index] == value) {
                values[index] = this.missingValue;
                this.compactChain(index);
                --this.size;
                return true;
            }
            index = IntHashSet.next(index, mask);
        }
        return false;
    }

    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    void compactChain(int deleteIndex) {
        int[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (values[index = IntHashSet.next(index, mask)] != this.missingValue) {
            int hash = Hashing.hash(values[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = this.missingValue;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(idealCapacity));
    }

    @Override
    public boolean contains(Object value) {
        return value instanceof Integer && this.contains((Integer)value);
    }

    public boolean contains(int value) {
        int[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != this.missingValue) {
            if (values[index] == value) {
                return true;
            }
            index = IntHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, this.missingValue);
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> coll) {
        return IntHashSet.disjunction(coll, this::add);
    }

    public boolean addAll(IntHashSet coll) {
        boolean acc = false;
        int missingValue = coll.missingValue;
        for (int value : coll.values) {
            if (value == missingValue) continue;
            acc |= this.add(value);
        }
        return acc;
    }

    public boolean containsAll(IntHashSet other) {
        int missingValue = other.missingValue;
        for (int value : other.values) {
            if (value == missingValue || this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public IntHashSet difference(IntHashSet other) {
        IntHashSet difference = null;
        int missingValue = this.missingValue;
        for (int value : this.values) {
            if (value == missingValue || other.contains(value)) continue;
            if (difference == null) {
                difference = new IntHashSet(this.size, missingValue);
            }
            difference.add(value);
        }
        return difference;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return IntHashSet.disjunction(coll, this::remove);
    }

    public boolean removeAll(IntHashSet coll) {
        boolean acc = false;
        int missingValue = coll.missingValue;
        for (int value : coll.values) {
            if (value == missingValue) continue;
            acc |= this.remove(value);
        }
        return acc;
    }

    private static <T> boolean disjunction(Collection<T> coll, Predicate<T> predicate) {
        boolean acc = false;
        for (T t : coll) {
            acc |= predicate.test(t);
        }
        return acc;
    }

    public IntIterator iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public void copy(IntHashSet that) {
        if (this.values.length != that.values.length) {
            throw new IllegalArgumentException("Cannot copy object: masks not equal");
        }
        if (this.missingValue != that.missingValue) {
            throw new IllegalArgumentException("Cannot copy object: missingValues not equal");
        }
        System.arraycopy(that.values, 0, this.values, 0, this.values.length);
        this.size = that.size;
    }

    @Override
    public String toString() {
        return this.stream().map(x -> Integer.toString(x)).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public <T> T[] toArray(T[] into) {
        Class<Integer> componentType = into.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Integer.class)) {
            throw new ArrayStoreException("Cannot store Integers in array of type " + componentType);
        }
        int size = this.size;
        Object[] arrayCopy = into.length >= size ? into : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        IntIterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            arrayCopy[i] = iterator.next();
            ++i;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IntHashSet) {
            IntHashSet otherSet = (IntHashSet)other;
            return otherSet.missingValue == this.missingValue && otherSet.size == this.size && this.containsAll(otherSet);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public final class IntHashSetIterator
    extends IntIterator {
        IntHashSetIterator(int missingValue, int[] values) {
            super(missingValue, values);
        }

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((IntHashSet)IntHashSet.this).values[position] = IntHashSet.this.missingValue;
            --IntHashSet.this.size;
            IntHashSet.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

