/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntIterator
implements Iterator<Integer> {
    private int positionCounter;
    private int stopCounter;
    protected boolean isPositionValid = false;
    private int[] values;
    private boolean containsMissingValue;

    void reset(int[] values, boolean containsMissingValue) {
        int length;
        this.values = values;
        this.containsMissingValue = containsMissingValue;
        int i = length = values.length;
        if (values[length - 1] != -1) {
            int size = length;
            for (i = 0; i < size && values[i] != -1; ++i) {
            }
        }
        this.stopCounter = i;
        this.positionCounter = i + length;
        this.isPositionValid = false;
    }

    protected int position() {
        return this.positionCounter & this.values.length - 1;
    }

    @Override
    public boolean hasNext() {
        int[] values = this.values;
        int mask = values.length - 1;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == -1) continue;
            return true;
        }
        return this.containsMissingValue;
    }

    protected void findNext() {
        int[] values = this.values;
        int mask = values.length - 1;
        this.isPositionValid = false;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            if (values[index] == -1) continue;
            this.positionCounter = i;
            this.isPositionValid = true;
            return;
        }
        if (!this.containsMissingValue) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Integer next() {
        return this.nextValue();
    }

    public int nextValue() {
        this.findNext();
        if (this.isPositionValid) {
            return this.values[this.position()];
        }
        this.containsMissingValue = false;
        return -1;
    }
}

