/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import org.agrona.DirectBuffer;
import org.agrona.collections.IntObjConsumer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CountersReader {
    public static final int RECORD_UNUSED = 0;
    public static final int RECORD_ALLOCATED = 1;
    public static final int RECORD_RECLAIMED = -1;
    public static final int TYPE_ID_OFFSET = 4;
    public static final int KEY_OFFSET = 8;
    public static final int LABEL_OFFSET = 128;
    public static final int FULL_LABEL_LENGTH = 384;
    public static final int MAX_LABEL_LENGTH = 380;
    public static final int MAX_KEY_LENGTH = 120;
    public static final int METADATA_LENGTH = 512;
    public static final int COUNTER_LENGTH = 128;
    protected final AtomicBuffer metaDataBuffer;
    protected final AtomicBuffer valuesBuffer;

    public CountersReader(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer) {
        this.valuesBuffer = valuesBuffer;
        this.metaDataBuffer = metaDataBuffer;
    }

    public AtomicBuffer metaDataBuffer() {
        return this.metaDataBuffer;
    }

    public AtomicBuffer valuesBuffer() {
        return this.valuesBuffer;
    }

    public static int counterOffset(int counterId) {
        return counterId * 128;
    }

    public static int metaDataOffset(int counterId) {
        return counterId * 512;
    }

    public void forEach(IntObjConsumer<String> consumer) {
        int recordStatus;
        int counterId = 0;
        int capacity = this.metaDataBuffer.capacity();
        for (int i = 0; i < capacity && 0 != (recordStatus = this.metaDataBuffer.getIntVolatile(i)); i += 512) {
            if (1 == recordStatus) {
                String label = this.metaDataBuffer.getStringUtf8(i + 128);
                consumer.accept(counterId, label);
            }
            ++counterId;
        }
    }

    public void forEach(MetaData metaData) {
        int recordStatus;
        int counterId = 0;
        int capacity = this.metaDataBuffer.capacity();
        for (int i = 0; i < capacity && 0 != (recordStatus = this.metaDataBuffer.getIntVolatile(i)); i += 512) {
            if (1 == recordStatus) {
                int typeId = this.metaDataBuffer.getInt(i + 4);
                String label = this.metaDataBuffer.getStringUtf8(i + 128);
                UnsafeBuffer keyBuffer = new UnsafeBuffer(this.metaDataBuffer, i + 8, 120);
                metaData.accept(counterId, typeId, keyBuffer, label);
            }
            ++counterId;
        }
    }

    public long getCounterValue(int counterId) {
        return this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(counterId));
    }

    @FunctionalInterface
    public static interface MetaData {
        public void accept(int var1, int var2, DirectBuffer var3, String var4);
    }
}

