/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.List;
import org.w3c.dom.Node;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class Field {
    public static final int INVALID_ID = Integer.MAX_VALUE;
    private final String name;
    private final String description;
    private final int id;
    private final Type type;
    private final int offset;
    private final String semanticType;
    private final Presence presence;
    private final String valueRef;
    private final int blockLength;
    private final CompositeType dimensionType;
    private final boolean variableLength;
    private final int sinceVersion;
    private final int deprecated;
    private List<Field> groupFieldList;
    private int computedOffset;
    private int computedBlockLength;
    private final String epoch;
    private final String timeUnit;

    public Field(String name, String description, int id, Type type, int offset, String semanticType, Presence presence, String valueRef, int blockLength, CompositeType dimensionType, boolean variableLength, int sinceVersion, int deprecated, String epoch, String timeUnit) {
        this.name = name;
        this.description = description;
        this.id = id;
        this.type = type;
        this.offset = offset;
        this.semanticType = semanticType;
        this.presence = presence;
        this.valueRef = valueRef;
        this.blockLength = blockLength;
        this.dimensionType = dimensionType;
        this.variableLength = variableLength;
        this.sinceVersion = sinceVersion;
        this.deprecated = deprecated;
        this.groupFieldList = null;
        this.computedOffset = 0;
        this.computedBlockLength = 0;
        this.epoch = epoch;
        this.timeUnit = timeUnit;
    }

    public void validate(Node node) {
        if (this.type != null && this.semanticType != null && this.type.semanticType() != null && !this.semanticType.equals(this.type.semanticType())) {
            XmlSchemaParser.handleError(node, "Mismatched semanticType on type and field: " + this.name);
        }
        XmlSchemaParser.checkForValidName(node, this.name);
        if (this.type instanceof EnumType && this.presence == Presence.CONSTANT) {
            if (null == this.valueRef) {
                XmlSchemaParser.handleError(node, "valueRef not set for constant Enum");
            } else {
                String validValueName;
                EnumType enumType;
                String valueRefType;
                int periodIndex = this.valueRef.indexOf(46);
                if (periodIndex < 1 || periodIndex == this.valueRef.length() - 1) {
                    XmlSchemaParser.handleError(node, "valueRef format not valid for constant (enum-name.valid-value-name): " + this.valueRef);
                }
                if (!(valueRefType = this.valueRef.substring(0, periodIndex)).equals(this.type.name())) {
                    XmlSchemaParser.handleError(node, "valueRef for Enum name not found: " + valueRefType);
                }
                if (null == (enumType = (EnumType)this.type).getValidValue(validValueName = this.valueRef.substring(periodIndex + 1))) {
                    XmlSchemaParser.handleError(node, "valueRef for validValue name not found: " + validValueName);
                }
            }
        }
    }

    public void groupFields(List<Field> fields) {
        this.groupFieldList = fields;
    }

    public List<Field> groupFields() {
        return this.groupFieldList;
    }

    public void computedOffset(int offset) {
        this.computedOffset = offset;
    }

    public int computedOffset() {
        return this.computedOffset;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public int id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public int offset() {
        return this.offset;
    }

    public int blockLength() {
        return this.blockLength;
    }

    public void computedBlockLength(int length) {
        this.computedBlockLength = length;
    }

    public int computedBlockLength() {
        return this.computedBlockLength;
    }

    public Presence presence() {
        return this.presence;
    }

    public String valueRef() {
        return this.valueRef;
    }

    public String semanticType() {
        return this.semanticType;
    }

    public CompositeType dimensionType() {
        return this.dimensionType;
    }

    public boolean isVariableLength() {
        return this.variableLength;
    }

    public int sinceVersion() {
        return this.sinceVersion;
    }

    public int deprecated() {
        return this.deprecated;
    }

    public String epoch() {
        return this.epoch;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public String toString() {
        return "Field{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", id=" + this.id + ", type=" + this.type + ", offset=" + this.offset + ", semanticType='" + this.semanticType + '\'' + ", presence=" + (Object)((Object)this.presence) + ", valueRef='" + this.valueRef + '\'' + ", blockLength=" + this.blockLength + ", dimensionType=" + this.dimensionType + ", variableLength=" + this.variableLength + ", sinceVersion=" + this.sinceVersion + ", deprecated=" + this.deprecated + ", groupFieldList=" + this.groupFieldList + ", computedOffset=" + this.computedOffset + ", computedBlockLength=" + this.computedBlockLength + ", epoch='" + this.epoch + '\'' + ", timeUnit=" + this.timeUnit + '}';
    }

    public static class Builder {
        private String name;
        private String description;
        private int id = Integer.MAX_VALUE;
        private Type type;
        private int offset;
        private String semanticType;
        private Presence presence;
        private String refValue;
        private int blockLength;
        private CompositeType dimensionType;
        private boolean variableLength;
        private int sinceVersion = 0;
        private int deprecated = 0;
        private String epoch;
        private String timeUnit;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder semanticType(String semanticType) {
            this.semanticType = semanticType;
            return this;
        }

        public Builder presence(Presence presence) {
            this.presence = presence;
            return this;
        }

        public Builder valueRef(String refValue) {
            this.refValue = refValue;
            return this;
        }

        public Builder blockLength(int blockLength) {
            this.blockLength = blockLength;
            return this;
        }

        public Builder dimensionType(CompositeType dimensionType) {
            this.dimensionType = dimensionType;
            return this;
        }

        public Builder variableLength(boolean variableLength) {
            this.variableLength = variableLength;
            return this;
        }

        public Builder sinceVersion(int sinceVersion) {
            this.sinceVersion = sinceVersion;
            return this;
        }

        public Builder deprecated(int deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder epoch(String epoch) {
            this.epoch = epoch;
            return this;
        }

        public Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Field build() {
            return new Field(this.name, this.description, this.id, this.type, this.offset, this.semanticType, this.presence, this.refValue, this.blockLength, this.dimensionType, this.variableLength, this.sinceVersion, this.deprecated, this.epoch, this.timeUnit);
        }
    }
}

