/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.util.Arrays;
import org.agrona.BitUtil;

public class DeadlineTimerWheel {
    private static final int INITIAL_TICK_DEPTH = 16;
    private static final long NO_TIMER_SCHEDULED = Long.MAX_VALUE;
    private final long[][] wheel;
    private final long tickDurationNs;
    private final long startTimeNs;
    private final int mask;
    private long timerCount;
    private int currentTick;

    public DeadlineTimerWheel(long startTimeNs, long tickIntervalNs, int ticksPerWheel) {
        this(startTimeNs, tickIntervalNs, ticksPerWheel, 16);
    }

    public DeadlineTimerWheel(long startTimeNs, long tickIntervalNs, int ticksPerWheel, int initialTickDepth) {
        DeadlineTimerWheel.checkTicksPerWheel(ticksPerWheel);
        this.mask = ticksPerWheel - 1;
        this.tickDurationNs = tickIntervalNs;
        this.startTimeNs = startTimeNs;
        this.timerCount = 0L;
        this.wheel = new long[ticksPerWheel][];
        for (int i = 0; i < this.wheel.length; ++i) {
            this.wheel[i] = new long[initialTickDepth];
            for (int j = 0; j < this.wheel[i].length; ++j) {
                this.wheel[i][j] = Long.MAX_VALUE;
            }
        }
    }

    public long tickIntervalNs() {
        return this.tickDurationNs;
    }

    public long currentTickDeadlineNs() {
        return (long)(this.currentTick + 1) * this.tickDurationNs + this.startTimeNs;
    }

    public long timerCount() {
        return this.timerCount;
    }

    public long scheduleTimeout(long deadlineNs) {
        long ticks = Math.max((deadlineNs - this.startTimeNs) / this.tickDurationNs, (long)this.currentTick);
        int wheelIndex = (int)(ticks & (long)this.mask);
        long[] array = this.wheel[wheelIndex];
        for (int i = 0; i < array.length; ++i) {
            if (Long.MAX_VALUE != array[i]) continue;
            array[i] = deadlineNs;
            ++this.timerCount;
            return DeadlineTimerWheel.timerIdForSlot(wheelIndex, i);
        }
        long[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = deadlineNs;
        this.wheel[wheelIndex] = newArray;
        ++this.timerCount;
        return DeadlineTimerWheel.timerIdForSlot(wheelIndex, array.length);
    }

    public void cancelTimeout(long timerId) {
        int arrayIndex;
        int wheelIndex = DeadlineTimerWheel.tickForTimerId(timerId);
        long[] array = this.wheel[wheelIndex];
        if (array[arrayIndex = DeadlineTimerWheel.indexInTickArray(timerId)] != Long.MAX_VALUE) {
            array[arrayIndex] = Long.MAX_VALUE;
            --this.timerCount;
        }
    }

    public int poll(long nowNs, TimerHandler handler, int maxTimersToExpire) {
        int timersExpired = 0;
        if (this.timerCount > 0L) {
            long[] array = this.wheel[this.currentTick & this.mask];
            int length = array.length;
            for (int i = 0; i < length && maxTimersToExpire > timersExpired; ++i) {
                if (array[i] > nowNs) continue;
                handler.onTimeout(nowNs, DeadlineTimerWheel.timerIdForSlot(this.currentTick & this.mask, i));
                array[i] = Long.MAX_VALUE;
                --this.timerCount;
                ++timersExpired;
            }
            if (this.currentTickDeadlineNs() <= nowNs) {
                ++this.currentTick;
            }
        }
        return timersExpired;
    }

    private static long timerIdForSlot(int tickOnWheel, int indexInTickArray) {
        return (long)tickOnWheel << 32 | (long)indexInTickArray;
    }

    private static int tickForTimerId(long timerId) {
        return (int)(timerId >> 32);
    }

    private static int indexInTickArray(long timerId) {
        return (int)timerId;
    }

    private static void checkTicksPerWheel(int ticksPerWheel) {
        if (!BitUtil.isPowerOfTwo(ticksPerWheel)) {
            throw new IllegalArgumentException("ticks per wheel must be a power of 2: " + ticksPerWheel);
        }
    }

    @FunctionalInterface
    public static interface TimerHandler {
        public void onTimeout(long var1, long var3);
    }
}

