/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Int2ObjectHashMap<V>
implements Map<Integer, V>,
Serializable {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private int[] keys;
    private Object[] values;
    private final ValueCollection<V> valueCollection = new ValueCollection();
    private final KeySet keySet = new KeySet();
    private final EntrySet<V> entrySet = new EntrySet();

    public Int2ObjectHashMap() {
        this(8, 0.55f);
    }

    public Int2ObjectHashMap(int initialCapacity, float loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.keys = new int[capacity];
        this.values = new Object[capacity];
    }

    public Int2ObjectHashMap(Int2ObjectHashMap<V> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.keys = (int[])mapToCopy.keys.clone();
        this.values = (Object[])mapToCopy.values.clone();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    public boolean containsKey(int key) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (null != value) {
            for (Object v : this.values) {
                if (!value.equals(v)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Integer)key);
    }

    public V get(int key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index]) && key != this.keys[index]) {
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        V value = this.get(key);
        if (value == null && (value = mappingFunction.apply(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public V put(int key, V value) {
        Objects.requireNonNull(value, "Value cannot be null");
        Object oldValue = null;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (null == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Integer)key);
    }

    public V remove(int key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index])) {
            if (key == this.keys[index]) {
                this.values[index] = null;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.values, null);
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            sb.append(this.keys[i]);
            sb.append('=');
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = this.values[i];
            if (null == thisValue || null != (thatValue = that.get(this.keys[i])) && thisValue.equals(thatValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            result += Integer.hashCode(this.keys[i]) ^ value.hashCode();
        }
        return result;
    }

    @Override
    public V replace(int key, V value) {
        V curValue = this.get(key);
        if (curValue != null) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(int key, V oldValue, V newValue) {
        V curValue = this.get(key);
        if (curValue == null || !Objects.equals(curValue, oldValue)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        int[] tempKeys = new int[newCapacity];
        Object[] tempValues = new Object[newCapacity];
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            int key = this.keys[i];
            int newHash = Hashing.hash(key, mask);
            while (null != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (null == this.values[index &= mask]) break;
            int hash = Hashing.hash(this.keys[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.values[index] = null;
            deleteIndex = index;
        }
    }

    public class EntryIterator<V>
    extends AbstractIterator<Map.Entry<Integer, V>>
    implements Map.Entry<Integer, V> {
        @Override
        public Map.Entry<Integer, V> next() {
            this.findNext();
            return this;
        }

        @Override
        public Integer getKey() {
            return this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return (V)this.values[this.position()];
        }

        @Override
        public V setValue(V value) {
            Objects.requireNonNull(value);
            int pos = this.position();
            Object oldValue = this.values[pos];
            this.values[pos] = value;
            return (V)oldValue;
        }
    }

    public class KeyIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return this.keys[this.position()];
        }
    }

    public class ValueIterator<T>
    extends AbstractIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T>,
    Serializable {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;
        protected int[] keys;
        protected Object[] values;

        AbstractIterator() {
        }

        protected int position() {
            return this.posCounter & this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected void findNext() {
            int mask = this.values.length - 1;
            this.isPositionValid = false;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (null == this.values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            this.values[position] = null;
            --Int2ObjectHashMap.this.size;
            Int2ObjectHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        void reset() {
            int capacity;
            this.remaining = Int2ObjectHashMap.this.size;
            this.keys = Int2ObjectHashMap.this.keys;
            this.values = Int2ObjectHashMap.this.values;
            int i = capacity = this.values.length;
            if (null != this.values[capacity - 1]) {
                for (i = 0; i < capacity && null != this.values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    class EntrySet<V>
    extends AbstractSet<Map.Entry<Integer, V>>
    implements Serializable {
        private final EntryIterator<V> iterator;

        EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }
    }

    class ValueCollection<V>
    extends AbstractCollection<V>
    implements Serializable {
        private final ValueIterator<V> iterator;

        ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectHashMap.this.containsValue(o);
        }

        @Override
        public ValueIterator<V> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }
    }

    public class KeySet
    extends AbstractSet<Integer>
    implements Serializable {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectHashMap.this.containsKey(o);
        }

        public boolean contains(int key) {
            return Int2ObjectHashMap.this.containsKey(key);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            return null != Int2ObjectHashMap.this.remove(o);
        }

        public boolean remove(int key) {
            return null != Int2ObjectHashMap.this.remove(key);
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }
    }
}

