/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Object2IntHashMap<K>
implements Map<K, Integer>,
Serializable {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private K[] keys;
    private int[] values;
    private final ValueCollection valueCollection = new ValueCollection();
    private final KeySet<K> keySet = new KeySet();
    private final EntrySet<K> entrySet = new EntrySet();
    private final int missingValue;

    public Object2IntHashMap(int missingValue) {
        this(8, 0.55f, missingValue);
    }

    public Object2IntHashMap(int initialCapacity, float loadFactor, int missingValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.missingValue = missingValue;
        this.keys = new Object[capacity];
        this.values = new int[capacity];
        Arrays.fill(this.values, missingValue);
    }

    public Object2IntHashMap(Object2IntHashMap<K> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.missingValue = mapToCopy.missingValue;
        this.keys = (Object[])mapToCopy.keys.clone();
        this.values = (int[])mapToCopy.values.clone();
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (this.missingValue != this.values[index]) {
            if (key.equals(this.keys[index])) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    public boolean containsValue(int value) {
        if (value == this.missingValue) {
            return false;
        }
        boolean found = false;
        for (int v : this.values) {
            if (value != v) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public Integer get(Object key) {
        return this.getValue(key);
    }

    public int getValue(K key) {
        int value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != (value = this.values[index]) && !key.equals(this.keys[index])) {
            ++index;
            index &= mask;
        }
        return value;
    }

    public int computeIfAbsent(K key, ToIntFunction<? super K> mappingFunction) {
        int value = this.getValue(key);
        if (value == this.missingValue && (value = mappingFunction.applyAsInt(key)) != this.missingValue) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public Integer put(K key, Integer value) {
        return this.put(key, (int)value);
    }

    @Override
    public int put(K key, int value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("Cannot accept missingValue");
        }
        int oldValue = this.missingValue;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != this.values[index]) {
            if (key.equals(this.keys[index])) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (this.missingValue == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return oldValue;
    }

    @Override
    public Integer remove(Object key) {
        return this.removeKey(key);
    }

    public int removeKey(K key) {
        int value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != (value = this.values[index])) {
            if (key.equals(this.keys[index])) {
                this.values[index] = this.missingValue;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.values, this.missingValue);
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> map) {
        for (Map.Entry<K, Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    public ValueCollection values() {
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<K, Integer>> entrySet() {
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            int value = this.values[i];
            if (this.missingValue == value) continue;
            sb.append(this.keys[i]);
            sb.append('=');
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            int thisValue = this.values[i];
            if (this.missingValue == thisValue) continue;
            Object thatValueObject = that.get(this.keys[i]);
            if (!(thatValueObject instanceof Integer)) {
                return false;
            }
            int thatValue = (Integer)thatValueObject;
            if (this.missingValue != thatValue && thisValue == thatValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            int value = this.values[i];
            if (this.missingValue == value) continue;
            result += this.keys[i].hashCode() ^ Integer.hashCode(value);
        }
        return result;
    }

    @Override
    public int replace(K key, int value) {
        int curValue = this.getValue(key);
        if (curValue != this.missingValue) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(K key, int oldValue, int newValue) {
        int curValue = this.getValue(key);
        if (curValue == this.missingValue || curValue != oldValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        Object[] tempKeys = new Object[newCapacity];
        int[] tempValues = new int[newCapacity];
        Arrays.fill(tempValues, this.missingValue);
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            int value = this.values[i];
            if (this.missingValue == value) continue;
            K key = this.keys[i];
            int newHash = Hashing.hash(key, mask);
            while (this.missingValue != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (this.missingValue == this.values[index &= mask]) break;
            int hash = Hashing.hash(this.keys[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.values[index] = this.missingValue;
            deleteIndex = index;
        }
    }

    public class EntryIterator<T>
    extends AbstractIterator<Map.Entry<T, Integer>>
    implements Map.Entry<T, Integer> {
        @Override
        public Map.Entry<T, Integer> next() {
            this.findNext();
            return this;
        }

        @Override
        public T getKey() {
            return (T)this.keys[this.position()];
        }

        @Override
        public Integer getValue() {
            return this.values[this.position()];
        }

        @Override
        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        @Override
        public int setValue(int value) {
            if (value == Object2IntHashMap.this.missingValue) {
                throw new IllegalArgumentException("Cannot accept missingValue");
            }
            int pos = this.position();
            int oldValue = this.values[pos];
            this.values[pos] = value;
            return oldValue;
        }
    }

    public class KeyIterator<T>
    extends AbstractIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)this.keys[this.position()];
        }
    }

    public class ValueIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T>,
    Serializable {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;
        protected Object[] keys;
        protected int[] values;

        AbstractIterator() {
        }

        protected int position() {
            return this.posCounter & this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected void findNext() {
            int mask = this.values.length - 1;
            this.isPositionValid = false;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (Object2IntHashMap.this.missingValue == this.values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            this.values[position] = Object2IntHashMap.this.missingValue;
            --Object2IntHashMap.this.size;
            Object2IntHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        void reset() {
            int capacity;
            this.remaining = Object2IntHashMap.this.size;
            this.keys = Object2IntHashMap.this.keys;
            this.values = Object2IntHashMap.this.values;
            int i = capacity = this.values.length;
            if (Object2IntHashMap.this.missingValue != this.values[capacity - 1]) {
                for (i = 0; i < capacity && Object2IntHashMap.this.missingValue != this.values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    class EntrySet<T>
    extends AbstractSet<Map.Entry<T, Integer>>
    implements Serializable {
        private final EntryIterator<T> iterator;

        EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<T, Integer>> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }
    }

    public class ValueCollection
    extends AbstractCollection<Integer>
    implements Serializable {
        private final ValueIterator iterator;

        public ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2IntHashMap.this.containsValue(o);
        }

        public ValueIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }
    }

    class KeySet<T>
    extends AbstractSet<T>
    implements Serializable {
        private final KeyIterator<T> iterator;

        KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2IntHashMap.this.containsKey(o);
        }

        @Override
        public KeyIterator<T> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            return Object2IntHashMap.this.missingValue != Object2IntHashMap.this.removeKey(o);
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }
    }
}

