/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;

public final class Int2IntCounterMap
implements Serializable {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int initialValue;
    private int resizeThreshold;
    private int size = 0;
    private int[] entries;

    public Int2IntCounterMap(int initialValue) {
        this(8, 0.55f, initialValue);
    }

    public Int2IntCounterMap(int initialCapacity, float loadFactor, int initialValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.initialValue = initialValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public int initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int key) {
        int[] entries = this.entries;
        int initialValue = this.initialValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int value = initialValue;
        while (entries[index + 1] != initialValue) {
            if (entries[index] == key) {
                value = entries[index + 1];
                break;
            }
            index = Int2IntCounterMap.next(index, mask);
        }
        return value;
    }

    public int put(int key, int value) {
        if (value == this.initialValue) {
            throw new IllegalArgumentException("Cannot accept initialValue");
        }
        int[] entries = this.entries;
        int initialValue = this.initialValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = initialValue;
        while (entries[index + 1] != initialValue) {
            if (entries[index] == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Int2IntCounterMap.next(index, mask);
        }
        if (oldValue == initialValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    public int incrementAndGet(int key) {
        return this.addAndGet(key, 1);
    }

    public int decrementAndGet(int key) {
        return this.addAndGet(key, -1);
    }

    public int addAndGet(int key, int amount) {
        return this.getAndAdd(key, amount) + amount;
    }

    public int getAndIncrement(int key) {
        return this.getAndAdd(key, 1);
    }

    public int getAndDecrement(int key) {
        return this.getAndAdd(key, -1);
    }

    public int getAndAdd(int key, int amount) {
        int[] entries = this.entries;
        int initialValue = this.initialValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = initialValue;
        while (entries[index + 1] != initialValue) {
            if (entries[index] == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Int2IntCounterMap.next(index, mask);
        }
        if (amount != 0) {
            int newValue;
            entries[index + 1] = newValue = oldValue + amount;
            if (oldValue == initialValue) {
                ++this.size;
                entries[index] = key;
                this.increaseCapacity();
            } else if (newValue == initialValue) {
                --this.size;
                this.compactChain(index);
            }
        }
        return oldValue;
    }

    public void forEach(IntIntConsumer consumer) {
        int[] entries = this.entries;
        int initialValue = this.initialValue;
        int length = entries.length;
        for (int i = 0; i < length; i += 2) {
            if (entries[i + 1] == initialValue) continue;
            consumer.accept(entries[i], entries[i + 1]);
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != this.initialValue;
    }

    public boolean containsValue(int value) {
        boolean found = false;
        if (value != this.initialValue) {
            int[] entries = this.entries;
            int length = entries.length;
            for (int i = 1; i < length; i += 2) {
                if (value != entries[i]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void clear() {
        Arrays.fill(this.entries, this.initialValue);
        this.size = 0;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        int value = this.get(key);
        if (value == this.initialValue && (value = mappingFunction.applyAsInt(key)) != this.initialValue) {
            this.put(key, value);
        }
        return value;
    }

    public int remove(int key) {
        int[] entries = this.entries;
        int initialValue = this.initialValue;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        int oldValue = initialValue;
        while (entries[keyIndex + 1] != initialValue) {
            if (entries[keyIndex] == key) {
                int valueIndex = keyIndex + 1;
                oldValue = entries[keyIndex + 1];
                entries[keyIndex + 1] = initialValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Int2IntCounterMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    public int minValue() {
        int initialValue = this.initialValue;
        int min = this.size == 0 ? initialValue : Integer.MAX_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = entries[i];
            if (value == initialValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public int maxValue() {
        int initialValue = this.initialValue;
        int max = this.size == 0 ? initialValue : Integer.MIN_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int i = 1; i < length; i += 2) {
            int value = entries[i];
            if (value == initialValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int[] entries = this.entries;
        int initialValue = this.initialValue;
        int length = entries.length;
        for (int i = 0; i < length; i += 2) {
            if (entries[i + 1] == initialValue) continue;
            sb.append(entries[i]);
            sb.append('=');
            sb.append(entries[i + 1]);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void compactChain(int deleteKeyIndex) {
        int[] entries = this.entries;
        int initialValue = this.initialValue;
        int mask = entries.length - 1;
        int index = deleteKeyIndex;
        while (entries[(index = Int2IntCounterMap.next(index, mask)) + 1] != initialValue) {
            int hash = Hashing.evenHash(entries[index], mask);
            if ((index >= hash || hash > deleteKeyIndex && deleteKeyIndex > index) && (hash > deleteKeyIndex || deleteKeyIndex > index)) continue;
            entries[deleteKeyIndex] = entries[index];
            entries[deleteKeyIndex + 1] = entries[index + 1];
            entries[index + 1] = initialValue;
            deleteKeyIndex = index;
        }
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new int[entriesLength];
        this.size = 0;
        Arrays.fill(this.entries, this.initialValue);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        int[] oldEntries = this.entries;
        int initialValue = this.initialValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        for (int i = 0; i < length; i += 2) {
            int key = oldEntries[i];
            if (oldEntries[i + 1] == initialValue) continue;
            this.put(key, oldEntries[i + 1]);
        }
    }
}

