/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public final class Int2ObjectCache<V>
implements Map<Integer, V>,
Serializable {
    private long cachePuts = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private int size;
    private final int capacity;
    private final int setSize;
    private final int setSizeShift;
    private final int mask;
    private final int[] keys;
    private final Object[] values;
    private final Consumer<V> evictionConsumer;
    private ValueCollection<V> valueCollection;
    private KeySet keySet;
    private EntrySet<V> entrySet;

    public Int2ObjectCache(int numSets, int setSize, Consumer<V> evictionConsumer) {
        CollectionUtil.validatePositivePowerOfTwo(numSets);
        CollectionUtil.validatePositivePowerOfTwo(setSize);
        Objects.requireNonNull(evictionConsumer, "Null values are not permitted");
        if ((long)numSets * (long)setSize > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Total capacity must be <= max array size: numSets=" + numSets + " setSize=" + setSize);
        }
        this.setSize = setSize;
        this.setSizeShift = Integer.numberOfTrailingZeros(setSize);
        this.capacity = numSets << this.setSizeShift;
        this.mask = numSets - 1;
        this.keys = new int[this.capacity];
        this.values = new Object[this.capacity];
        this.evictionConsumer = evictionConsumer;
    }

    public long cacheHits() {
        return this.cacheHits;
    }

    public long cacheMisses() {
        return this.cacheMisses;
    }

    public long cachePuts() {
        return this.cachePuts;
    }

    public void resetCounters() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cachePuts = 0L;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    public boolean containsKey(int key) {
        int setBeginIndex;
        boolean found = false;
        int setNumber = Hashing.hash(key, this.mask);
        int setEndIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber << this.setSizeShift; i < setEndIndex && null != this.values[i]; ++i) {
            if (key != this.keys[i]) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (null != value) {
            for (Object v : this.values) {
                if (!value.equals(v)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Integer)key);
    }

    public V get(int key) {
        int setBeginIndex;
        Object value = null;
        int setNumber = Hashing.hash(key, this.mask);
        int setEndIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber << this.setSizeShift; i < setEndIndex && null != this.values[i]; ++i) {
            if (key != this.keys[i]) continue;
            value = this.values[i];
            break;
        }
        if (null == value) {
            ++this.cacheMisses;
        } else {
            ++this.cacheHits;
        }
        return (V)value;
    }

    public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        V value = this.get(key);
        if (value == null && (value = mappingFunction.apply(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public V put(int key, V value) {
        int setBeginIndex;
        Objects.requireNonNull(value, "null values are not supported");
        Object evictedValue = null;
        int setNumber = Hashing.hash(key, this.mask);
        int nextSetIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber << this.setSizeShift; i < nextSetIndex && null != this.values[i]; ++i) {
            if (key != this.keys[i]) continue;
            evictedValue = this.values[i];
            this.shuffleUp(i, nextSetIndex - 1);
            break;
        }
        if (null == evictedValue) {
            evictedValue = this.values[setBeginIndex + (this.setSize - 1)];
        }
        this.shuffleDown(setBeginIndex);
        this.keys[setBeginIndex] = key;
        this.values[setBeginIndex] = value;
        ++this.cachePuts;
        if (null != evictedValue) {
            this.evictionConsumer.accept(evictedValue);
        } else {
            ++this.size;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Integer)key);
    }

    public V remove(int key) {
        int setBeginIndex;
        Object value = null;
        int setNumber = Hashing.hash(key, this.mask);
        int nextSetIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber << this.setSizeShift; i < nextSetIndex && null != this.values[i]; ++i) {
            if (key != this.keys[i]) continue;
            value = this.values[i];
            this.shuffleUp(i, nextSetIndex - 1);
            --this.size;
            this.evictionConsumer.accept(value);
            break;
        }
        return (V)value;
    }

    private void shuffleUp(int fromIndex, int toIndex) {
        this.values[toIndex] = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            this.values[i] = this.values[i + 1];
            this.keys[i] = this.keys[i + 1];
        }
    }

    private void shuffleDown(int setBeginIndex) {
        for (int i = setBeginIndex + (this.setSize - 1); i > setBeginIndex; --i) {
            this.values[i] = this.values[i - 1];
            this.keys[i] = this.keys[i - 1];
        }
        this.values[setBeginIndex] = null;
    }

    @Override
    public void clear() {
        for (Object value : this.values) {
            if (null == value) continue;
            this.values[i] = null;
            --this.size;
            this.evictionConsumer.accept(value);
        }
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public ValueCollection<V> values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            sb.append(this.keys[i]);
            sb.append('=');
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = this.values[i];
            if (null == thisValue || null != (thatValue = that.get(this.keys[i])) && thisValue.equals(thatValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            result += Integer.hashCode(this.keys[i]) ^ value.hashCode();
        }
        return result;
    }

    public final class EntryIterator<T>
    extends AbstractIterator<Map.Entry<Integer, T>>
    implements Map.Entry<Integer, T> {
        @Override
        public Map.Entry<Integer, T> next() {
            this.findNext();
            return this;
        }

        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public Integer getIntKey() {
            return Int2ObjectCache.this.keys[this.position()];
        }

        @Override
        public T getValue() {
            return (T)Int2ObjectCache.this.values[this.position()];
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException("Cannot set on this iterator");
        }
    }

    public final class KeyIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Int2ObjectCache.this.keys[this.position()];
        }
    }

    public final class ValueIterator<T>
    extends AbstractIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)Int2ObjectCache.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int remaining;
        private int position = -1;

        AbstractIterator() {
        }

        protected final int position() {
            return this.position;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            boolean found = false;
            Object[] values = Int2ObjectCache.this.values;
            for (int i = this.position + 1; i < Int2ObjectCache.this.capacity; ++i) {
                if (null == values[i]) continue;
                found = true;
                this.position = i;
                --this.remaining;
                break;
            }
            if (!found) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported on Iterator");
        }

        void reset() {
            this.remaining = Int2ObjectCache.this.size;
            this.position = -1;
        }
    }

    public final class EntrySet<T>
    extends AbstractSet<Map.Entry<Integer, T>> {
        private final EntryIterator<T> iterator;

        public EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        @Override
        public Iterator<Map.Entry<Integer, T>> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }
    }

    public final class ValueCollection<T>
    extends AbstractCollection<T> {
        private final ValueIterator<T> iterator;

        public ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectCache.this.containsValue(o);
        }

        @Override
        public ValueIterator<T> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }
    }

    public final class KeySet
    extends AbstractSet<Integer> {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectCache.this.containsKey(o);
        }

        public boolean contains(int key) {
            return Int2ObjectCache.this.containsKey(key);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove on iterator");
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }
    }
}

