/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.ToLongFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public final class Object2LongHashMap<K>
implements Map<K, Long>,
Serializable {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private K[] keys;
    private long[] values;
    private ValueCollection valueCollection;
    private KeySet<K> keySet;
    private EntrySet<K> entrySet;
    private final long missingValue;

    public Object2LongHashMap(long missingValue) {
        this(8, 0.55f, missingValue);
    }

    public Object2LongHashMap(int initialCapacity, float loadFactor, long missingValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.missingValue = missingValue;
        this.keys = new Object[capacity];
        this.values = new long[capacity];
        Arrays.fill(this.values, missingValue);
    }

    public Object2LongHashMap(Object2LongHashMap<K> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.missingValue = mapToCopy.missingValue;
        this.keys = (Object[])mapToCopy.keys.clone();
        this.values = (long[])mapToCopy.values.clone();
    }

    public long missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (this.missingValue != this.values[index]) {
            if (key.equals(this.keys[index])) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    public boolean containsValue(long value) {
        if (value == this.missingValue) {
            return false;
        }
        boolean found = false;
        for (long v : this.values) {
            if (value != v) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public Long get(Object key) {
        return this.getValue(key);
    }

    public long getValue(K key) {
        long value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != (value = this.values[index]) && !key.equals(this.keys[index])) {
            ++index;
            index &= mask;
        }
        return value;
    }

    public long computeIfAbsent(K key, ToLongFunction<? super K> mappingFunction) {
        long value = this.getValue(key);
        if (value == this.missingValue && (value = mappingFunction.applyAsLong(key)) != this.missingValue) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public Long put(K key, Long value) {
        return this.put(key, (long)value);
    }

    @Override
    public long put(K key, long value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("Cannot accept missingValue");
        }
        long oldValue = this.missingValue;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != this.values[index]) {
            if (key.equals(this.keys[index])) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (this.missingValue == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return oldValue;
    }

    @Override
    public Long remove(Object key) {
        return this.removeKey(key);
    }

    public long removeKey(K key) {
        long value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != (value = this.values[index])) {
            if (key.equals(this.keys[index])) {
                this.values[index] = this.missingValue;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.values, this.missingValue);
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends Long> map) {
        for (Map.Entry<K, Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<K, Long>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            long value = this.values[i];
            if (this.missingValue == value) continue;
            sb.append(this.keys[i]);
            sb.append('=');
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            long thisValue = this.values[i];
            if (this.missingValue == thisValue) continue;
            Object thatValueObject = that.get(this.keys[i]);
            if (!(thatValueObject instanceof Long)) {
                return false;
            }
            long thatValue = (Long)thatValueObject;
            if (this.missingValue != thatValue && thisValue == thatValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            long value = this.values[i];
            if (this.missingValue == value) continue;
            result += this.keys[i].hashCode() ^ Long.hashCode(value);
        }
        return result;
    }

    @Override
    public long replace(K key, long value) {
        long curValue = this.getValue(key);
        if (curValue != this.missingValue) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(K key, long oldValue, long newValue) {
        long curValue = this.getValue(key);
        if (curValue == this.missingValue || curValue != oldValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        Object[] tempKeys = new Object[newCapacity];
        long[] tempValues = new long[newCapacity];
        Arrays.fill(tempValues, this.missingValue);
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            long value = this.values[i];
            if (this.missingValue == value) continue;
            K key = this.keys[i];
            int newHash = Hashing.hash(key, mask);
            while (this.missingValue != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (this.missingValue == this.values[index &= mask]) break;
            int hash = Hashing.hash(this.keys[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.values[index] = this.missingValue;
            deleteIndex = index;
        }
    }

    public final class EntryIterator<T>
    extends AbstractIterator<Map.Entry<T, Long>>
    implements Map.Entry<T, Long> {
        @Override
        public Map.Entry<T, Long> next() {
            this.findNext();
            return this;
        }

        @Override
        public T getKey() {
            return (T)Object2LongHashMap.this.keys[this.position()];
        }

        public long getLongValue() {
            return Object2LongHashMap.this.values[this.position()];
        }

        @Override
        public Long getValue() {
            return this.getLongValue();
        }

        @Override
        public Long setValue(Long value) {
            return this.setValue((long)value);
        }

        @Override
        public long setValue(long value) {
            if (value == Object2LongHashMap.this.missingValue) {
                throw new IllegalArgumentException("Cannot accept missingValue");
            }
            int pos = this.position();
            long oldValue = Object2LongHashMap.this.values[pos];
            ((Object2LongHashMap)Object2LongHashMap.this).values[pos] = value;
            return oldValue;
        }
    }

    public final class KeyIterator<T>
    extends AbstractIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)Object2LongHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Object2LongHashMap.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T>,
    Serializable {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Object2LongHashMap.this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            long[] values = Object2LongHashMap.this.values;
            int mask = values.length - 1;
            this.isPositionValid = false;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (Object2LongHashMap.this.missingValue == values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((Object2LongHashMap)Object2LongHashMap.this).values[position] = Object2LongHashMap.this.missingValue;
            --Object2LongHashMap.this.size;
            Object2LongHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        final void reset() {
            int capacity;
            this.remaining = Object2LongHashMap.this.size;
            long[] values = Object2LongHashMap.this.values;
            int i = capacity = values.length;
            if (Object2LongHashMap.this.missingValue != values[capacity - 1]) {
                for (i = 0; i < capacity && Object2LongHashMap.this.missingValue != values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    public final class EntrySet<T>
    extends AbstractSet<Map.Entry<T, Long>>
    implements Serializable {
        private final EntryIterator<T> iterator;

        public EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<T, Long>> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Long>
    implements Serializable {
        private final ValueIterator iterator;

        public ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2LongHashMap.this.containsValue(o);
        }

        public ValueIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }
    }

    public final class KeySet<T>
    extends AbstractSet<T>
    implements Serializable {
        private final KeyIterator<T> iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2LongHashMap.this.containsKey(o);
        }

        @Override
        public KeyIterator<T> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            return Object2LongHashMap.this.missingValue != Object2LongHashMap.this.removeKey(o);
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }
    }
}

