/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Long2ObjectHashMap<V>
implements Map<Long, V>,
Serializable {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private long[] keys;
    private Object[] values;
    private ValueCollection<V> valueCollection;
    private KeySet keySet;
    private EntrySet<V> entrySet;

    public Long2ObjectHashMap() {
        this(8, 0.55f);
    }

    public Long2ObjectHashMap(int initialCapacity, float loadFactor) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.keys = new long[capacity];
        this.values = new Object[capacity];
    }

    public Long2ObjectHashMap(Long2ObjectHashMap<V> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.keys = (long[])mapToCopy.keys.clone();
        this.values = (Object[])mapToCopy.values.clone();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    public boolean containsKey(long key) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (null != value) {
            for (Object v : this.values) {
                if (!value.equals(v)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Long)key);
    }

    public V get(long key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index]) && key != this.keys[index]) {
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V computeIfAbsent(long key, LongFunction<? extends V> mappingFunction) {
        V value = this.get(key);
        if (value == null && (value = mappingFunction.apply(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public V put(Long key, V value) {
        return this.put((long)key, value);
    }

    @Override
    public V put(long key, V value) {
        Objects.requireNonNull(value, "Value cannot be null");
        Object oldValue = null;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (null == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Long)key);
    }

    public V remove(long key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index])) {
            if (key == this.keys[index]) {
                this.values[index] = null;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.values, null);
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            sb.append(this.keys[i]);
            sb.append('=');
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = this.values[i];
            if (null == thisValue || null != (thatValue = that.get(this.keys[i])) && thisValue.equals(thatValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            result += Long.hashCode(this.keys[i]) ^ value.hashCode();
        }
        return result;
    }

    @Override
    public V replace(long key, V value) {
        V curValue = this.get(key);
        if (curValue != null) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(long key, V oldValue, V newValue) {
        V curValue = this.get(key);
        if (curValue == null || !Objects.equals(curValue, oldValue)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        long[] tempKeys = new long[newCapacity];
        Object[] tempValues = new Object[newCapacity];
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            long key = this.keys[i];
            int newHash = Hashing.hash(key, mask);
            while (null != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (null == this.values[index &= mask]) break;
            int hash = Hashing.hash(this.keys[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.values[index] = null;
            deleteIndex = index;
        }
    }

    public class EntryIterator<T>
    extends AbstractIterator<Map.Entry<Long, T>>
    implements Map.Entry<Long, T> {
        @Override
        public Map.Entry<Long, T> next() {
            this.findNext();
            return this;
        }

        @Override
        public Long getKey() {
            return Long2ObjectHashMap.this.keys[this.position()];
        }

        @Override
        public T getValue() {
            return (T)Long2ObjectHashMap.this.values[this.position()];
        }

        @Override
        public T setValue(T value) {
            Objects.requireNonNull(value);
            int pos = this.position();
            Object oldValue = Long2ObjectHashMap.this.values[pos];
            ((Long2ObjectHashMap)Long2ObjectHashMap.this).values[pos] = value;
            return (T)oldValue;
        }
    }

    public class KeyIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Long2ObjectHashMap.this.keys[this.position()];
        }
    }

    public class ValueIterator<T>
    extends AbstractIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)Long2ObjectHashMap.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T>,
    Serializable {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Long2ObjectHashMap.this.values.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            Object[] values = Long2ObjectHashMap.this.values;
            int mask = values.length - 1;
            this.isPositionValid = false;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (null == values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((Long2ObjectHashMap)Long2ObjectHashMap.this).values[position] = null;
            --Long2ObjectHashMap.this.size;
            Long2ObjectHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        final void reset() {
            int capacity;
            this.remaining = Long2ObjectHashMap.this.size;
            Object[] values = Long2ObjectHashMap.this.values;
            int i = capacity = values.length;
            if (null != values[capacity - 1]) {
                for (i = 0; i < capacity && null != values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    class EntrySet<T>
    extends AbstractSet<Map.Entry<Long, T>>
    implements Serializable {
        private final EntryIterator<T> iterator;

        EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<Long, T>> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }
    }

    class ValueCollection<T>
    extends AbstractCollection<T>
    implements Serializable {
        private final ValueIterator<T> iterator;

        ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectHashMap.this.containsValue(o);
        }

        @Override
        public ValueIterator<T> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }
    }

    public class KeySet
    extends AbstractSet<Long>
    implements Serializable {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectHashMap.this.containsKey(o);
        }

        public boolean contains(long key) {
            return Long2ObjectHashMap.this.containsKey(key);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            return null != Long2ObjectHashMap.this.remove(o);
        }

        public boolean remove(long key) {
            return null != Long2ObjectHashMap.this.remove(key);
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }
    }
}

